<?php
/** 
 * The theme footer.
 * 
 */
?>

<section class="footer-wrapper" id="footer">
  <div class="custom-container">

    <div class="footer-top">
      <div class="row">
        <?php
        $args = [
          'post_type'      => 'general_info',
          'posts_per_page' => 1
        ];
        $info_query = new WP_Query($args);

        if( $info_query->have_posts() ):
          while( $info_query->have_posts() ): $info_query->the_post();
        ?>

        <!-- Column 1: Logo, Newsletter, Social -->
        <div class="col-xl-4 col-lg-6 col-md-12 col-sm-12 col-12 foot-col">
          <div class="footer-brand-wrap">
            <a href="<?php echo esc_url(home_url('/')); ?>" class="footer-logo-link">
			  <?php 
				if (has_post_thumbnail()) {
				  the_post_thumbnail('full', ['class' => 'footer-logo', 'alt' => get_bloginfo('name')]);
				} else {
				  echo '<img src="' . get_template_directory_uri() . '/assets/img/logo.png" alt="' . esc_attr(get_bloginfo('name')) . '" 						class="footer-logo">';
				}
			  ?>
			</a>

            
            <div class="newsletter-wrap">
              <h4>Subscribe to Our Newsletter</h4>
              <p>Subscribe to our newsletter and be the first to discover new gift collections, seasonal updates, and expert tips on thoughtful gifting.</p>
              <form class="newsletter-form">
                <input type="email" name="email" placeholder="Enter your email" required>
                <button type="submit">Subscribe</button>
              </form>
              <p>By subscribing, you agree to our <a href="/privacy-policy">Privacy Policy</a></p>
            </div>

            <div class="footer-social-icons">
              <?php if (get_field('facebook')): ?>
                <a href="<?php the_field('facebook'); ?>" target="_blank"><i class="fa-brands fa-facebook-f"></i></a>
              <?php endif; ?>
              <?php if (get_field('instagram')): ?>
                <a href="<?php the_field('instagram'); ?>" target="_blank"><i class="fa-brands fa-instagram"></i></a>
              <?php endif; ?>
              <?php if (get_field('linkedin')): ?>
                <a href="<?php the_field('linkedin'); ?>" target="_blank"><i class="fa-brands fa-linkedin-in"></i></a>
              <?php endif; ?>
              <?php if (get_field('twitter')): ?>
                <a href="<?php the_field('twitter'); ?>" target="_blank"><i class="fa-brands fa-x-twitter"></i></a>
              <?php endif; ?>
              <?php if (get_field('youtube')): ?>
                <a href="<?php the_field('youtube'); ?>" target="_blank"><i class="fa-brands fa-youtube"></i></a>
              <?php endif; ?>
            </div>
          </div>
        </div>

        <!-- Column 2: Company -->
        <div class="col-xl-3 col-lg-6 col-md-6 col-sm-6 col-12 foot-col">
          <div class="footer-menu-wrap">
            <h2>The Company</h2>
            <?php 
            wp_nav_menu([
              'theme_location' => 'max_mega_menu_2',
              'menu_class'     => 'footer-list',
              'container'      => false,
            ]); 
            ?>
          </div>
        </div>
		  
		<!-- Column 3: Services -->
		<div class="col-xl-2 col-lg-6 col-md-6 col-sm-6 col-12 foot-col">
          <div class="footer-menu-wrap">
            <h2>Services</h2>
            <?php 
            wp_nav_menu([
              'theme_location' => 'max_mega_menu_1',
              'menu_class'     => 'footer-list',
              'container'      => false,
            ]); 
            ?>
          </div>
        </div>

        <!-- Column 4:  Policies -->
<!--         <div class="col-xl-2 col-lg-6 col-md-6 col-sm-6 col-12 foot-col">
          <div class="footer-menu-wrap">
            <h2>Policies</h2>
            <?php 
            wp_nav_menu([
              'theme_location' => 'max_mega_menu_4',
              'menu_class'     => 'footer-list',
              'container'      => false,
            ]); 
            ?>
          </div>
        </div> -->

        <!-- Column 5: Contact -->
        <div class="col-xl-3 col-lg-6 col-md-6 col-sm-6 col-12 foot-col">
          <div class="footer-contact-wrap">
            <h2>Contact Us</h2>

            <?php if(get_field('email')): ?>
              <p><i class="hgi hgi-stroke hgi-mail-01"></i> 
                <a href="mailto:<?php the_field('email'); ?>"><?php the_field('email'); ?></a>
              </p>
            <?php endif; ?>

            <?php if(get_field('phone_number')): ?>
              <p><i class="hgi hgi-stroke hgi-call-ringing-04"></i>
                <a href="tel:<?php echo preg_replace('/\D+/', '', get_field('phone_number')); ?>"><?php the_field('phone_number'); ?></a>
              </p>
            <?php endif; ?>

            <?php if(get_field('address')): ?>
              <p><i class="hgi hgi-stroke hgi-location-06"></i> 
                <a href="https://www.google.com/maps/search/?api=1&query=<?php echo urlencode(get_field('address')); ?>" target="_blank">
                  <?php the_field('address'); ?>
                </a>
              </p>
            <?php endif; ?>
          </div>
        </div>

        <?php endwhile; wp_reset_postdata(); endif; ?>
      </div>
    </div>

    <!-- Footer Bottom -->
    <div class="footer-bottom">
        <div class="row footer-bottom-inner">
          <div class="col-lg-6 col-md-6 col-sm-12 footer-bottom-col-left">
            <p>Copyright © <?php echo date('Y'); ?> Artara Gifts. All rights reserved.</p>
          </div>
          <div class="col-lg-6 col-md-6 col-sm-12 footer-bottom-col-right">
            <p class="crafted"><a href="https://www.madebybeyond.com/" target="_blank">Made by Beyond</a></p>
          </div>
        </div>
    </div>

  </div>
</section>

<?php
// Query the "General Info" post
$args = array(
  'post_type'      => 'general_info',
  'posts_per_page' => 1
);
$general_info_query = new WP_Query($args);

if ($general_info_query->have_posts()) :
  while ($general_info_query->have_posts()) : $general_info_query->the_post();
    $whatsapp_number = get_field('whatsapp'); // Example: +972 (123) 456 7890
    $whatsapp_icon   = get_field('whatsapp_icon'); // Image URL field
  endwhile;
  wp_reset_postdata();
endif;
?>

<?php if (!empty($whatsapp_number)) : ?>
  <?php $clean_number = preg_replace('/\D+/', '', $whatsapp_number); // Remove non-digits ?>
  <div class="floating-whatsapp">
    <div class="whatsapp-text">Click Here to Start Enquiry!</div>
    <a href="https://wa.me/<?php echo esc_attr($clean_number); ?>" target="_blank" rel="noopener" aria-label="Chat on WhatsApp" class="whatsapp-icon">
      <?php if (!empty($whatsapp_icon)) : ?>
        <img src="<?php echo esc_url($whatsapp_icon); ?>" alt="WhatsApp">
      <?php endif; ?>
    </a>
  </div>
<?php endif; ?>

<script>
document.addEventListener("scroll", function() {
  const waFloat = document.querySelector(".floating-whatsapp");
  if (!waFloat) return;
  if (window.scrollY > 100) {
    waFloat.classList.add("hide-text");
  } else {
    waFloat.classList.remove("hide-text");
  }
});
</script>



<!--.page-container-->
        <?php wp_footer(); ?> 
<script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
		<script>
  AOS.init();
</script>




    </body>
</html>
