<?php
/** 
 * Functions file.
 * 
 * To getting start design the theme, please begins by reading on this link. https://codex.wordpress.org/Theme_Development
 * You can make this theme as your parent theme (design new by modify this theme and make it yours).
 * But I recommend that you use this theme as parent and create your new child theme.
 * 
 * Learn more about template hierarchy, please read on this link. https://developer.wordpress.org/themes/basics/template-hierarchy/
 * 
 * @package bootstrap-basic4
 */


// Required WordPress variable
if (!isset($content_width)) {
    $content_width = 1140;// this will be override again in inc/classes/BootstrapBasic4.php `detectContentWidth()` method.
}


// Configurations ----------------------------------------------------------------------------
// Left sidebar column size. Bootstrap have 12 columns this sidebar column size must not greater than 12.
if (!isset($bootstrapbasic4_sidebar_left_size)) {
    $bootstrapbasic4_sidebar_left_size = apply_filters('bootstrap_basic4_column_left', 3);
}
// Right sidebar column size.
if (!isset($bootstrapbasic4_sidebar_right_size)) {
    $bootstrapbasic4_sidebar_right_size = apply_filters('bootstrap_basic4_column_right', 3);
}
// Once you specified left and right column size, while widget was activated in all or some sidebar the main column size will be calculate automatically from these size and widgets activated.
// For example: you use only left sidebar (widgets activated) and left sidebar size is 4, the main column size will be 12 - 4 = 8.
// 
// Title separator. Please note that this value maybe able overriden by other plugins.
if (!isset($bootstrapbasic4_title_separator)) {
    $bootstrapbasic4_title_separator = '|';
}


// Require, include files ---------------------------------------------------------------------
require get_template_directory() . '/inc/classes/Autoload.php';
require get_template_directory() . '/inc/functions/include-functions.php';

// Setup auto load for load the class files without manually include file by file.
$Autoload = new \BootstrapBasic4\Autoload();
$Autoload->register();
$Autoload->addNamespace('BootstrapBasic4', get_template_directory() . '/inc/classes');
unset($Autoload);

// Call to actions/filters of the theme to enable features, register sidebars, enqueue scripts and styles.
$BootstrapBasic4 = new \BootstrapBasic4\BootstrapBasic4();
$BootstrapBasic4->addActionsFilters();
unset($BootstrapBasic4);

// Call to actions/filters of theme hook to hook into WordPress and make changes to the theme.
$Bsb4Hooks = new \BootstrapBasic4\Hooks\Bsb4Hooks();
$Bsb4Hooks->addActionsFilters();
unset($Bsb4Hooks);

// Call to auto register widgets.
$AutoRegisterWidgets = new BootstrapBasic4\Widgets\AutoRegisterWidgets();
$AutoRegisterWidgets->registerAll();
unset($AutoRegisterWidgets);

// Call to actions/filters of theme hook to hook into WordPress widgets.
$WidgetHooks = new \BootstrapBasic4\Hooks\WidgetHooks();
$WidgetHooks->addActionsFilters();
unset($WidgetHooks);

// Display theme help page for admin.
$ThemeHelp = new \BootstrapBasic4\Controller\ThemeHelp();
$ThemeHelp->addActionsFilters();
unset($ThemeHelp);

add_filter('wpseo_breadcrumb_separator', 'custom_breadcrumb_separator');
function custom_breadcrumb_separator($sep) {
    return ' <span class="breadcrumb-sep">│</span> '; 
}

add_filter( 'wpseo_breadcrumb_links', 'add_services_breadcrumb_link' );
function add_services_breadcrumb_link( $links ) {
    if ( is_singular('your_custom_post_type') ) {
        $breadcrumb[] = array(
            'url' => get_permalink(get_page_by_path('services')),
            'text' => 'Services',
        );
        array_splice( $links, 1, 0, [$breadcrumb[0]] );
    }
    return $links;
}


function enqueue_slick_slider_assets() {
wp_enqueue_style('slick-css', 'https://cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick.css', array(), '1.8.1');
wp_enqueue_style('slick-theme-css', 'https://cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick-theme.css', array('slick-css'), '1.8.1');

wp_enqueue_script('slick-js', 'https://cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick.min.js', array('jquery'), '1.8.1', true);
wp_enqueue_script('custom-slider', get_template_directory_uri() . '/assets/js/custom-slider.js', array('jquery', 'slick-js'), null, true);
}
add_action('wp_enqueue_scripts', 'enqueue_slick_slider_assets');

// woocommerce
add_action('after_setup_theme', 'mytheme_add_woocommerce_support');
function mytheme_add_woocommerce_support() {
    add_theme_support('woocommerce');
}

// Disable Default WooCommerce Styles

add_filter('woocommerce_enqueue_styles', '__return_false');



add_action('woocommerce_single_product_summary', 'render_giftbox_acf_fields', 5);
function render_giftbox_acf_fields() {
    global $product;

    if (!$product) return;

    $giftbox_title = get_field('giftbox_title', $product->get_id());
    $giftbox_desc  = get_field('giftbox_description', $product->get_id());
    $giftbox_img   = get_field('giftbox_image', $product->get_id());

    if ($giftbox_img) {
        echo '<div class="giftbox-image">';
        echo wp_get_attachment_image($giftbox_img, 'large');
        echo '</div>';
    }

    if ($giftbox_title) {
        echo '<h2 class="giftbox-title">' . esc_html($giftbox_title) . '</h2>';
    }

    if ($giftbox_desc) {
        echo '<p class="giftbox-description">' . esc_html($giftbox_desc) . '</p>';
    }
}


add_action('init', function () {
    if (taxonomy_exists('product_cat')) {
        register_taxonomy_for_object_type('product_cat', 'product');
    }
}, 20);

