<?php
/**
 * The theme header.
 * 
 * @package bootstrap-basic4
 */

$container_class = apply_filters('bootstrap_basic4_container_class', 'container');
if (!is_scalar($container_class) || empty($container_class)) {
    $container_class = 'container';
}
?>
<!DOCTYPE html>
<html class="no-js" <?php language_attributes(); ?>>
  <head>
		<meta charset="<?php bloginfo('charset'); ?>">
        <meta http-equiv="x-ua-compatible" content="ie=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

        <link rel="profile" href="http://gmpg.org/xfn/11" />
        <link rel="pingback" href="<?php bloginfo('pingback_url'); ?>" />
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.7.2/css/all.min.css" integrity="sha512-..." 					crossorigin="anonymous" />
        <link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.8.1/slick.min.css"/>
        <link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.8.1/slick-theme.min.css"/>
        <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">      
        <link rel="stylesheet" href="https://cdn.hugeicons.com/font/hgi-stroke-rounded.css">
        <link href="https://fonts.cdnfonts.com/css/sf-pro-display" rel="stylesheet">
        <link rel="stylesheet" href="https://unpkg.com/swiper/swiper-bundle.min.css" />
        <link rel="preconnect" href="https://fonts.googleapis.com">
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
        <link href="https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&family=Roboto:ital,wght@0,100..900;1,100..900&display=swap" rel="stylesheet">
        <link href="https://fonts.cdnfonts.com/css/sf-pro-display" rel="stylesheet">
        <link href="https://db.onlinewebfonts.com/c/32aac839ec8704951d812018c43e298d?family=TAN+-+Angleton+Regular" rel="stylesheet">
        

        <script src="<?php echo get_template_directory_uri(); ?>/assets/js/jquery.min.js"></script> 
        <script src="<?php echo get_template_directory_uri(); ?>/assets/js/slick.js"></script> 
        <script src="https://unpkg.com/swiper/swiper-bundle.min.js"></script>

        <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick.css"/>
        <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick-theme.css"/>
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css" />

        <script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js"></script>
        <script type="text/javascript" src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
        <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick.min.js"></script>
	  
	  

        <script type="text/javascript">
            jQuery("document").ready(function ($) {
            $(window).scroll(function () {
                if ($(this).scrollTop() > 0) {
                    $('body').addClass("f-nav");
                } else {
                    $('body').removeClass("f-nav");
                }
            });
            });
        </script>

		
        <?php wp_head(); ?> 
    </head>
    <body <?php body_class( is_front_page() ? 'home-background' : '' ); ?>>

  
        
        <div class="page-container">
        <div class="header-wrapper">
            <div class="menu-logoheader">
                <div class="custom-container">
                    <div class="row">
                        <div class="col-lg-3 col-md-6 col-sm-6 col-5 header-toogle-menu"><?php wp_nav_menu( array( 'theme_location' => 'max_mega_menu_3' ) ); ?></div>
                        <div class="col-lg-12 col-md-6 col-sm-6 col-7 header-logo">
                            <a href="<?php echo home_url();?>">
                           <?php query_posts('post_type=general_info&order=ASC&showposts=100'); ?>
                                <?php while (have_posts()) : the_post(); ?>
                                    <?php if ( has_post_thumbnail() && ! post_password_required() ) : ?>
                                    <?php the_post_thumbnail('full'); ?>
                                    <?php endif; ?>
                                <?php endwhile; ?>
                            <?php wp_reset_query();?>
                            </a>
                        </div>


                    </div>
                </div>
            </div>
            <div class="main-menu">
                <?php wp_nav_menu( array( 'theme_location' => 'primary' ) ); ?>
            </div>
        </div>
            

