<?php
/**
 * The main template file.
 * 
 * To override home page (for listing latest post) add home.php into the theme.<br>
 * If front page displays is set to static, the index.php file will be use.<br>
 * If front-page.php exists, it will be override any home page file such as home.php, index.php.<br>
 * To learn more please go to https://developer.wordpress.org/themes/basics/template-hierarchy/ .
 * 
 * @package bootstrap-basic4
 */


// begins template. -------------------------------------------------------------------------
get_header();
?> 


<div class="innerpage-header">
<img src="<?php echo get_template_directory_uri(); ?>/assets/img/applexinner.webp" alt="applex-inner-banner">
        <div class="pageheading-middle">
            <div class="container">
            <h2><font><?php the_title(); ?></font></h2>
            <?php if ( function_exists('yoast_breadcrumb') ) { 
            yoast_breadcrumb('<h6 id="breadcrumbs">','</h6>'); 
            } ?>
            </div>
        </div>
</div>
       

<div class="container blog-page inner-wrapper">
    <div class="row">
    <?php query_posts('post_type=post&order=Dec&showposts=50'); ?>
                    <?php while (have_posts()) : the_post(); ?>
                    <div class="col-lg-4 col-md-4">
                        <a href="<?php the_permalink(); ?>" class="blog-inner-item">
                            <span>
                                <?php if ( has_post_thumbnail() && ! post_password_required() ) : ?>
                                <?php the_post_thumbnail('large'); ?>
                                <?php endif; ?> 
                            </span>
                            <div class="blog-detail-wrapper">
                                <h5><?php the_title(); ?></h5>
                                <h6><?php echo date("F j, Y");?></h6>
                                <p><?php
                                    $content = get_the_content();
                                    $limited_content = mb_substr(wp_strip_all_tags($content), 0, 100) . '...';
                                    echo $limited_content;
                                ?></p>
                            </div>
                        </a>
                    </div>
                    <?php endwhile; ?>
    	            <?php wp_reset_query();?>
    </div>
</div>

<?php
get_footer();