<?php
/** 
 * The page template file.<br>
 * This file works as display page content (post type "page") and its comments.
 * 
 * @package bootstrap-basic4
 */


// begins template. -------------------------------------------------------------------------
get_header();
?> 




<!-- about banner section start -->

<section class="about-banner-wrap">
  <?php 
    $vid      = get_field('background_video');
    $heading  = get_field('about_title');
    $subtext  = get_field('about_subtext');
    $featured = get_the_post_thumbnail_url(get_the_ID(), 'full');
  ?>

  <div class="about-banner-media">
    <?php if (!empty($vid)) : ?>
      <video autoplay muted loop playsinline poster="<?php echo esc_url($featured); ?>">
        <source src="<?php echo esc_url($vid); ?>" type="video/mp4">
      </video>
    <?php elseif ($featured) : ?>
      <img src="<?php echo esc_url($featured); ?>" alt="<?php the_title_attribute(); ?>">
    <?php endif; ?>
  </div>

  <div class="about-banner-overlay"></div>

  <div class="about-banner-content">
    <?php if ($heading): ?>
      <h1><?php echo esc_html($heading); ?></h1>
    <?php endif; ?>
    <?php if ($subtext): ?>
      <p><?php echo esc_html($subtext); ?></p>
    <?php endif; ?>
  </div>
</section>


<!-- about banner section end -->

<!-- about story section start -->

<section class="about-story-wrap">
  <div class="custom-container">
	<h2 class="about-story-title">How It All Began</h2>
    <div class="about-story-slider">
      <?php
        $args = array(
          'post_type'      => 'about_stories',
          'posts_per_page' => -1,
          'order'          => 'ASC',
        );
        $slides = new WP_Query($args);

        if ($slides->have_posts()) :
          while ($slides->have_posts()) : $slides->the_post();
            $featured = get_the_post_thumbnail_url(get_the_ID(), 'large');
      ?>
        <div class="story-slide">
          <div class="story-slide-inner">
            <div class="story-content-box">
              <div class="story-excerpt">
				<h2><?php the_title(); ?></h2>
                <?php the_content(); ?>
              </div>
            </div>
            <div class="story-image-box">
              <?php if ($featured): ?>
                <img src="<?php echo esc_url($featured); ?>" alt="<?php the_title_attribute(); ?>">
              <?php endif; ?>
            </div>
          </div>
        </div>
      <?php endwhile; wp_reset_postdata(); endif; ?>
    </div>
  </div>
</section>

<script>
jQuery(document).ready(function($){
  var $slider = $('.about-story-slider');

  $slider.on('init', function(event, slick){
    $(slick.$slides[0]).addClass('active');
  });

  $slider.slick({
    dots: false,
    arrows: true,
    infinite: true,
    autoplay: true,
    autoplaySpeed: 15000,
    speed: 500,
    fade: false,
    adaptiveHeight: false, // off for overlapping layout
    pauseOnHover: false,
    pauseOnFocus: false
  });

  $slider.on('beforeChange', function(event, slick, currentSlide, nextSlide){
    $(slick.$slides).removeClass('active');
  });

  $slider.on('afterChange', function(event, slick, currentSlide){
    $(slick.$slides[currentSlide]).addClass('active');
  });
});

</script>


<!-- about story section end -->

<!-- about team section start -->
<!-- 
<section class="about-team-wrap">
  <div class="custom-container">
    <h2 class="about-team-title">The People Behind the Gifts</h2>

    <div class="row">
      <?php
      $team_query = new WP_Query(array(
        'post_type'      => 'team',
        'posts_per_page' => -1,
        'orderby'        => 'menu_order',
        'order'          => 'ASC',
      ));

      if ($team_query->have_posts()) :
        while ($team_query->have_posts()) :
          $team_query->the_post();

          $position  = get_field('team_position');
          $bio       = get_field('team_bio');
          $linkedin  = get_field('linkedin');
          $instagram = get_field('instagram');
      ?>
          <div class="col-xl-3 col-lg-4 col-md-6 col-sm-6 col-12 about-team-card-col">
            <div class="about-team-card">
              <div class="about-team-image-wrap">
                <?php if (has_post_thumbnail()) : ?>
                  <?php the_post_thumbnail('medium', array('class' => 'about-team-image')); ?>
                <?php endif; ?>
              </div>

              <div class="about-team-info">
                <h3 class="about-team-name"><?php the_title(); ?></h3>

                <?php if ($position) : ?>
                  <p class="about-team-position"><?php echo esc_html($position); ?></p>
                <?php endif; ?>

                <?php if ($bio) : ?>
                  <p class="about-team-bio"><?php echo esc_html($bio); ?></p>
                <?php endif; ?>
              </div>
            </div>
          </div>
      <?php
        endwhile;
        wp_reset_postdata();
      endif;
      ?>
    </div>
  </div>
</section> -->

<!-- about team section end -->

<!-- about brand values section start -->

<section class="brand-values-wrap">
  <div class="custom-container">
    <h2 class="brand-values-title">What Matters to Us</h2>

    <div class="row">
      <?php
      $values_query = new WP_Query(array(
        'post_type'      => 'brand_values',
        'posts_per_page' => -1,
        'orderby'        => 'menu_order',
        'order'          => 'ASC',
      ));

      if ($values_query->have_posts()) :
        while ($values_query->have_posts()) :
          $values_query->the_post();
          $icon = get_field('value_icon'); // URL of gold line-art icon
          $desc = get_field('value_description'); // Optional
      ?>
          <div class="col-lg-3 col-md-6 col-sm-6 col-12 brand-value-col">
            <div class="brand-value-card">
              <div class="brand-value-icon">
                <?php if ($icon) : ?>
                  <img src="<?php echo esc_url($icon); ?>" alt="<?php echo esc_attr(get_the_title()); ?>">
                <?php endif; ?>
              </div>
              <h3 class="brand-value-title"><?php the_title(); ?></h3>
              <div class="brand-value-desc"><?php the_content(); ?></div>
            </div>
          </div>
      <?php
        endwhile;
        wp_reset_postdata();
      endif;
      ?>
    </div>
  </div>
</section>

<!-- about brand values section end -->

<!-- about artisan section start -->

<?php
$makers = new WP_Query(array(
  'post_type'      => 'artisans',
  'posts_per_page' => -1,
  'orderby'        => 'menu_order',
  'order'          => 'ASC',
));

if ($makers->have_posts()) : ?>
  <section class="artisan-wrap">
    <div class="custom-container">
      <div class="carousel-header d-flex justify-content-between align-items-center">
        <h2 class="carousel-title">Meet the Makers</h2>
        <div class="carousel-arrows">
          <button class="prev-arrow"><i class="hgi hgi-stroke hgi-arrow-left-double"></i></button>
          <button class="next-arrow"><i class="hgi hgi-stroke hgi-arrow-right-double"></i></button>
        </div>
      </div>
    </div>

    <div class="container-fluid">
      <div class="artisan-slider">
        <?php
        while ($makers->have_posts()) :
          $makers->the_post();
          $craft = get_the_content();
          $link = get_field('artisan_link');
          $profile = get_the_post_thumbnail_url(get_the_ID(), 'large');
        ?>
          <div class="artisan-card">
            <div class="artisan-img">
              <?php if ($profile) : ?>
                <img src="<?php echo esc_url($profile); ?>" alt="<?php the_title_attribute(); ?>">
              <?php endif; ?>
            </div>
            <div class="artisan-info">
              <h3 class="artisan-name"><?php the_title(); ?></h3>
              <?php if ($craft) : ?>
                <div class="artisan-craft"><?php echo wp_kses_post($craft); ?></div>
              <?php endif; ?>
              <?php if ($link) : ?>
                <a href="<?php echo esc_url($link); ?>" target="_blank" class="artisan-link">View Profile</a>
              <?php endif; ?>
            </div>
          </div>
        <?php endwhile; ?>
      </div>
    </div>
  </section>

  <script>
  jQuery(document).ready(function ($) {
    $('.artisan-slider').slick({
      slidesToShow: 4,
      slidesToScroll: 1,
      infinite: true,
      autoplay: true,
      autoplaySpeed: 3000,
      speed: 800,
      arrows: true,
      prevArrow: $('.prev-arrow'),
      nextArrow: $('.next-arrow'),
      dots: false,
      pauseOnHover: false,
      pauseOnFocus: false,
      responsive: [
        { breakpoint: 1200, settings: { slidesToShow: 3 } },
        { breakpoint: 992, settings: { slidesToShow: 2 } },
        { breakpoint: 576, settings: { slidesToShow: 1 } }
      ]
    });
  });
  </script>

<?php
endif;
wp_reset_postdata();
?>

<!-- about artisan section end -->

<!-- about CTA prefooter section start -->
<!-- 
<section class="prefooter-cta-wrap">
  <div class="custom-container">
    <div class="prefooter-inner">
      <h2 class="prefooter-title">Let’s Create Something Thoughtful Together</h2>
      <p class="prefooter-text">
        Whether it’s a personal moment or a corporate celebration, we’re here to help you give with heart.
      </p>

      <div class="prefooter-buttons">
        <a href="#" class="btn primary-btn">Create a Custom Gift</a>
        <a href="#" class="btn secondary-btn">Start a Corporate Order</a>
        <a href="#" class="btn tertiary-btn">Explore our Gift Boxes</a>
      </div>
    </div>
  </div>
</section>

 -->
<!-- about CTA prefooter section end -->

<?php
get_footer();