<?php
/**
 * The main template file.
 * 
 * To override home page (for listing latest post) add home.php into the theme.<br>
 * If front page displays is set to static, the index.php file will be use.<br>
 * If front-page.php exists, it will be override any home page file such as home.php, index.php.<br>
 * To learn more please go to https://developer.wordpress.org/themes/basics/template-hierarchy/ .
 * 
 * @package bootstrap-basic4
 */


// begins template. -------------------------------------------------------------------------
get_header();
?> 



<div class="innerpage-header">
    <img src=" <?php the_field('page-banner'); ?>">
    <div class="inner-banner-head">
        <h4><?php the_title(); ?></h4>
        <p><?php the_field('banner-paragraph'); ?></p>
 
    <div class="pageheading-middle" >
        <div class="custom-container d-flex align-items-center justify-content-center flex-column text-center" style="height: 100%;">
            <?php if ( function_exists('yoast_breadcrumb') ) { 
                yoast_breadcrumb('<h6 id="breadcrumbs">','</h6>'); 
            } ?>
        </div>
    </div>
       </div>
</div>
       


<div class="blog-page inner-wrapper">
    <h6>INSTANT UPDATES</h6>
    <h1>Your Guide to Elegant Escapes</h1>
<div class="blog-listing-wrapper">
   <div class="custom-container">
            <h2>Our Latest<br> Blogs <img src="<?php echo get_template_directory_uri();?>/assets/img/blog-side.webp" alt=" " decoding="async" loading="lazy"></h2>
     <div class="row">
    <?php query_posts('post_type=post&order=Dec&showposts=50'); ?>
        <?php while (have_posts()) : the_post(); ?>
        <div class="col-lg-3 col-md-4 col-12">
            <div class="inner-blog-item">
                <a href="<?php the_permalink(); ?>" class="blog-inner-item">
                    <div class="blog-main-img">
                        <?php if ( has_post_thumbnail() && ! post_password_required() ) : ?>
                            <?php the_post_thumbnail('large'); ?>
                        <?php endif; ?>

                    </div>

                    <div class="blog-detail-wrapper">
                        <div class="date">
                            <p><?php echo get_the_date("j F Y"); ?></p>
                        </div>
                        <h5><?php the_title(); ?></h5>
                        <p>
                            <?php
                                $content = get_the_content();
                                $limited_content = mb_substr(wp_strip_all_tags($content), 0, 70) . '...';
                                echo $limited_content;
                            ?>
                        </p>
                        <a href="<?php the_permalink(); ?>" class="readmore">Read Article <i class="fa-solid fa-arrow-right"></i></a>
                    </div>
                </a>
            </div>
        </div>

        <?php endwhile; ?>
        <?php wp_reset_query();?>
    </div>
   </div>
</div>
</div>

<?php
get_footer();