<?php
/**
 * The main template file.
 * 
 * To override home page (for listing latest post) add home.php into the theme.<br>
 * If front page displays is set to static, the index.php file will be use.<br>
 * If front-page.php exists, it will be override any home page file such as home.php, index.php.<br>
 * To learn more please go to https://developer.wordpress.org/themes/basics/template-hierarchy/ .
 * 
 * @package bootstrap-basic4
 */


// begins template. -------------------------------------------------------------------------
get_header();
?> 



<div class="innerpage-header">
    <img src=" <?php the_field('page-banner'); ?>">
    <div class="inner-banner-head">
        <div class="pageheading-middle" >
            <div class="custom-container d-flex align-items-center justify-content-center flex-column text-center" style="height: 100%;">
                <h4><?php the_title(); ?></h4>
                <?php if ( function_exists('yoast_breadcrumb') ) { 
                    yoast_breadcrumb('<h6 id="breadcrumbs">','</h6>'); 
                } ?>
            </div>
        </div>
    </div>
</div>
       

<section class="inner-faq-section">
  <div class="container">
    <div class="inner-faq-header">
      <h3 class="inner-faq-title">Frequently Asked Questions</h3>
      <p class="inner-faq-sub-title">
        Reach out to learn why producers, streamers, and music enthusiasts around the globe trust our services. We're here to help!
      </p>
    </div>
    <div class="inner-faq-wrapper">
      <div class="inner-faq-right">
        <div class="accordion" id="innerFaqAccordion">
          <?php
          $faq_query = new WP_Query([
              'post_type'      => 'faq',
              'posts_per_page' => 6,
              'order'          => 'ASC'
          ]);
          $count = 0;

          if ($faq_query->have_posts()) :
              while ($faq_query->have_posts()) : $faq_query->the_post();
                  $count++;
          ?>
              <div class="accordion-item">
                <h2 class="accordion-header" id="innerHeading<?php echo $count; ?>">
                  <button class="accordion-button collapsed" type="button" aria-expanded="false">
                    <?php the_title(); ?>
                  </button>
                </h2>
                <div id="innerCollapse<?php echo $count; ?>" class="accordion-collapse">
                  <div class="accordion-body">
                    <?php the_content(); ?>
                  </div>
                </div>
              </div>
          <?php
              endwhile;
              wp_reset_postdata();
          else :
              echo '<p>No FAQs found.</p>';
          endif;
          ?>
        </div>
      </div>
    </div>
  </div>
</section>

<!-- FAQ start -->

<script>
document.addEventListener("DOMContentLoaded", function () {
  const items = document.querySelectorAll(".accordion-item");

  items.forEach(item => {
    const button = item.querySelector(".accordion-button");
    const collapse = item.querySelector(".accordion-collapse");

    button.addEventListener("click", () => {
      const isOpen = collapse.classList.contains("show");

      // close all first (for one-at-a-time behavior)
      document.querySelectorAll(".accordion-collapse.show").forEach(openItem => {
        openItem.style.maxHeight = "0";
        openItem.classList.remove("show");
        openItem.previousElementSibling.querySelector(".accordion-button").classList.add("collapsed");
      });

      if (!isOpen) {
        collapse.style.maxHeight = collapse.scrollHeight + "px";
        collapse.classList.add("show");
        button.classList.remove("collapsed");
      }
    });
  });
});
</script>

<!-- FAQ ends -->

<?php
get_footer();