<?php
/** 
 * The page template file.<br>
 * This file works as display page content (post type "page") and its comments.
 * 
 * @package bootstrap-basic4
 **/


// begins template. -------------------------------------------------------------------------
get_header();
?> 



<!-- banner section starts -->

<div class="home-banner-wrap">
  <!-- Image Slider -->
  <div class="swiper banner-image-slider">
    <div class="swiper-wrapper">
      <?php query_posts('post_type=banner_content&order=ASC&showposts=10'); ?>
      <?php while (have_posts()) : the_post(); ?>
        <div class="swiper-slide">
          <div class="banner-image">
            <?php if (has_post_thumbnail() && !post_password_required()) : ?>
              <?php the_post_thumbnail('full'); ?>
            <?php endif; ?>
          </div>
        </div>
      <?php endwhile; wp_reset_query(); ?>
    </div>
  </div>

  <!-- Vertical Caption Slider -->
  <div class="home-caption-wrap">
    <div class="swiper caption-slider">
      <div class="swiper-wrapper">
        <?php query_posts('post_type=banner_content&order=ASC&showposts=10'); ?>
        <?php while (have_posts()) : the_post(); ?>
          <div class="swiper-slide">
            <div class="banner-caption-item">
              <h1><?php the_title(); ?></h1>
              <div class="caption-content"><?php the_content(); ?></div>
            </div>
          </div>
        <?php endwhile; wp_reset_query(); ?>
      </div>
    </div>
  </div>
</div>



<script>
document.addEventListener("DOMContentLoaded", function () {
  // Image Slider (horizontal)
  var bannerSlider = new Swiper(".banner-image-slider", {
    loop: true,
    speed: 1000,
    autoplay: {
      delay: 4000,
      disableOnInteraction: false,
    },
    effect: "slide",
  });

  // Caption Slider (vertical)
  var captionSlider = new Swiper(".caption-slider", {
    direction: "vertical",
    loop: true,
    speed: 1000,
    allowTouchMove: false,
    effect: "slide",
  });

  // Sync caption with image
  bannerSlider.on("slideChangeTransitionStart", function () {
    captionSlider.slideToLoop(bannerSlider.realIndex);
  });
});
</script>


<!-- banner section ends -->


<!-- artara moment starts -->

<section class="artara-moment-wrapper">
    <div class="custom-container">
        <h2>Share an Artara Moment</h2>
        <?php the_content(); ?>
    </div>
</section>

<!-- artara moment ends -->

<!-- corporate giftinig starts -->

<section class="corporate-gift-wrapper">
  <div class="container-fluid p-0">
    <h1>Corporate Gifting</h1>
    <div class="gifting-para">
      <?php the_field('corporate_para'); ?>
    </div>

    <div class="home-corporate-gifting">
      <div class="row justify-content-center">
        <?php
        query_posts('post_type=products&order=ASC&showposts=-1&product_cat=corporate-gifting');
        while (have_posts()) : the_post(); ?>
          <div class="col-lg-4 col-md-6 col-sm-12 corporate-gifting-col">
            <div class="corporate-gifting-item">
              <div class="corporate-img">
                <?php if (has_post_thumbnail() && !post_password_required()) : ?>
                  <?php the_post_thumbnail('large'); ?>
                <?php endif; ?>
              </div>

              <div class="corporate-overlay">
                <div class="corporate-text">
                  <h3 class="corporate-title"><?php the_title(); ?></h3>
                  <?php if ( $content = get_field('product_content') ) : ?>
					  <div class="corporate-desc">
						<p><?php echo wp_kses_post( $content ); ?></p>
					  </div>
					<?php endif; ?>

                </div>
                <a href="<?php the_permalink(); ?>" class="corporate-btn">Explore</a>
              </div>
            </div>
          </div>
        <?php endwhile;
        wp_reset_query(); ?>
      </div>
    </div>
  </div>
</section>


<!-- corporate giftinig ends -->

<!-- curve slider section starts -->


<section class="curve-slider-content-wrapper" 
  <?php if (get_field('curve_background_image')): ?>
    style="background-image: url('<?php the_field('curve_background_image'); ?>');"
  <?php endif; ?>>
  
  <div class="container-fluid">
    <div class="content">

      <!-- Star GIFs -->
      <?php 
      $star = get_field('curve_star'); 
      if ($star): ?>
        <img src="<?php echo esc_url($star); ?>" alt="star" class="star-star1">
        <img src="<?php echo esc_url($star); ?>" alt="star" class="star-star2">
      <?php endif; ?>

      <h1>Every gift is a ritual of connection</h1>
      <p>In a world of rushed gestures and forgettable hampers, Artara offers something more heartfelt. We curate thoughtful gifts that carry presence, gratitude, and care in every detail. Each box is made to feel personal: rooted in intention, wrapped with meaning, and designed to deepen the quiet bond between giver and receiver.</p>
    </div>
  </div>

  <div class="curve-slider-wrapper">
    <div class="curve-slider">
      <?php 
      $gallery = get_field('curve_slider_gallery');
      if ($gallery):
        foreach ($gallery as $image):
          // handle both URL and array returns
          $image_url = is_array($image) ? $image['url'] : $image;
          ?>
          <div><img src="<?php echo esc_url($image_url); ?>" alt=""></div>
        <?php endforeach;
      endif;
      ?>
    </div>
	  
  </div>
</section>

<script>
jQuery(document).ready(function($){
  $('.curve-slider').slick({
    slidesToShow: 6,
    slidesToScroll: 1,
    arrows: false,
    dots: false,
    infinite: true,
    autoplay: true,
    autoplaySpeed: 0,
    speed: 4000,
    cssEase: 'linear',
    pauseOnHover: false,
    pauseOnFocus: false,
    swipe: false,
    draggable: false,
    responsive: [
      { breakpoint: 1024, settings: { slidesToShow: 3 } },
      { breakpoint: 768,  settings: { slidesToShow: 2 } },
      { breakpoint: 480,  settings: { slidesToShow: 1 } }
    ]
  });
});
</script>


<!-- curve slider section ends -->


<!-- gallery slider section starts -->

<?php
// Query the "Gallery" custom post type
$args = array(
  'post_type'      => 'gallery',
  'posts_per_page' => -1
);
$gallery_query = new WP_Query($args);

if ($gallery_query->have_posts()) : // ← Only display if posts exist
?>
<section class="gallery-slider-section">
  <div class="container-fluid">
    
    <div class="gallery-slider-title-wrap text-center">
      <h2 class="gallery-slider-title">The Art of Gifting</h2>
      <p class="gallery-slider-subtitle">
        Every gift tells a story. Our gallery captures moments — from curated boxes to artisan details that make each piece unique. Immerse yourself in the beauty and craftsmanship of our gifting experience.
      </p>
    </div>

    <div class="gallery-slider-wrap">
      <?php
        while ($gallery_query->have_posts()) : $gallery_query->the_post();
          $image_url = get_the_post_thumbnail_url(get_the_ID(), 'large');
          if ($image_url) :
      ?>
        <div class="gallery-slider-item">
          <img src="<?php echo esc_url($image_url); ?>" alt="<?php the_title_attribute(); ?>">
        </div>
      <?php 
          endif;
        endwhile;
        wp_reset_postdata();
      ?>
    </div>

    <div class="gallery-slider-btn text-center">
      <a href="<?php echo esc_url(site_url('/gallery')); ?>" class="gallery-slider-btn-link">
        Explore Our Gallery
      </a>
    </div>

  </div>
</section>

<script>
jQuery(document).ready(function($) {
  $('.gallery-slider-wrap').slick({
    slidesToShow: 5,
    slidesToScroll: 1,
    infinite: true,
    arrows: false,
    dots: false,
    autoplay: true,
    autoplaySpeed: 0,
    speed: 4000,
    cssEase: 'linear',
    pauseOnHover: false,
    pauseOnFocus: false,
    swipe: false,
    draggable: false,
    responsive: [
      { breakpoint: 992, settings: { slidesToShow: 2 } },
      { breakpoint: 576, settings: { slidesToShow: 1 } }
    ]
  });
});
</script>

<?php endif; // end if have_posts ?>



<!-- gallery slider section ends -->


<!-- gift qoute section starts -->


<?php
$left_title        = get_field('left_title');
$left_description  = get_field('left_description');
$left_image        = get_field('left_image');
$left_logo         = get_field('left_logo');

$right_title       = get_field('right_title');
$right_description = get_field('right_description');
$right_image       = get_field('right_image');
$right_logo        = get_field('right_logo');

$third_title        = get_field('third_title');
$third_description  = get_field('third_description');
$third_image        = get_field('third_image');
$third_logo         = get_field('third_logo');
?>

<section class="gift-quote-section">
  <div class="container-fluid">
    <div class="gift-quote-row row">

      <!-- Left Card -->
      <div class="col-lg-4 col-md-6 col-sm-12 col-12 gift-quote-box-col">
        <div class="gift-quote-box gift-quote-box-left">
          <div class="gift-quote-content">
            <?php if ($left_title): ?>
              <h3 class="gift-quote-title-left"><?php echo esc_html($left_title); ?></h3>
            <?php endif; ?>

            <?php if ($left_description): ?>
              <p class="gift-quote-desc-left"><?php echo esc_html($left_description); ?></p>
            <?php endif; ?>

            <?php if (!empty($left_image)): ?>
              <div class="gift-quote-img-wrap">
                <img src="<?php echo esc_url($left_image); ?>" alt="<?php echo esc_attr($left_title); ?>" class="gift-quote-img">
                <div class="gift-quote-img-blur"></div>
                <div class="gift-quote-lock"><i class="hgi hgi-stroke hgi-square-lock-02"></i></div>
              </div>
            <?php endif; ?>

            <a href="#" class="gift-quote-btn">Coming Soon...</a>
          </div>

          <?php if (!empty($left_logo)): ?>
            <div class="gift-quote-logo">
              <img src="<?php echo esc_url($left_logo); ?>" alt="Logo" class="gift-quote-logo-img">
            </div>
          <?php endif; ?>
        </div>
      </div>

      <!-- Right Card -->
      <div class="col-lg-4 col-md-6 col-sm-12 col-12 gift-quote-box-col">
        <div class="gift-quote-box gift-quote-box-right">
          <div class="gift-quote-content">
            <?php if ($right_title): ?>
              <h3 class="gift-quote-title-right"><?php echo esc_html($right_title); ?></h3>
            <?php endif; ?>

            <?php if ($right_description): ?>
              <p class="gift-quote-desc-right"><?php echo esc_html($right_description); ?></p>
            <?php endif; ?>

            <?php if (!empty($right_image)): ?>
              <div class="gift-quote-img-wrap">
                <img src="<?php echo esc_url($right_image); ?>" alt="<?php echo esc_attr($right_title); ?>" class="gift-quote-img">
                <div class="gift-quote-img-blur"></div>
                <div class="gift-quote-lock"><i class="hgi hgi-stroke hgi-square-lock-02"></i></div>
              </div>
            <?php endif; ?>

            <a href="#" class="gift-quote-btn">Coming Soon...</a>
          </div>

          <?php if (!empty($right_logo)): ?>
            <div class="gift-quote-logo">
              <img src="<?php echo esc_url($right_logo); ?>" alt="Logo" class="gift-quote-logo-img">
            </div>
          <?php endif; ?>
        </div>
      </div>

      <!-- Third Card (Added) -->
      <div class="col-lg-4 col-md-6 col-sm-12 col-12 gift-quote-box-col">
        <div class="gift-quote-box gift-quote-box-right">
          <div class="gift-quote-content">
            <?php if ($third_title): ?>
              <h3 class="gift-quote-title-right"><?php echo esc_html($third_title); ?></h3>
            <?php endif; ?>

            <?php if ($third_description): ?>
              <p class="gift-quote-desc-right"><?php echo esc_html($third_description); ?></p>
            <?php endif; ?>

            <?php if (!empty($third_image)): ?>
              <div class="gift-quote-img-wrap">
                <img src="<?php echo esc_url($third_image); ?>" alt="<?php echo esc_attr($third_title); ?>" class="gift-quote-img">
                <div class="gift-quote-img-blur"></div>
                <div class="gift-quote-lock"><i class="hgi hgi-stroke hgi-square-lock-02"></i></div>
              </div>
            <?php endif; ?>

            <a href="#" class="gift-quote-btn">Coming Soon...</a>
          </div>

          <?php if (!empty($third_logo)): ?>
            <div class="gift-quote-logo">
              <img src="<?php echo esc_url($third_logo); ?>" alt="Logo" class="gift-quote-logo-img">
            </div>
          <?php endif; ?>
        </div>
      </div>

    </div>
  </div>
</section>


<!-- gift qoute section ends -->

<?php
get_footer();