<?php
/**
 * The main template file.
 * 
 * To override home page (for listing latest post) add home.php into the theme.<br>
 * If front page displays is set to static, the index.php file will be use.<br>
 * If front-page.php exists, it will be override any home page file such as home.php, index.php.<br>
 * To learn more please go to https://developer.wordpress.org/themes/basics/template-hierarchy/ .
 * 
 * @package bootstrap-basic4
 */


// begins template. -------------------------------------------------------------------------
get_header();
?> 



<div class="innerpage-header">
    <img src=" <?php the_field('page-banner'); ?>">
    <div class="inner-banner-head">
        <h4><?php the_title(); ?></h4>
        <p><?php the_field('banner-paragraph'); ?></p>
 
    <div class="pageheading-middle" >
        <div class="custom-container d-flex align-items-center justify-content-center flex-column text-center" style="height: 100%;">
            <?php if ( function_exists('yoast_breadcrumb') ) { 
                yoast_breadcrumb('<h6 id="breadcrumbs">','</h6>'); 
            } ?>
        </div>
    </div>
       </div>
</div>
       

<section class="inner-product-section">
  <div class="custom-container">

    <div class="inner-product-filterbar">
      <div class="chip" id="chip-industries">
        <button class="chip-toggle" type="button" aria-expanded="false" aria-controls="chip-panel-industries">
          <span class="chip-badge" data-count="0">0</span>
          <span class="chip-label">Industries</span>
          <span class="chip-caret"></span>
        </button>

        <div class="chip-panel" id="chip-panel-industries" role="listbox" aria-multiselectable="true" aria-labelledby="chip-industries">
          <div class="chip-search">
            <input type="text" class="chip-search-input" placeholder="Search industry..." autocomplete="off">
          </div>
          <ul class="chip-options">
            <?php
            $terms = get_terms([
              'taxonomy' => 'product_cat',
              'hide_empty' => true,
            ]);
            foreach ($terms as $t): ?>
              <li class="chip-option" role="option" aria-selected="false" data-slug="<?php echo esc_attr($t->slug); ?>">
                <label class="chip-option-label">
                  <input type="checkbox" class="chip-check" value="<?php echo esc_attr($t->slug); ?>">
                  <span class="chip-checkbox"></span>
                  <span class="chip-text"><?php echo esc_html($t->name); ?></span>
                </label>
              </li>
            <?php endforeach; ?>
          </ul>
          <div class="chip-actions">
            <button type="button" class="chip-clear">Clear</button>
            <button type="button" class="chip-apply">Apply</button>
          </div>
        </div>
      </div>
    </div>

    <div class="inner-product-grid row justify-content-center">
      <?php
      $query = new WP_Query([
        'post_type' => 'products',
        'posts_per_page' => -1,
        'order' => 'ASC',
      ]);
      if ($query->have_posts()):
        while ($query->have_posts()): $query->the_post();
          $terms = wp_get_post_terms(get_the_ID(), 'product_cat', ['fields' => 'slugs']);
      ?>
          <div class="col-lg-4 col-md-6 col-sm-12 creation-card-col <?php echo esc_attr(implode(' ', $terms)); ?>">
            <div class="inner-product-card">
              <div class="inner-product-img">
                <?php if (has_post_thumbnail()): ?>
                  <?php the_post_thumbnail('large'); ?>
                <?php endif; ?>
              </div>
              <div class="inner-product-overlay">
                <h3 class="inner-product-title"><?php the_title(); ?></h3>
                <?php if ($content = get_field('product_content')): ?>
                  <p class="inner-product-desc"><?php echo wp_kses_post($content); ?></p>
                <?php endif; ?>
                <a href="<?php the_permalink(); ?>" class="inner-product-btn">View Details</a>
              </div>
            </div>
          </div>
      <?php
        endwhile;
        wp_reset_postdata();
      endif;
      ?>
    </div>

  </div>
</section>

<script>
document.addEventListener("DOMContentLoaded", function () {

  // Open/close chip dropdowns
  document.querySelectorAll(".chip-toggle").forEach(btn => {
    btn.addEventListener("click", function (e) {
      const chip = this.closest(".chip");
      const panel = chip.querySelector(".chip-panel");
      const isOpen = panel.classList.contains("open");

      // Close all other panels
      document.querySelectorAll(".chip-panel.open").forEach(p => p.classList.remove("open"));
      document.querySelectorAll(".chip-toggle[aria-expanded='true']").forEach(b => b.setAttribute("aria-expanded", "false"));

      // Toggle current
      if (!isOpen) {
        panel.classList.add("open");
        this.setAttribute("aria-expanded", "true");
      } else {
        panel.classList.remove("open");
        this.setAttribute("aria-expanded", "false");
      }

      e.stopPropagation();
    });
  });

  // Close when clicking outside
  document.addEventListener("click", function (e) {
    if (!e.target.closest(".chip")) {
      document.querySelectorAll(".chip-panel.open").forEach(p => p.classList.remove("open"));
      document.querySelectorAll(".chip-toggle").forEach(b => b.setAttribute("aria-expanded", "false"));
    }
  });

  // Live search inside chip
  document.querySelectorAll(".chip-search-input").forEach(input => {
    input.addEventListener("input", function () {
      const value = this.value.toLowerCase();
      const options = this.closest(".chip-panel").querySelectorAll(".chip-option");
      options.forEach(opt => {
        const text = opt.textContent.toLowerCase();
        opt.style.display = text.includes(value) ? "" : "none";
      });
    });
  });

  // Apply button logic
  document.querySelectorAll(".chip-apply").forEach(btn => {
    btn.addEventListener("click", function () {
      const panel = this.closest(".chip-panel");
      const chip = panel.closest(".chip");
      const checkboxes = panel.querySelectorAll(".chip-check:checked");
      const badge = chip.querySelector(".chip-badge");

      badge.textContent = checkboxes.length;

      // Update aria
      panel.querySelectorAll(".chip-option").forEach(opt => {
        const checkbox = opt.querySelector(".chip-check");
        opt.setAttribute("aria-selected", checkbox.checked ? "true" : "false");
      });

      panel.classList.remove("open");
      chip.querySelector(".chip-toggle").setAttribute("aria-expanded", "false");

      filterProducts();
    });
  });

  // Clear button
  document.querySelectorAll(".chip-clear").forEach(btn => {
    btn.addEventListener("click", function () {
      const panel = this.closest(".chip-panel");
      const chip = panel.closest(".chip");
      const badge = chip.querySelector(".chip-badge");
      panel.querySelectorAll(".chip-check").forEach(c => (c.checked = false));
      panel.querySelectorAll(".chip-option").forEach(opt => opt.setAttribute("aria-selected", "false"));
      badge.textContent = "0";
      filterProducts();
    });
  });

  // Core filtering function
  function filterProducts() {
    const selectedSlugs = [];
    document.querySelectorAll(".chip-check:checked").forEach(chk => {
      selectedSlugs.push(chk.value);
    });

    const cards = document.querySelectorAll(".creation-card-col");

    if (selectedSlugs.length === 0) {
      cards.forEach(card => (card.style.display = ""));
      return;
    }

    cards.forEach(card => {
      const cardClasses = card.className.split(" ");
      const hasMatch = selectedSlugs.some(slug => cardClasses.includes(slug));
      card.style.display = hasMatch ? "" : "none";
    });
  }

});
</script>



<?php
get_footer();