<?php get_header(); ?>

<section class="single-product-wrapper">
  <div class="container-fluid p-0">

    <?php if (have_posts()) : while (have_posts()) : the_post(); ?>

      <!-- Product Banner Repeater as Slider -->
      <?php if (have_rows('product_banner')): ?>
        <div class="single-product-banner-slider">
          <?php while (have_rows('product_banner')): the_row(); 
            $banner_img = get_sub_field('banner_image');
            $banner_text = get_sub_field('banner_text');
          ?>
            <div class="single-product-banner-slide">
              <?php if ($banner_img): ?>
                <div class="single-product-banner-img">
                  <img src="<?php echo esc_url($banner_img); ?>" alt="<?php echo esc_attr(get_the_title()); ?>">
                </div>
				
              <?php endif; ?>

              <?php if (!empty($banner_text)): ?>
                <div class="single-product-banner-text">
                  <h1><?php echo esc_html($banner_text); ?></h1>
                </div>
              <?php endif; ?>
            </div>
          <?php endwhile; ?>
        </div>
      <?php endif; ?>

    <?php endwhile; endif; ?>

  </div>
</section>

<script>
jQuery(document).ready(function($){
  $('.single-product-banner-slider').slick({
    dots: false,
    arrows: false,
    infinite: true,
    autoplay: true,
    autoplaySpeed: 4000,
    speed: 600,
    fade: true,
    cssEase: 'linear'
  });
});
</script>


<?php 
if (have_posts()) : 
  while (have_posts()) : the_post(); 
    $content = trim(get_the_content());
    if ($content): ?>
      <section class="single-product-about-wrap">
        <div class="custom-container">
          <div class="single-product-about-content">
            <?php the_content(); ?>
          </div>
        </div>
      </section>
    <?php endif; 
  endwhile; 
endif; 
?>



<?php
$info_heading = get_field('info_section_heading');
$info_content = get_field('info_section_content');
if ($info_heading || $info_content) :
?>
  <section class="single-product-info-wrap">
    <div class="custom-container">
      <div class="single-product-info-box">
        <div class="row align-items-center">
          <div class="col-lg-5 col-md-12">
            <?php if ($info_heading): ?>
              <div class="single-product-info-heading">
                <h2><?php echo esc_html($info_heading); ?></h2>
              </div>
            <?php endif; ?>
          </div>
          <div class="col-lg-7 col-md-12">
            <?php if ($info_content): ?>
              <div class="single-product-info-content">
                <?php echo wp_kses_post($info_content); ?>
              </div>
            <?php endif; ?>
          </div>
        </div>
      </div>
    </div>
  </section>
<?php endif; ?>



<?php if (have_rows('giftboxes')) : ?>
  <section class="single-product-giftboxes-wrap">
    <div class="custom-container">
      <div class="single-product-giftboxes-header">
        	<h2>Curated with Heart</h2>
			<h6>Explore the products inside this giftbox</h6>
      </div>

      <div class="single-product-giftboxes-slider">
        <?php while (have_rows('giftboxes')) : the_row(); 
          $giftbox_title = get_sub_field('giftbox_title');
          $giftbox_image = get_sub_field('giftbox_image');
          $giftbox_description = get_sub_field('giftbox_description');
        ?>
          <div class="single-product-giftbox-slide">
            <div class="single-product-giftbox-item">
              <?php if ($giftbox_image): ?>
                <div class="single-product-giftbox-img">
                  <img src="<?php echo esc_url($giftbox_image); ?>" alt="<?php echo esc_attr($giftbox_title); ?>">
					
                </div>
              <?php endif; ?>

              <div class="single-product-giftbox-content">
                <?php if ($giftbox_title): ?>
                  <h3 class="single-product-giftbox-title"><?php echo esc_html($giftbox_title); ?></h3>
                <?php endif; ?>

                <?php if ($giftbox_description): ?>
                  <p class="single-product-giftbox-description"><?php echo esc_html($giftbox_description); ?></p>
                <?php endif; ?>
              </div>
            </div>
          </div>
        <?php endwhile; ?>
      </div>
    </div>
  </section>
<?php endif; ?>

<script>
jQuery(document).ready(function($){
  $('.single-product-giftboxes-slider').slick({
    slidesToShow: 5,
    slidesToScroll: 1,
    dots: false,
    arrows: false,
    infinite: true,
    autoplay: true,
    autoplaySpeed: 4000,
    speed: 600,
    responsive: [
		{
        breakpoint: 1361,
        settings: { slidesToShow: 4 }
      },
	  {
        breakpoint: 1201,
        settings: { slidesToShow: 3 }
      },
      {
        breakpoint: 992,
        settings: { slidesToShow: 3 }
      },
      {
        breakpoint: 768,
        settings: { slidesToShow: 2 }
      },
	  {
        breakpoint: 577,
        settings: { slidesToShow: 1 }
      }
    ]
  });
});
</script>


<?php 
$feature_image = get_field('feature_image');
$feature_image_2 = get_field('feature_image_2');
$feature_heading = get_field('feature_heading');
$feature_content = get_field('feature_content');

if ($feature_image && $feature_heading && $feature_content): ?>
  <section class="product-features-section">
    <div class="custom-container">
      <div class="row align-items-center feature-row">
        <div class="col-lg-6 col-md-12">
          <div class="feature-image">
            <img src="<?php echo esc_url($feature_image); ?>" alt="<?php echo esc_attr($feature_heading); ?>">
			  <img src="<?php echo esc_url($feature_image_2); ?>" alt="<?php echo esc_attr($feature_heading); ?>">
          </div>
        </div>

        <div class="col-lg-6 col-md-12">
          <div class="feature-content">
            <h3><?php echo esc_html($feature_heading); ?></h3>
            <div class="feature-text">
              <?php echo wp_kses_post($feature_content); ?>
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>
<?php endif; ?>


<script>
jQuery(document).ready(function ($) {
  $('.feature-image').slick({
    slidesToShow: 1,
    slidesToScroll: 1,
    infinite: true,
    autoplay: true,
    autoplaySpeed: 3000,
    speed: 800,
    arrows: true,
    prevArrow: $('.single-product-prev-arrow'),
    nextArrow: $('.single-product-next-arrow'),
    dots: false,
    pauseOnHover: false,
    pauseOnFocus: false,
    adaptiveHeight: true
  });
});
</script>


<?php
$images = get_field('cta_gallery');
$cta_content = get_field('cta_content');
$has_content = $images || $cta_content; // Only show if either exists

if ($has_content):
?>
<section class="single-product-personal-wrap">
  <div class="custom-container">

    <div class="single-product-personal-header">
      <h2 class="single-product-personal-title">Make It Personal</h2>
      <h6 class="single-product-personal-subtitle">From you, to them — with a personal touch.</h6>
    </div>

    <div class="row single-product-personal-row">
      <?php if ($images): ?>
        <div class="col-lg-6 col-md-12 col-sm-12">
          <div class="single-product-personal-slider">
            
            <!-- Arrow Controls -->
            <button class="single-product-prev-arrow">
              <i class="hgi hgi-stroke hgi-arrow-left-double"></i>
            </button>
            <button class="single-product-next-arrow">
              <i class="hgi hgi-stroke hgi-arrow-right-double"></i>
            </button>

            <div class="single-product-personal-carousel">
              <?php foreach ($images as $image_url): ?>
                <div class="single-product-personal-slide">
                  <img src="<?php echo esc_url($image_url); ?>" alt="Personalization Image">
                </div>
              <?php endforeach; ?>
            </div>
          </div>
        </div>
      <?php endif; ?>

      <?php if ($cta_content): ?>
        <div class="col-lg-6 col-md-12 col-sm-12">
          <div class="single-product-personal-content">
            <?php echo wp_kses_post($cta_content); ?>
          </div>
        </div>
      <?php endif; ?>
    </div>

  </div>
</section>
<?php endif; ?>

<script>
jQuery(document).ready(function ($) {
  $('.single-product-personal-carousel').slick({
    slidesToShow: 1,
    slidesToScroll: 1,
    infinite: true,
    autoplay: true,
    autoplaySpeed: 3000,
    speed: 800,
    arrows: true,
    prevArrow: $('.single-product-prev-arrow'),
    nextArrow: $('.single-product-next-arrow'),
    dots: false,
    pauseOnHover: false,
    pauseOnFocus: false,
    adaptiveHeight: true
  });
});
</script>

<section class="single-product-bottom-cta-wrap">
  <div class="custom-container">
    <div class="row">
      <div class="col-12">
        <?php
        // Pull from your custom post type "general_info"
        $args = [
          'post_type'      => 'general_info',
          'posts_per_page' => 1
        ];
        $general_info_query = new WP_Query($args);

        if ($general_info_query->have_posts()):
          while ($general_info_query->have_posts()): $general_info_query->the_post();
            $phone_number   = get_field('phone_number');
        ?>
          <div class="single-product-personal-cta">
            <h4>Ready to Make It Yours?</h4>
            <p>
              Get in touch with us and we’ll help you tailor your order.<br>
              Available for custom branding and bulk corporate gifting.
            </p>

            <?php if ($phone_number): ?>
<!--                 <a href="tel:<?php echo preg_replace('/\D+/', '', $phone_number); ?>" class="single-product-cta-btn">
                  Start Your Order
                </a> -->
            <?php endif; ?>
          </div>
        <?php
          endwhile;
          wp_reset_postdata();
        endif;
        ?>
      </div>
    </div>
  </div>
</section> 



<?php get_footer(); ?>
