<?php
/** 
 * The single post.<br>
 * This file works as display full post content page and its comments.
 * 
 * @package bootstrap-basic4
 */


// begins template. -------------------------------------------------------------------------
get_header();
?> 

<div class="innerpage-header">
    <img src="<?php echo get_template_directory_uri();?>/assets/img/blog-banner.webp" alt=" " decoding="async" loading="lazy">
    <div class="inner-banner-head">
        <h4><?php the_title(); ?></h4>
        <p>Embark on extraordinary journeys with our exclusive travel blogs—your gateway to inspiration, tips, and unforgettable destinations.</p>
 
    <div class="pageheading-middle" >
        <div class="custom-container d-flex align-items-center justify-content-center flex-column text-center" style="height: 100%;">
            <?php if ( function_exists('yoast_breadcrumb') ) { 
                yoast_breadcrumb('<h6 id="breadcrumbs">','</h6>'); 
            } ?>
        </div>
    </div>
       </div>
</div>


<section class="post-inner inner-wrapper">
<div class="container">
        <div class="row">
            <div class="col-lg-9 col-md-12 col-12">
                <div class="blog-inner-img">
                    <?php if ( has_post_thumbnail() && ! post_password_required() ) : ?>
                    <?php the_post_thumbnail('large'); ?>
                    <?php endif; ?> 
                </div>
                    <h4><?php the_title(); ?></h4>
                    <h6><?php echo date("F j, Y");?></h6>
                <?php the_content(); ?>
            </div>
            <div class="col-lg-3 col-md-8 col-12">
                <div class="recent-post-wrapper">
                    <h3>Recent Posts</h3>
                    <?php query_posts('post_type=post&order=ASC&showposts=4'); ?>
                    <?php while (have_posts()) : the_post(); ?>
                    <div class="sidebar-post-item">
                        <span>
                        <h4><?php the_title(); ?></h4>
                        <a href="<?php the_permalink(); ?>">Read More <i class="fa fa-arrow-right" aria-hidden="true"></i></a>
                        </span>
                    </div>
                    <?php endwhile; ?>
                    <?php wp_reset_query();?>
                </div>
            </div>
        </div>
    </div>
</section>

<?php
get_footer();