<?php
/**
 * The Template for displaying all single products
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see         https://woocommerce.com/document/template-structure/
 * @package     WooCommerce\Templates
 * @version     1.6.4
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

get_header( 'shop' ); ?>

	<?php
		/**
		 * woocommerce_before_main_content hook.
		 *
		 * @hooked woocommerce_output_content_wrapper - 10 (outputs opening divs for the content)
		 * @hooked woocommerce_breadcrumb - 20
		 */
		do_action( 'woocommerce_before_main_content' );
	?>

		<?php while ( have_posts() ) : the_post(); ?>

    <?php
    global $product;

    // ACF Fields
    $giftbox_title = get_field('giftbox_title');
    $giftbox_desc  = get_field('giftbox_description');
    $giftbox_img   = get_field('giftbox_image');
    $amount        = get_field('amount'); // NEW FIELD
    ?>

    <div class="single-product-wrapper">

        <!-- LEFT: Image -->
        <div class="product-left">
            <?php
            if ($giftbox_img) {
                echo wp_get_attachment_image($giftbox_img, 'large');
            } else {
                woocommerce_show_product_images();
            }
            ?>
        </div>

        <!-- RIGHT: Content -->
        <div class="product-right">

            <?php if ($giftbox_title): ?>
                <h1 class="product-title"><?php echo esc_html($giftbox_title); ?></h1>
            <?php else: ?>
                <h1 class="product-title"><?php the_title(); ?></h1>
            <?php endif; ?>

            <?php if ($giftbox_desc): ?>
                <p class="product-description">
                    <?php echo esc_html($giftbox_desc); ?>
                </p>
            <?php endif; ?>

            <!-- ACF Amount -->
            <?php if ($amount): ?>
                <div class="product-amount">
                    <strong>Amount:</strong> ₹<?php echo esc_html($amount); ?>
                </div>
            <?php endif; ?>

            <!-- Woo Price -->
            <div class="product-price">
                <?php echo $product->get_price_html(); ?>
            </div>

            <!-- Add to Cart -->
            <div class="product-cart">
                <?php woocommerce_template_single_add_to_cart(); ?>
            </div>

        </div>

    </div>

<?php endwhile; ?>


	<?php
		/**
		 * woocommerce_after_main_content hook.
		 *
		 * @hooked woocommerce_output_content_wrapper_end - 10 (outputs closing divs for the content)
		 */
		do_action( 'woocommerce_after_main_content' );
	?>

	<?php
		/**
		 * woocommerce_sidebar hook.
		 *
		 * @hooked woocommerce_get_sidebar - 10
		 */
		do_action( 'woocommerce_sidebar' );
	?>

<?php
get_footer( 'shop' );

/* Omit closing PHP tag at the end of PHP files to avoid "headers already sent" issues. */
