<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\MessageBag;
use Validator;
use App\Models\Aboutus;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Str;
use App\Http\Controllers\Includefunctions;
use DataTables;
use File;
use Illuminate\Support\Facades\Storage;

class AboutUsController extends Controller
{
//
    use Includefunctions; 
    function addsettings()
     {
         return view('backend.about.add');
     }

     
     public function insertsettings(Request $request)
     {
        try{
         // Validation rules
         $rules = [
             'who_we_are' => 'required',
             'our_history' => 'required',
             'photo' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg,webp|max:2048',
             'our_history_icon' => 'image|mimes:jpeg,png,jpg,gif,svg,webp|max:2048',
             'global_presence_icon' => 'image|mimes:jpeg,png,jpg,gif,svg,webp|max:2048',

         ];
         
         if (!$request->hasFile('our_history_icon')) {
             unset($rules['our_history_icon']);
         }
         if (!$request->hasFile('photo')) {
             unset($rules['photo']);
         }
         if (!$request->hasFile('global_presence_icon')) {
             unset($rules['global_presence_icon']);
         }
     
         // Validate the request
         $validator = Validator::make($request->all(), $rules);
         if ($validator->fails()) {
             return back()->withErrors($validator->errors())->withInput();
         }
     
         // Store the photo
         $imageName = null;
         if ($request->hasFile('photo')) {
             $imageName = time() . '-photo.' . $request->photo->extension();
             $request->photo->storeAs('public/assets/about/photo', $imageName);
         }

         // Store the  photo 2
         $imageName2 = null;
         if ($request->hasFile('our_history_icon')) {
             $imageName2 = time() . '-our_history_icon.' . $request->our_history_icon->extension();
             $request->our_history_icon->storeAs('public/assets/about/our_history_icon', $imageName2);
         }

         // Store the  global_presence_icon
         $imageName3 = null;
         if ($request->hasFile('global_presence_icon')) {
             $imageName3 = time() . '-global_presence_icon.' . $request->global_presence_icon->extension();
             $request->global_presence_icon->storeAs('public/assets/about/global_presence_icon', $imageName3);
         }

      // Current timestamp
         $now = now();
     
         // Create the Aboutus record
          Aboutus::create([
            'who_we_are' => $request->who_we_are,
            'our_history' => $request->our_history,
            'our_history_icon' => $imageName2,
            'our_history_icon_text' => $request->our_history_icon_text,
            'photo' => $imageName,
            'photo_text' => $request->photo_text,
            'global_presence' => $request->global_presence,
            'global_presence_icon' => $imageName3,
            'global_presence_icon_text' => $request->global_presence_icon_text,
            'mission' => $request->mission,
            'vision' => $request->vision,
            'what_we_do' => $request->what_we_do,
            'advantages' => $request->advantages,
            'created_at' => now(),
            'updated_at' => now(),
        ]);
         $success_message = "success";
        return response()->json(['success' => true, 'message' => 'Data updated successfully!']);
    } catch (\Exception $e) {
        // Return error response
        return response()->json(['error' => true, 'message' => 'An error occurred: ' . $e->getMessage()]);
    }
} 
     
     function viewsettings()
  
     {   
    
         return view('backend.about.view');
     }


     function ajaxview(Request $request)
     {
         if ($request->ajax()) {
             if ($request->ajax()) {
             $post = Aboutus::latest()->get();
             return Datatables::of($post)
                     ->addIndexColumn()
                     ->escapeColumns([]) 
                     ->addColumn('action', function($row){
                        $action = '<div class="dropdown">
                        <button class="actionbutton btn btn-outline-secondary dropdown-toggle black-dropdown" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            Action
                        </button>
                        <div class="dropdown-menu blue-text" aria-labelledby="dropdownMenuButton">
                            <a class="dropdown-item" href="'.route('admin.about.edit', $row->id).'">
                                <i class="fa fa-edit"></i> Edit
                            </a>
                            <a class="dropdown-item deletebtn" href="javascript:deletesettings;" data-id="'.$row->id.'">
                                <i class="fa fa-trash"></i> Delete
                            </a>

                              <a class="dropdown-item" href="'.route('admin.about.features.view', $row->id).'">
                                <i class="fa fa-edit"></i> Feature
                            </a>
                            

                        </div>
                    </div>';
                    
                    return $action;
                })
                       
                     ->rawColumns(['action'])
                     ->make(true);
         }
       
         return view('backend.about.view',compact('post'));
     }
     }
     function editsettings($id)
     {
         $about = Aboutus::where('id', $id)->first();
         return view('backend.about.edit',compact('about','id'));
     }

    public function updatesettings(Request $request)
{
    try {
        $validator = Validator::make($request->all(), [
            'who_we_are' => 'required',
            'our_history' => 'required',
        ]);


        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'errors' => $validator->errors()
            ]);
        }

        $data = Aboutus::findOrFail($request->id);

        $input = [
            'who_we_are' => $request->who_we_are,
            'our_history' => $request->our_history,
            'our_history_icon_text' => $request->our_history_icon_text,
            'photo_text' => $request->photo_text,
            'global_presence' => $request->global_presence,
            'global_presence_icon_text' => $request->global_presence_icon_text,
            'mission' => $request->mission,
            'vision' => $request->vision,
            'what_we_do' => $request->what_we_do,
            'advantages' => $request->advantages,
            'updated_at' => now(),
        ];

        if ($request->hasFile('photo')) {
            $file_path = 'public/assets/about/photo/' . $request->oldphoto;
            if (Storage::exists($file_path)) {
                Storage::delete($file_path);
            }
            $imageName = time() . '-photo.' . $request->photo->extension();
            $request->photo->storeAs('public/assets/about/photo', $imageName);
            $input['photo'] = $imageName;
        }

        if ($request->hasFile('our_history_icon')) {
            $file_path = 'public/assets/about/our_history_icon/' . $request->oldour_history_icon;
            if (Storage::exists($file_path)) {
                Storage::delete($file_path);
            }
            $imageName2 = time() . '-our_history_icon.' . $request->our_history_icon->extension();
            $request->our_history_icon->storeAs('public/assets/about/our_history_icon', $imageName2);
            $input['our_history_icon'] = $imageName2;
        }

        if ($request->hasFile('global_presence_icon')) {
            $file_path = 'public/assets/about/global_presence_icon/' . $request->oldglobal_presence_icon;
            if (Storage::exists($file_path)) {
                Storage::delete($file_path);
            }
            $imageName3 = time() . '-global_presence_icon.' . $request->global_presence_icon->extension();
            $request->global_presence_icon->storeAs('public/assets/about/global_presence_icon', $imageName3);
            $input['global_presence_icon'] = $imageName3;
        }



        $data->update($input);

        return response()->json([
            'success' => true,
            'message' => 'Data updated successfully!'
        ]);
    } catch (\Exception $e) {
        return response()->json([
            'success' => false,
            'message' => $e->getMessage()
        ], 500);
    }
}

    function deletesettings($id)
    {
        try{			
            Aboutus::where('id', $id)->delete(); 
            $success_message = "success";
            return response()->json(['success' => true, 'message' => 'Data delete successfully!']);
        }
        catch (Exception $e) {
            return response()->json(['error' => true, 'message' => 'An error occurred.']);
        }    
    }
    
    
}



