<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Validator;
use App\Models\Blog;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Str;
use App\Http\Controllers\Includefunctions;
use DataTables;
use File;

class BlogController extends Controller
{
    use Includefunctions;  

    public function addsettings()
    {
        $caption = Blog::orderBy('caption', 'asc')->get();
        return view('backend.blogs.add', compact('caption'));
    }
    public function insertsettings(Request $request)
    {
        try {
            // Validation
            $rules = [
                'caption' => 'required',         
                'photo' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
            ];
    
            $validator = Validator::make($request->all(), $rules);
            if ($validator->fails()) {
                return back()->withErrors($validator->errors())->withInput();
            }
    
            // Handle the photo upload
            $imageName = time() . '.' . $request->photo->extension();
            $request->photo->storeAs('public/assets/blog', $imageName);
    
            // Generate SEO URL
            $seoUrl = $this->generateSeoUrl($request->seo_url);        
            $now = date('Y-m-d H:i:s');
    
            // Insert the blog data
            Blog::create([
                'caption' => $request->caption,
                'auther' => $request->auther,
                'small_description' => $request->small_description,
                'description' => $request->description,
                'priority' => $request->priority,         
                'photo' => $imageName, 
                'photo_text' => $request->photo_text,                  
                'seo_url' => $seoUrl,
                'seo_title' => $request->seo_title,
                'seo_keyword' => $request->seo_keyword,
                'seo_description' => $request->seo_description,         
                'updated_at' => $now,
                'created_at' => $now
            ]); 
    
            // Return success response
            return response()->json(['success' => true, 'message' => 'Data inserted successfully!']);
        } catch (Exception $e) {
            // Handle any exceptions that occur
            return response()->json(['error' => true, 'message' => 'An error occurred.']);
        }
    }
    

    function viewsettings()
    {
        return view('backend.blogs.view');
    }

    public function ajaxview(Request $request)
    {
        if ($request->ajax()) {
            $posts = Blog::orderBy('id', 'desc')->get();
    
            $trimmedPosts = $posts->map(function ($post) {
                $post->formatted_updated_at = $post->updated_at->format('d-m-Y');
                $post->trimmed_description = Str::words(strip_tags($post->small_description), 20, '...');
                return $post;
            });
    
            return datatables()->of($trimmedPosts)
                ->addIndexColumn()
                ->addColumn('action', function ($row) {
                    $editBtn = '<a href="'.route('admin.blogs.edit', $row->id).'" data-toggle="tooltip" data-id="'.$row->id.'" data-original-title="Edit" class="edit btn btn-primary btn-sm">Edit</a>';
$deleteBtn = '<a href="javascript:void(0);" onclick="deleteBlog('.$row->id.');" data-toggle="tooltip" data-id="'.$row->id.'" data-original-title="Delete" class="btn btn-danger btn-sm deleteBlog">Delete</a>';
                    return $editBtn . ' ' . $deleteBtn;

                    
                    

                })
                ->rawColumns(['action'])
                ->make(true);
        }
    
        return view('admin.blogs.view');
    }
    
    function editsettings($id)
    {
              
        $blogs = Blog::where('id', $id)->first();
        return view('backend.blogs.edit',compact('blogs'));
    }
    public function updatesettings(Request $request)
    {
        try {
            $id = $request->id;
            $now = date('Y-m-d H:i:s');
            $seoUrl = $this->generateSeoUrl($request->seo_url);
    
            // Find the blog by ID
            $data = Blog::where('id', $id);
    
            // Prepare the data to be updated
            $input = [
                'caption' => $request->caption,
                'auther' => $request->auther,
                'small_description' => $request->small_description,
                'description' => $request->description,
                'priority' => $request->priority,
                'seo_url' => $seoUrl,
                'photo_text' => $request->photo_text,
                'seo_title' => $request->seo_title,
                'seo_keyword' => $request->seo_keyword,
                'seo_description' => $request->seo_description,
                'updated_at' => $now
            ];
    
            // Check if photo is uploaded
            if ($request->hasFile('photo') && $request->photo->isValid()) {
                $imageName = time() . '.' . $request->photo->extension();
                $request->photo->storeAs('public/assets/blog', $imageName);
    
                // Add photo to input array (merge with previous input)
                $input['photo'] = $imageName;
            }
    
            // Update the data
            $data->update($input);
    
            return response()->json(['success' => true, 'message' => 'Course updated successfully!']);
        } catch (\Exception $e) {
            Log::error('Error updating course: ' . $e->getMessage());
            return response()->json(['error' => true, 'message' => 'An error occurred while updating the course.'], 500);
        }
    }

    

    function deletesettings($id)
    {
        try{			
            Blog::where('id', $id)->delete(); 
            $success_message = "success";
            return response()->json(['success' => true, 'message' => 'Data delete successfully!']);
        }
        catch (Exception $e) {
            return response()->json(['error' => true, 'message' => 'An error occurred.']);
        }    
    }
    
}

    
    

