<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\MessageBag;
use Validator;
use App\Models\Excellence;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Str;
use App\Http\Controllers\Includefunctions;
use DataTables;
use File;
use Illuminate\Support\Facades\Storage;

class ExcellenceController extends Controller
{
    use Includefunctions;

    function addsettings()
    {
        return view('backend.excellence.add');
    }

    public function insertsettings(Request $request)
    {
        try {
            // Validation rules
            $rules = [
                'caption' => 'required',
                'value' => 'required',
                'photo' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg,webp|max:2048',
            ];

            if (!$request->hasFile('photo')) {
                unset($rules['photo']);
            }

            $validator = Validator::make($request->all(), $rules);
            if ($validator->fails()) {
                return back()->withErrors($validator->errors())->withInput();
            }

            // Store the photo
            $imageName = null;
            if ($request->hasFile('photo')) {
                $imageName = time() . '-photo.' . $request->photo->extension();
                $request->photo->storeAs('public/assets/excellence/photo', $imageName);
            }

              $imageName2 = null;
            if ($request->hasFile('photo2')) {
                $imageName2 = time() . '-photo2.' . $request->photo2->extension();
                $request->photo2->storeAs('public/assets/excellence/photo2', $imageName2);
            }

            $now = now();

            Excellence::create([
                'caption' => $request->caption,
                'value' => $request->value,
                'photo_text' => $request->photo_text,
                'photo' => $imageName,
                 'photo_text2' => $request->photo_text2,
                'photo2' => $imageName2,
                'created_at' => $now,
                
            ]);

            return response()->json(['success' => true, 'message' => 'Data inserted successfully!']);
        } catch (\Exception $e) {
            return response()->json(['error' => true, 'message' => 'An error occurred.']);
        }
    }

    function viewsettings()
    {
        return view('backend.excellence.view');
    }

    function ajaxview(Request $request)
    {
        if ($request->ajax()) {
            $post = Excellence::latest()->get();
            return Datatables::of($post)
                ->addIndexColumn()
                ->escapeColumns([])
                ->addColumn('action', function ($row) {
                    $action = '<div class="dropdown">
                        <button class="actionbutton btn btn-outline-secondary dropdown-toggle black-dropdown" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            Action
                        </button>
                        <div class="dropdown-menu blue-text" aria-labelledby="dropdownMenuButton">
                            <a class="dropdown-item" href="' . route('admin.excellence.edit', $row->id) . '">
                                <i class="fa fa-edit"></i> Edit
                            </a>
                            <a class="dropdown-item deletebtn" href="javascript:deletesettings;" data-id="' . $row->id . '">
                                <i class="fa fa-trash"></i> Delete
                            </a>
                        </div>
                    </div>';
                    return $action;
                })
                ->rawColumns(['action'])
                ->make(true);
        }

        return view('backend.excellence.view');
    }

    function editsettings($id)
    {
        $excellence = Excellence::findOrFail($id);
        return view('backend.excellence.edit', compact('excellence', 'id'));
    }

    function updatesettings(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'caption' => 'required',
                'value' => 'required',
                'photo' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg,webp|max:2048',
            ]);

            if ($validator->fails()) {
                return back()->withErrors($validator->errors())->withInput();
            }

            $id = $request->id;
            $now = now();
            $data = Excellence::findOrFail($id);

            $input = [
                'caption' => $request->caption,
                'value' => $request->value,
                'photo_text' => $request->photo_text,
                 'photo_text2' => $request->photo_text2,
                'updated_at' => $now,
            ];

            if ($request->hasFile('photo')) {
                $file_path = 'public/assets/excellence/photo/' . $request->oldphoto;
                if (Storage::exists($file_path)) {
                    Storage::delete($file_path);
                }
                $imageName = time() . '-photo.' . $request->photo->extension();
                $request->photo->storeAs('public/assets/excellence/photo', $imageName);
                $input['photo'] = $imageName;
            }
              if ($request->hasFile('photo2')) {
                $file_path = 'public/assets/excellence/photo2/' . $request->oldphoto;
                if (Storage::exists($file_path)) {
                    Storage::delete($file_path);
                }
                $imageName2 = time() . '-photo2.' . $request->photo2->extension();
                $request->photo2->storeAs('public/assets/excellence/photo2', $imageName2);
                $input['photo2'] = $imageName2;
            }

            $data->update($input);

            return response()->json(['success' => true, 'message' => 'Data updated successfully!']);
        } catch (\Exception $e) {
            return response()->json(['error' => true, 'message' => $e->getMessage()], 500);
        }
    }

    function deletesettings($id)
    {
        try {
            Excellence::where('id', $id)->delete();
            return response()->json(['success' => true, 'message' => 'Data delete successfully!']);
        } catch (\Exception $e) {
            return response()->json(['error' => true, 'message' => 'An error occurred.']);
        }
    }
}
