<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\MessageBag;
use Validator;
use App\Models\Faq;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Str;
use App\Http\Controllers\Includefunctions;
use DataTables;
use File;
use Illuminate\Support\Facades\Storage;

class FaqController extends Controller
{
    //
    use Includefunctions; 
    function addsettings()
     {
         return view('backend.faq.add');
     }

     
     public function insertsettings(Request $request)
     {
        try{
         // Validation rules
         $rules = [
             'question' => 'required',
             'answer' => 'required',
             'priority' => 'required',
             
         ];
         
         // Remove validation rules for photo_2 and photo if not provided
         
         if (!$request->hasFile('photo')) {
             unset($rules['photo']);
         }
     
         // Validate the request
         $validator = Validator::make($request->all(), $rules);
         if ($validator->fails()) {
             return back()->withErrors($validator->errors())->withInput();
         }
     
     
         // Current timestamp
         $now = now();
     
         // Create the Faq record
         Faq::create([
             'question' => $request->question,
             'answer' => $request->answer,
             'priority' => $request->priority,
             'updated_at' => $now,
             'created_at' => $now
         ]);
         $success_message = "success";
         return response()->json(['success' => true, 'message' => 'Data inserted successfully!']);
        }
        catch (Exception $e) {
               return response()->json(['error' => true, 'message' => 'An error occurred.']);
           }

        }    
     
     function viewsettings()
  
     {   
    
        return view('backend.faq.view');
     }


     function ajaxview(Request $request)
     {
         if ($request->ajax()) {
             if ($request->ajax()) {
             $post = Faq::latest()->get();
             return Datatables::of($post)
                     ->addIndexColumn()
                     ->escapeColumns([]) 
                     ->addColumn('action', function($row){
    
                            $btn = '<a href="'.route('admin.faq.edit',$row->id).'" data-toggle="tooltip"  data-id="'.$row->id.'" data-original-title="Edit" class="edit btn btn-primary btn-sm editSca">Edit</a>';
                            $btn = $btn.' <a href="javascript:deletesettings(\''.$row->id.'\');" data-toggle="tooltip"  data-id="'.$row->id.'" data-original-title="Delete" class="btn btn-danger btn-sm deletebtn">Delete</a>';

     
                             return $btn;
                     })
                     ->rawColumns(['action'])
                     ->make(true);
         }
       
         return view('backend.faq.view',compact('post'));
     }
     }

     function editsettings($id)
     {
         $faq = Faq::where('id', $id)->get();
         return view('backend.faq.edit',compact('faq','id'));
     }
     
    function updatesettings(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'question' => 'required',
                'answer' => 'required',
                'priority' => 'required',
              
            ]);

            if ($validator->fails()) {
                return back()->withErrors($validator->errors())->withInput();
            }

            $id = $request->id;
            $now = now();
            $data = Faq::findOrFail($id);
            $input = [
                'question' => $request->question,
                'answer' => $request->answer,
                'priority' => $request->priority,
                'updated_at' => $now,
            ];

           

          

            $data->update($input);
            return response()->json(['success' => true, 'message' => 'Data updated successfully!']);
        } catch (\Exception $e) {
            return response()->json(['error' => true, 'message' => $e->getMessage()], 500);
        }
    }

    function deletesettings($id)
    {
        try{			
            Faq::where('id', $id)->delete(); 
            $success_message = "success";
            return response()->json(['success' => true, 'message' => 'Data delete successfully!']);
        }
        catch (Exception $e) {
            return response()->json(['error' => true, 'message' => 'An error occurred.']);
        }    
    }
}



