<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\MessageBag;
use Validator;
use App\Models\AboutFeatures;
use App\Models\ViewFeatures;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Str;
use App\Http\Controllers\Includefunctions;
use DataTables;
use File;
use Illuminate\Support\Facades\Storage;

class FeaturesController extends Controller
{
    use Includefunctions;

    public function addphotos()
    {
        return view('backend.about.features.add');
    }
    public function insertphotos(Request $request)
    {

    
        // Validate request data
        $request->validate([
            'photo' => 'required|image|mimes:jpeg,png,jpg,gif,webp',
            'description' => 'required',
            'caption' => 'required',
        ]);
    
           $about_id=$request->about_id;
        if ($request->hasFile('photo')) {
          
            $imageName = time() . '-photo.' . $request->photo->extension();
            $request->photo->storeAs('public/assets/about/features', $imageName);
        }

            $now = now(); 

    
            // Insert data into the database
            AboutFeatures::create([
                'caption' => $request->caption,
                'about_id' =>$about_id,
                'description' => $request->description,
                'photo' => $imageName, 
                'updated_at' => $now,
                'created_at' => $now,
            ]);
    
            // Return success message
            return response()->json(['success' => true, 'message' => 'Features photo inserted successfully.'], 200);
        
    }
    
    
public function viewphotos($id)
{
    $about = ViewFeatures::where('about_id', $id)->first();
    $about_id = $about->about_id ?? $id;

    return view('backend.about.features.view', compact('id', 'about', 'about_id'));
}

    
public function ajaxviewphotos(Request $request)
{
    if ($request->ajax()) {
        $aboutId = $request->about_id; // Match this with JS

        $photos = AboutFeatures::where('about_id', $aboutId)
            ->select('id', 'caption', 'photo')
            ->get();

        return DataTables::of($photos)
            ->addIndexColumn() // DT_RowIndex
            ->addColumn('photo', function ($photo) {
                $imageUrl = $photo->photo ? asset('storage/assets/about/features/' . $photo->photo) : '';
                return $imageUrl ? '<img src="' . $imageUrl . '" width="70" class="img-thumbnail" />' : '';
            })
            ->addColumn('action', function ($photo) {
                $editUrl = route('admin.about.features.edit', $photo->id);
                $deleteUrl = "javascript:deletefeatures('" . $photo->id . "');";
                return '<a href="' . $editUrl . '" class="edit btn btn-primary btn-sm" title="Edit">Edit</a> ' .
                       '<a href="' . $deleteUrl . '" class="delete btn btn-danger btn-sm" title="Delete">Delete</a>';
            })
            ->rawColumns(['photo', 'action'])
            ->make(true);
    }

    return view('backend.about.features.view'); 
}



    public function editphotos($id)
    {
        $about = ViewFeatures::where('about_id', $id)->first();

        $features = AboutFeatures::findOrFail($id);

        return view('backend.about.features.edit', compact('features','about',));
    }

   
public function updatephotos(Request $request)
{
    $id = $request->id;
    $features = AboutFeatures::findOrFail($id);

    $rules = [
        'photo' => 'nullable|image|mimes:jpeg,png,jpg,gif,webp',
        'description' => 'required',
        'caption' => 'required',
    ];

    $validator = Validator::make($request->all(), $rules);

    if ($validator->fails()) {
        return response()->json(['success' => false, 'message' => $validator->errors()->first()], 400);
    }

    $features->caption = $request->caption;
    $features->description = $request->description;

    // Handle photo 1 update
    if ($request->hasFile('photo')) {
        $photo = $request->file('photo');
        if ($photo->isValid()) {
            $imageName = time() . '-photo.' . $photo->extension();
            $photo->storeAs('public/assets/about/features', $imageName);

            if ($features->photo) {
                Storage::delete('public/assets/about/features/' . $features->photo);
            }

            $features->photo = $imageName;
        } else {
            return response()->json(['success' => false, 'message' => 'Invalid photo file uploaded'], 400);
        }
    }

    $features->save();

    return response()->json(['success' => true, 'message' => 'Photos updated successfully'], 200);
}

   public function deletephotos($id)
{
    // Find the record
    $features = AboutFeatures::find($id);

    if ($features) {
        // Delete photo if it exists
        if ($features->photo && Storage::exists('public/assets/about/features/' . $features->photo)) {
            Storage::delete('public/assets/about/features/' . $features->photo);
        }


        // Delete the database record
        $features->delete();

        return response()->json(['success' => true, 'message' => 'Photos deleted successfully.']);
    }

    // If record not found
    return response()->json(['success' => false, 'message' => 'Photo not found.'], 404);
}


}
