<?php
namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\MessageBag;
use Validator;
use App\Models\HomeBanner;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Str;
use App\Http\Controllers\Includefunctions;
use DataTables;
use File;
use Illuminate\Support\Facades\Storage;

class HomeBannerController extends Controller
{
    //
    use Includefunctions; 
    function addsettings()
     {
         return view('backend.home.banner.add');
     }
     function insertsettings(Request $request)
     {
        try{
          //validation
          $rules = [             
               'caption1' => 'required',
                'caption2' => 'required',
                'small_caption1' => 'nullable',
                'small_caption2' => 'nullable',
                'link1' => 'nullable',
                'linkcaption1' => 'nullable',
                'link2' => 'nullable',
                'linkcaption2' => 'nullable',
                'photo' => 'required|image|mimes:jpeg,png,jpg,gif,svg,webp|max:2048', 
         ];        
 
         $validator = Validator::make($request->all(),$rules);
         if($validator->fails()){
             return back()->withErrors($validator->errors())->withInput();
         }
         $imageName = null;

         if ($request->hasFile('photo')) {
             $imageName = time().'-'."photo".'.'.$request->photo->extension();
             $request->photo->storeAs('public/assets/homebanner', $imageName);
         }              
         $now = date('Y-m-d H:i:s');
         HomeBanner::create([
            'caption1'     => $request->caption1,
			'caption2'     => $request->caption2,
			'small_caption1'     => $request->small_caption1,
            'small_caption2'     => $request->small_caption2,
			'linkcaption1'  => $request->linkcaption1,
			'link1'         => $request->link1,
            'linkcaption2'  => $request->linkcaption2,
			'link2'         => $request->link2,			
            'photo'        => $imageName,
            'photo_text'     => $request->photo_text,		
            'created_at'   => $now
         ]); 
         $success_message = "success";
         return response()->json(['success' => true, 'message' => 'Data inserted successfully!']);
        }
        catch (Exception $e) {
               return response()->json(['error' => true, 'message' => 'An error occurred.']);
           }

     }           
     function viewsettings()
  
     {   
    
         return view('backend.home.banner.view');
     }
     function ajaxview(Request $request)
     {
         if ($request->ajax()) {
             $post = HomeBanner::latest()->get();
             return Datatables::of($post)
                     ->addIndexColumn()
                     ->escapeColumns([]) 
                     ->addColumn('action', function($row){
    
                            $btn = '<a href="'.route('admin.home.banner.edit',$row->id).'" data-toggle="tooltip"  data-id="'.$row->id.'" data-original-title="Edit" class="edit btn btn-primary btn-sm">Edit</a>';
    
                            $btn = $btn.' <a href="javascript:deletesettings(\''.$row->id.'\');" data-toggle="tooltip"  data-id="'.$row->id.'" data-original-title="Delete" class="btn btn-danger btn-sm deletebtn">Delete</a>';
     
                             return $btn;
                     })
                     ->rawColumns(['action'])
                     ->make(true);
         }
       
         return view('admin.homebanner.view',compact('post'));
     }
     function editsettings($id)
     {
         $homebanner = HomeBanner::where('id', $id)->first();
         return view('backend.home.banner.edit',compact('homebanner','id'));
     }
     function updatesettings(Request $request)
{
    try {
        // Validation rules
        $rules = [
            'caption1' => 'required',
            'caption2' => 'required',
            'small_caption1' => 'nullable',
            'small_caption2' => 'nullable',
            'link1' => 'nullable',
            'linkcaption1' => 'nullable',
            'link2' => 'nullable',
            'linkcaption2' => 'nullable',
            'photo' => 'sometimes|image|mimes:jpeg,png,jpg,gif,svg,webp|max:2048',
        ];

        // Remove 'photo' rule if it's not present or if it's 'undefined'
        if (!$request->has('photo') || $request->photo == "undefined") {
            unset($rules['photo']);
        }

        // Validate the request data
        $validator = Validator::make($request->all(), $rules);
        if ($validator->fails()) {
            return back()->withErrors($validator->errors())->withInput();
        }

        $id = $request->id;
        $now = now();

        $data = HomeBanner::findOrFail($id);
        $input = [
             'caption1'      => $request->caption1,
			'caption2'     => $request->caption2,
			'small_caption1'     => $request->small_caption1,
            'small_caption2'     => $request->small_caption2,
			'linkcaption1'  => $request->linkcaption1,
			'link1'         => $request->link1,
            'linkcaption2'  => $request->linkcaption2,
			'link2'         => $request->link2,		
            'photo_text'     => $request->photo_text,		
            'updated_at' => $now,
        ];

        // Process photo upload
        if ($request->hasFile('photo') && $request->file('photo')->isValid()) {
            $oldPhoto = $data->photo;
            $imageName = time() . '-' . 'photo' . '.' . $request->photo->extension();
            $request->photo->storeAs('public/assets/homebanner', $imageName);

            // Delete old photo
            if ($oldPhoto) {
                Storage::delete("public/assets/homebanner/$oldPhoto");
            }

            $input['photo'] = $imageName;
        }

        // Update data
        $data->update($input);

        // Return success response
        return response()->json(['success' => true, 'message' => 'Data updated successfully!']);
    } catch (\Exception $e) {
        // Return error response
        return response()->json(['error' => true, 'message' => 'An error occurred: ' . $e->getMessage()]);
    }
}

function deletesettings($id)
{
    try{			
        HomeBanner::where('id', $id)->delete(); 
        $success_message = "success";
        return response()->json(['success' => true, 'message' => 'Data delete successfully!']);
    }
    catch (Exception $e) {
        return response()->json(['error' => true, 'message' => 'An error occurred.']);
    }    
}
}  