<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\MessageBag;
use Validator;
use App\Models\HomeAbout;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Str;
use App\Http\Controllers\Includefunctions;
use DataTables;
use File;
use Illuminate\Support\Facades\Storage;

class HomeAboutController extends Controller
{
    //
    use Includefunctions; 
    function addsettings()
     {
         return view('backend.home.home_about.add');
     }

     
     public function insertsettings(Request $request)
     {
        try{
         // Validation rules
         $rules = [
             'description' => 'required',
             'caption' => 'required',
            'experience' => 'required',
             'photo' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg,webp',
             'photo2' => 'image|mimes:jpeg,png,jpg,gif,svg,webp',
             'photo3' => 'image|mimes:jpeg,png,jpg,gif,svg,webp',

            ];
         

     
         // Validate the request
         $validator = Validator::make($request->all(), $rules);
         if ($validator->fails()) {
             return back()->withErrors($validator->errors())->withInput();
         }

           // Handle the photo upload
            $imageName = time() . '.' . $request->photo->extension();
            $request->photo->storeAs('public/assets/home_about/photo', $imageName);
        
            $imageName2 = time() . '.' . $request->photo2->extension();
            $request->photo2->storeAs('public/assets/home_about/photo2', $imageName2);
    
            $imageName3 = time() . '.' . $request->photo3->extension();
            $request->photo3->storeAs('public/assets/home_about/photo3', $imageName3);
    

         // Current timestamp
         $now = now();
     
         // Create the Homeabout record
         Homeabout::create([
             'caption' => $request->caption,
             'small_description' => $request->small_description,
             'description' => $request->description,
            'experience' => $request->experience,
             'photo' => $imageName,
            'photo_text' => $request->photo_text,
            'photo2' => $imageName2,
            'photo_text2' => $request->photo_text2,
            'photo3' => $imageName3,
             'photo_text3' => $request->photo_text3,
             'link_caption' => $request->link_caption,
            'link' => $request->link,
             'created_at' => $now,
             'updated_at' => $now
             
         ]);
         $success_message = "success";
         return response()->json(['success' => true, 'message' => 'Data inserted successfully!']);
        }
        catch (Exception $e) {
               return response()->json(['error' => true, 'message' => 'An error occurred.']);
           }

        }    
     
     function viewsettings()
  
     {   
    
         return view('backend.home.home_about.view');
     }


     function ajaxview(Request $request)
     {
         if ($request->ajax()) {
             if ($request->ajax()) {
             $post = HomeAbout::latest()->get();
             return Datatables::of($post)
                     ->addIndexColumn()
                     ->escapeColumns([]) 
                     ->addColumn('action', function($row){
    
                            $btn = '<a href="'.route('admin.home.home_about.edit',$row->id).'" data-toggle="tooltip"  data-id="'.$row->id.'" data-original-title="Edit" class="edit btn btn-primary btn-sm editSca">Edit</a>';
                            // $btn = $btn.' <a href="javascript:deletesettings(\''.$row->id.'\');" data-toggle="tooltip"  data-id="'.$row->id.'" data-original-title="Delete" class="btn btn-danger btn-sm deletebtn">Delete</a>';

     
                             return $btn;
                     })
                     ->rawColumns(['action'])
                     ->make(true);
         }
       
         return view('backend.home.home_about.view',compact('post'));
     }
     }
     function editsettings($id)
     {
         $home_about = HomeAbout::where('id', $id)->first();
         return view('backend.home.home_about.edit',compact('home_about','id'));
     }
    function updatesettings(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'caption' => 'required',
                'description' => 'required',
                 'experience' => 'required',
            ]);

            if ($validator->fails()) {
                return back()->withErrors($validator->errors())->withInput();
            }

            $id = $request->id;
            $now = now();
            $data = HomeAbout::findOrFail($id);
            $input = [
                'caption' => $request->caption,
                'small_description' => $request->small_description,
                'description' => $request->description,
                'photo_text2' => $request->photo_text2,
                'photo_text3' => $request->photo_text3,
                'photo_text' => $request->photo_text,
                 'link_caption' => $request->link_caption,
                'link' => $request->link,

                'updated_at' => $now,
            ];

            if ($request->hasFile('photo')) {
                $file_path = 'public/assets/home_about/photo/' . $request->oldphoto;
                if (Storage::exists($file_path)) {
                    Storage::delete($file_path);
                }
                $imageName = time() . '-photo.' . $request->photo->extension();
                $request->photo->storeAs('public/assets/home_about/photo', $imageName);
                $input['photo'] = $imageName;
            }


             if ($request->hasFile('photo2')) {
                $file_path = 'public/assets/home_about/photo2/' . $request->oldphoto2;
                if (Storage::exists($file_path)) {
                    Storage::delete($file_path);
                }
                $imageName2 = time() . '-photo2.' . $request->photo2->extension();
                $request->photo2->storeAs('public/assets/home_about/photo2', $imageName2);
                $input['photo2'] = $imageName2;
            }

             if ($request->hasFile('photo3')) {
                $file_path = 'public/assets/home_about/photo3/' . $request->oldphoto3;
                if (Storage::exists($file_path)) {
                    Storage::delete($file_path);
                }
                $imageName3 = time() . '-photo3.' . $request->photo3->extension();
                $request->photo3->storeAs('public/assets/home_about/photo3', $imageName3);
                $input['photo3'] = $imageName3;
            }


            $data->update($input);
            return response()->json(['success' => true, 'message' => 'Data updated successfully!']);
        } catch (\Exception $e) {
            return response()->json(['error' => true, 'message' => $e->getMessage()], 500);
        }
    }

    function deletesettings($id)
    {
        try{			
            HomeAbout::where('id', $id)->delete(); 
            $success_message = "success";
            return response()->json(['success' => true, 'message' => 'Data delete successfully!']);
        }
        catch (Exception $e) {
            return response()->json(['error' => true, 'message' => 'An error occurred.']);
        }    
    }
}



