<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\MessageBag;
use Validator;
use App\Models\Industry;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Str;
use App\Http\Controllers\Includefunctions;
use DataTables;
use File;
use Illuminate\Support\Facades\Storage;

class IndustryController extends Controller
{
    use Includefunctions;

    function addsettings()
    {
        return view('backend.industry.add');
    }

    public function insertsettings(Request $request)
    {
        try {
            // Validation rules
            $rules = [
                'name' => 'required',
                'photo' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg,webp|max:2048',
            ];

            if (!$request->hasFile('photo')) {
                unset($rules['photo']);
            }

            $validator = Validator::make($request->all(), $rules);
            if ($validator->fails()) {
                return back()->withErrors($validator->errors())->withInput();
            }

            // Store the photo
            $imageName = null;
            if ($request->hasFile('photo')) {
                $imageName = time() . '-photo.' . $request->photo->extension();
                $request->photo->storeAs('public/assets/industry/photo', $imageName);
            }

            $seoUrl = $this->generateSeoUrl($request->seo_url);
            $now = now();

            Industry::create([
                'name' => $request->name,
                'photo_text' => $request->photo_text,
                'photo' => $imageName,
                'created_at' => $now,
                
            ]);

            return response()->json(['success' => true, 'message' => 'Data inserted successfully!']);
        } catch (\Exception $e) {
            return response()->json(['error' => true, 'message' => 'An error occurred.',$e]);
        }
    }

    function viewsettings()
    {
        return view('backend.industry.view');
    }

    function ajaxview(Request $request)
    {
        if ($request->ajax()) {
            $post = Industry::latest()->get();
            return Datatables::of($post)
                ->addIndexColumn()
                ->escapeColumns([])
                ->addColumn('action', function ($row) {
                    $action = '<div class="dropdown">
                        <button class="actionbutton btn btn-outline-secondary dropdown-toggle black-dropdown" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            Action
                        </button>
                        <div class="dropdown-menu blue-text" aria-labelledby="dropdownMenuButton">
                            <a class="dropdown-item" href="' . route('admin.industry.edit', $row->id) . '">
                                <i class="fa fa-edit"></i> Edit
                            </a>
                            <a class="dropdown-item deletebtn" href="javascript:deletesettings;" data-id="' . $row->id . '">
                                <i class="fa fa-trash"></i> Delete
                            </a>
                        </div>
                    </div>';
                    return $action;
                })
                ->rawColumns(['action'])
                ->make(true);
        }

        return view('backend.industry.view');
    }

    function editsettings($id)
    {
        $industry = Industry::findOrFail($id);
        return view('backend.industry.edit', compact('industry', 'id'));
    }

    function updatesettings(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'name' => 'required',
                'photo' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg,webp|max:2048',
            ]);

            if ($validator->fails()) {
                return back()->withErrors($validator->errors())->withInput();
            }

            $id = $request->id;
            $now = now();
            $data = Industry::findOrFail($id);

            $input = [
                'name' => $request->name,
                'photo_text' => $request->photo_text,
                'updated_at' => $now,
            ];

            if ($request->hasFile('photo')) {
                $file_path = 'public/assets/industry/photo/' . $request->oldphoto;
                if (Storage::exists($file_path)) {
                    Storage::delete($file_path);
                }
                $imageName = time() . '-photo.' . $request->photo->extension();
                $request->photo->storeAs('public/assets/industry/photo', $imageName);
                $input['photo'] = $imageName;
            }

            $data->update($input);

            return response()->json(['success' => true, 'message' => 'Data updated successfully!']);
        } catch (\Exception $e) {
            return response()->json(['error' => true, 'message' => $e->getMessage()], 500);
        }
    }

    function deletesettings($id)
    {
        try {
            Industry::where('id', $id)->delete();
            return response()->json(['success' => true, 'message' => 'Data delete successfully!']);
        } catch (\Exception $e) {
            return response()->json(['error' => true, 'message' => 'An error occurred.']);
        }
    }
}
