<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\MessageBag;
use Validator;
use App\Models\Job;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Str;
use App\Http\Controllers\Includefunctions;
use DataTables;
use File;
use Illuminate\Support\Facades\Storage;

class JobController extends Controller
{
    use Includefunctions;

    function addsettings()
    {
        return view('backend.job.add');
    }

    public function insertsettings(Request $request)
    {
        try {
            // Validation rules
            $rules = [
                'caption' => 'required',
                'job_type' => 'required',
                'photo' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg,webp|max:2048',
            ];

            if (!$request->hasFile('photo')) {
                unset($rules['photo']);
            }

            $validator = Validator::make($request->all(), $rules);
            if ($validator->fails()) {
                return back()->withErrors($validator->errors())->withInput();
            }

            // Store the photo
            $imageName = null;
            if ($request->hasFile('photo')) {
                $imageName = time() . '-photo.' . $request->photo->extension();
                $request->photo->storeAs('public/assets/job/photo', $imageName);
            }

            $seoUrl = $this->generateSeoUrl($request->seo_url);
            $now = now();

            Job::create([
                'caption' => $request->caption,
                'location' => $request->location,
                'link' => $request->link,
                'job_type' => $request->job_type,
                'photo_text' => $request->photo_text,
                'photo' => $imageName,
                'created_at' => $now,
                
            ]);

            return response()->json(['success' => true, 'message' => 'Data inserted successfully!']);
        } catch (\Exception $e) {
            return response()->json(['error' => true, 'message' => 'An error occurred.',$e]);
        }
    }

    function viewsettings()
    {
        return view('backend.job.view');
    }

    function ajaxview(Request $request)
    {
        if ($request->ajax()) {
            $post = Job::latest()->get();
            return Datatables::of($post)
                ->addIndexColumn()
                ->escapeColumns([])
                ->addColumn('action', function ($row) {
                    $action = '<div class="dropdown">
                        <button class="actionbutton btn btn-outline-secondary dropdown-toggle black-dropdown" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            Action
                        </button>
                        <div class="dropdown-menu blue-text" aria-labelledby="dropdownMenuButton">
                            <a class="dropdown-item" href="' . route('admin.job.edit', $row->id) . '">
                                <i class="fa fa-edit"></i> Edit
                            </a>
                            <a class="dropdown-item deletebtn" href="javascript:deletesettings;" data-id="' . $row->id . '">
                                <i class="fa fa-trash"></i> Delete
                            </a>
                        </div>
                    </div>';
                    return $action;
                })
                 ->addColumn('job_type', function($row){
                    if($row->job_type == 1) return 'Hot Job';
                    if($row->job_type == 2) return 'Top Employers';
                    return '';
                })
                ->rawColumns(['action'])
                ->make(true);
        }

        return view('backend.job.view');
    }

    function editsettings($id)
    {
        $job = Job::findOrFail($id);
        return view('backend.job.edit', compact('job', 'id'));
    }

    function updatesettings(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'caption' => 'required',
                'photo' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg,webp|max:2048',
            ]);

            if ($validator->fails()) {
                return back()->withErrors($validator->errors())->withInput();
            }

            $id = $request->id;
            $now = now();
            $data = Job::findOrFail($id);

            $input = [
                'caption' => $request->caption,
                'location' => $request->location,
                'link' => $request->link,
                'job_type' => $request->job_type,
                'photo_text' => $request->photo_text,
                'updated_at' => $now,
            ];

            if ($request->hasFile('photo')) {
                $file_path = 'public/assets/job/photo/' . $request->oldphoto;
                if (Storage::exists($file_path)) {
                    Storage::delete($file_path);
                }
                $imageName = time() . '-photo.' . $request->photo->extension();
                $request->photo->storeAs('public/assets/job/photo', $imageName);
                $input['photo'] = $imageName;
            }

            $data->update($input);

            return response()->json(['success' => true, 'message' => 'Data updated successfully!']);
        } catch (\Exception $e) {
            return response()->json(['error' => true, 'message' => $e->getMessage()], 500);
        }
    }

    function deletesettings($id)
    {
        try {
            Job::where('id', $id)->delete();
            return response()->json(['success' => true, 'message' => 'Data delete successfully!']);
        } catch (\Exception $e) {
            return response()->json(['error' => true, 'message' => 'An error occurred.']);
        }
    }
}
