<?php

namespace App\Http\Controllers\backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\JobOpenings;
use DataTables;
use Carbon\Carbon;

class JobOpeningsController extends Controller
{
    public function index(Request $request)
    {
        $keyword = $request->keyword ?? '';
        $date_from = $request->date_from ?? '';
        $date_to = $request->date_to ?? '';

        return view('backend.job_openings.viewsettings', compact('keyword', 'date_from', 'date_to'));
    }

    public function ajaxview(Request $request)
    {
        if ($request->ajax()) {

            $query = JobOpenings::query();

            // Keyword search across multiple columns
            if ($request->filled('keyword')) {
                $keyword = trim($request->keyword);
                $query->where(function ($q) use ($keyword) {
                    $q->where('candidate_id', 'like', "%$keyword%")
                    ->orWhere('candidate_first_name', 'like', "%$keyword%")
                      ->orWhere('company_name', 'like', "%$keyword%")
                      ->orWhere('contact_person', 'like', "%$keyword%")
                      ->orWhere('email', 'like', "%$keyword%")
                      ->orWhere('phone', 'like', "%$keyword%")
                      ->orWhere('company_location', 'like', "%$keyword%")
                      ->orWhere('job_title', 'like', "%$keyword%")
                      ->orWhere('job_category', 'like', "%$keyword%")
                      ->orWhere('job_type', 'like', "%$keyword%")
                      ->orWhere('salary_range', 'like', "%$keyword%")
                      ->orWhere('work_location', 'like', "%$keyword%")
                      ->orWhere('job_description', 'like', "%$keyword%")
                      ->orWhere('special_requirements', 'like', "%$keyword%")
                      ->orWhere('company_profile_pdf', 'like', "%$keyword%");
                });
            }

            // Filter by created_at date range
            if ($request->filled(['date_from', 'date_to'])) {
                $from = Carbon::parse($request->date_from)->startOfDay();
                $to = Carbon::parse($request->date_to)->endOfDay();
                $query->whereBetween('created_at', [$from, $to]);
            }

            $query->orderBy('id', 'DESC');

            return DataTables::of($query)
                ->addIndexColumn()
                ->addColumn('action', function ($row) {
                    return '
                        <a href="#" 
                            class="btn btn-primary btn-sm job_openings_details_btn" 
                            data-url="'.route('admin.job_openings.view_popup', $row->id).'">
                            View
                        </a>
                        <button class="btn btn-danger btn-sm deletejob_openings" data-id="'.$row->id.'">
                            Delete
                        </button>';
                })
                ->rawColumns(['action'])
                ->make(true);
        }
    }

    public function viewPopup($id)
    {
        $job = JobOpenings::findOrFail($id);
        return view('backend.job_openings.job_openingsdetails', compact('job'));
    }

    public function delete($id)
    {
        JobOpenings::where('id', $id)->delete();

        return response()->json([
            'success' => true,
            'message' => 'Record deleted successfully'
        ]);
    }
}
