<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\MessageBag;
use Validator;
use App\Models\LeadershipTeam;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Str;
use App\Http\Controllers\Includefunctions;
use DataTables;
use File;
use Illuminate\Support\Facades\Storage;

class LeadershipController extends Controller
{
    //
    use Includefunctions; 
    function addsettings()
     {
        
         return view('backend.leadership_team.add');
     }

     
     public function insertsettings(Request $request)
     {
        try{
         // Validation rules
         $rules = [
            'caption' => 'required',
            'photo' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg,webp|max:2048',

         ];
         
         // Remove validation rules for photo if not provided
         
         if (!$request->hasFile('photo')) {
             unset($rules['photo']);
         }
     
         // Validate the request
         $validator = Validator::make($request->all(), $rules);
         if ($validator->fails()) {
             return back()->withErrors($validator->errors())->withInput();
         }
     
         // Store the photo
         $imageName = null;
         if ($request->hasFile('photo')) {
             $imageName = time() . '-photo.' . $request->photo->extension();
             $request->photo->storeAs('public/assets/leadership_team/photo', $imageName);
         }
         
         // Current timestamp
         $now = now();
     
         // Create the LeadershipTeam record
         LeadershipTeam::create([
            'caption'            => $request->caption,
            'small_description'  => $request->small_description,
            'photo_text'         => $request->photo_text,
            'photo'              => $imageName,
            'updated_at'         => $now,
            'created_at'         => $now,
        ]);
         $success_message = "success";
        return response()->json(['success' => true, 'message' => 'Data updated successfully!']);
    } catch (\Exception $e) {
        // Return error response
        return response()->json(['error' => true, 'message' => 'An error occurred: ' . $e->getMessage()]);
    }
} 
     
     function viewsettings()
  
     {   
    
         return view('backend.leadership_team.view');
     }


     function ajaxview(Request $request)
     {
         if ($request->ajax()) {
             if ($request->ajax()) {
             $post = LeadershipTeam::latest()->get();
             return Datatables::of($post)
                     ->addIndexColumn()
                     ->escapeColumns([]) 
                     ->addColumn('action', function($row){
                        $action = '<div class="dropdown">
                        <button class="actionbutton btn btn-outline-secondary dropdown-toggle black-dropdown" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            Action
                        </button>
                        <div class="dropdown-menu blue-text" aria-labelledby="dropdownMenuButton">
                            <a class="dropdown-item" href="'.route('admin.leadership_team.edit', $row->id).'">
                                <i class="fa fa-edit"></i> Edit
                            </a>
                            <a class="dropdown-item deletebtn" href="javascript:deletesettings;" data-id="'.$row->id.'">
                                <i class="fa fa-trash"></i> Delete
                            </a>

                        </div>
                    </div>';
                    
                    return $action;
                })
                       
                     ->rawColumns(['action'])
                     ->make(true);
         }
       
        return view('backend.leadership_team.view',compact('post'));
     }
    }

     function editsettings($id)
     {
        $leadership_team = LeadershipTeam::where('id', $id)->get();
        return view('backend.leadership_team.edit',compact('leadership_team','id'));
     }

   function updateleadership(Request $request)
{
    try {
        $validator = Validator::make($request->all(), [
            'caption' => 'required',
            'photo' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg,webp|max:2048',
        ]);

        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'errors' => $validator->errors()
            ]);
        }

        $data = LeadershipTeam::findOrFail($request->id);

        $input = [
            'caption'           => $request->caption,
            'small_description' => $request->small_description,
            'photo_text'        => $request->photo_text, 
            'updated_at'        => now(),
        ];

        if ($request->hasFile('photo')) {
            $file_path = 'public/assets/leadership_team/photo/' . $request->oldphoto;
            if (Storage::exists($file_path)) {
                Storage::delete($file_path);
            }
            $imageName = time() . '-photo.' . $request->photo->extension();
            $request->photo->storeAs('public/assets/leadership_team/photo', $imageName);
            $input['photo'] = $imageName;
        }


        $data->update($input);

        return response()->json([
            'success' => true,
            'message' => 'Data updated successfully!'
        ]);
    } catch (\Exception $e) {
        return response()->json([
            'success' => false,
            'message' => $e->getMessage()
        ], 500);
    }
}

    function deletesettings($id)
    {
        try{			
            LeadershipTeam::where('id', $id)->delete(); 
            $success_message = "success";
            return response()->json(['success' => true, 'message' => 'Data delete successfully!']);
        }
        catch (Exception $e) {
            return response()->json(['error' => true, 'message' => 'An error occurred.']);
        }    
    }
}