<?php

namespace App\Http\Controllers\backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Session;
use App\Models\User;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Validator;

class ProfileController extends Controller
{
    function profileedit()
    {
        return view('backend.profile_edit');
    }
    function profileupdate(Request $request)
    {
        $id = auth()->user()->id;
        
        $now = date('Y-m-d H:i:s');
        $data = User::findOrFail($id);
        $input = [
            'name' => $request->name,
            'email' => $request->email,
            'phone' => $request->phone,
            'address' => $request->address,
            'sex' => $request->sex,
            'updated_at' => $now
           ];
            
        $rules = [
                'name' => 'required',
                'email' => 'required',
                'sex' => 'required',
            ]; 
                //validation
        $validator = Validator::make($request->all(),$rules);
        if($validator->fails()){
        return back()->withErrors($validator->errors())->withInput();  
        }      
         
        $data->update($input);
        return redirect()->route('admin.profileedit')
                ->withSuccess('You have successfully updated!');
    }
    function showchangepassword()
    {
        return view('backend.changepwd');
    }
    function changepassword(Request $request)
    {
        $rules = [
                'oldpassword' => 'required',
                'newpassword' => 'required',
                'cpassword' => 'required',
            ]; 
                //validation
        $validator = Validator::make($request->all(),$rules);
        if($validator->fails()){
        return back()->withErrors($validator->errors())->withInput();  
        }      
        
        $user = auth()->user();

        // Get old and new passwords from the request
        $oldPassword = $request->input('oldpassword');
        $newPassword = $request->input('newpassword');
        if (Hash::check($oldPassword, $user->password)) {
            // Old password is correct, update the password
            $newHashedPassword = Hash::make($newPassword);
            $user->password = $newHashedPassword;
            $user->save();

        return redirect()->route('admin.changepassword')
                ->withSuccess('You have successfully updated!');
        }
        else
        {
            return redirect()->route('admin.changepassword')
            ->withErrors(['error_message' => 'Change password failed!',"tab"=>'changepassword']);
        }
    }
}
