<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\MessageBag;
use Validator;
use App\Models\Services;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Str;
use App\Http\Controllers\Includefunctions;
use DataTables;
use File;
use Illuminate\Support\Facades\Storage;

class ServicesController extends Controller
{
    //
    use Includefunctions; 
    function addsettings()
     {
         return view('backend.services.add');
     }

     
     public function insertsettings(Request $request)
     {
        try{
         // Validation rules
         $rules = [
            'description' => 'required',
            'caption' => 'required',
            'seo_url' => 'required',
            'photo' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg,webp|max:2048',
            'description_photo' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg,webp|max:2048',

         ];
         
         // Remove validation rules for photo if not provided
         
         if (!$request->hasFile('photo')) {
             unset($rules['photo']);
         }
     
         // Validate the request
         $validator = Validator::make($request->all(), $rules);
         if ($validator->fails()) {
             return back()->withErrors($validator->errors())->withInput();
         }
     
         // Store the photo
         $imageName = null;
         if ($request->hasFile('photo')) {
             $imageName = time() . '-photo.' . $request->photo->extension();
             $request->photo->storeAs('public/assets/services/photo', $imageName);
         }
         

          $imageName1 = null;
         if ($request->hasFile('description_photo')) {
             $imageName1 = time() . '-description_photo.' . $request->description_photo->extension();
             $request->description_photo->storeAs('public/assets/services/description_photo', $imageName1);
         }

         
          $imageName2 = null;
         if ($request->hasFile('banner_photo')) {
             $imageName2 = time() . '-banner_photo.' . $request->banner_photo->extension();
             $request->banner_photo->storeAs('public/assets/services/banner_photo', $imageName2);
         }
         // Current timestamp
         $now = now();
     
         // Create the Services record
         Services::create([
            'caption'            => $request->caption,
             'small_caption'            => $request->small_caption,
            'small_description'  => $request->small_description,
             'link' => $request->link,
            'link_caption' => $request->link_caption,
            'description'        => $request->description,
            'photo_text'         => $request->photo_text,
            'photo'              => $imageName,
            'banner_photo' => $imageName2,
            'description_link'=> $request->description_link,
            'description_link_caption'=> $request->description_link_caption,
            'banner_photo_text'=> $request->banner_photo_text,
            'description_photo' => $imageName1,
             'description_photo_text'=> $request->description_photo_text,
             'feature_caption'            => $request->feature_caption,
            'feature_description' => $request->feature_description,
            'seo_url'            => $request->seo_url,
            'seo_title'          => $request->seo_title,
            'seo_keyword'        => $request->seo_keyword,
            'seo_description'    => $request->seo_description,
            'updated_at'         => $now,
            'created_at'         => $now,
        ]);
         $success_message = "success";
        return response()->json(['success' => true, 'message' => 'Data updated successfully!']);
    } catch (\Exception $e) {
        // Return error response
        return response()->json(['error' => true, 'message' => 'An error occurred: ' . $e->getMessage()]);
    }
} 
     
     function viewsettings()
  
     {   
    
         return view('backend.services.view');
     }


     function ajaxview(Request $request)
     {
         if ($request->ajax()) {
             if ($request->ajax()) {
             $post = Services::latest()->get();
             return Datatables::of($post)
                     ->addIndexColumn()
                     ->escapeColumns([]) 
                     ->addColumn('action', function($row){
                        $action = '<div class="dropdown">
                        <button class="actionbutton btn btn-outline-secondary dropdown-toggle black-dropdown" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            Action
                        </button>
                        <div class="dropdown-menu blue-text" aria-labelledby="dropdownMenuButton">
                            <a class="dropdown-item" href="'.route('admin.services.edit', $row->id).'">
                                <i class="fa fa-edit"></i> Edit
                            </a>
                            <a class="dropdown-item deletebtn" href="javascript:deletesettings;" data-id="'.$row->id.'">
                                <i class="fa fa-trash"></i> Delete
                            </a>

                              <a class="dropdown-item" href="'.route('admin.services.features.view', $row->id).'">
                                <i class="fa fa-edit"></i> Feature
                            </a>
                        </div>
                    </div>';
                    
                    return $action;
                })
                       
                     ->rawColumns(['action'])
                     ->make(true);
         }
       
        return view('backend.services.view',compact('post'));
     }
    }

     function editsettings($id)
     {
        $services = Services::where('id', $id)->get();
        return view('backend.services.edit',compact('services','id'));
     }

    public function updatesettings(Request $request)
{
    try {
        $validator = Validator::make($request->all(), [
            'caption' => 'required',
            'description' => 'required',
            'seo_url' => 'required',
            'photo' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg,webp|max:2048',
        ]);

        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'errors' => $validator->errors()
            ]);
        }

        $data = Services::findOrFail($request->id);

        $input = [
            'caption'           => $request->caption,
             'small_caption'            => $request->small_caption,
            'small_description' => $request->small_description,
            'link' => $request->link,
            'link_caption' => $request->link_caption,
            'description'        => $request->description,
            'photo_text'         => $request->photo_text,
            'description_link'=> $request->description_link,
            'description_link_caption'=> $request->description_link_caption,
            'banner_photo_text'=> $request->banner_photo_text,
            'description'       => $request->description,
             'description_photo_text'        => $request->description_photo_text, 
               'feature_caption'            => $request->feature_caption,
            'feature_description' => $request->feature_description,
            'seo_url'           => $this->generateSeoUrl($request->seo_url),
            'seo_title'         => $request->seo_title,
            'seo_keyword'       => $request->seo_keyword,
            'seo_description'   => $request->seo_description,
            'updated_at'        => now(),
        ];

        if ($request->hasFile('photo')) {
            $file_path = 'public/assets/services/photo/' . $request->oldphoto;
            if (Storage::exists($file_path)) {
                Storage::delete($file_path);
            }
            $imageName = time() . '-photo.' . $request->photo->extension();
            $request->photo->storeAs('public/assets/services/photo', $imageName);
            $input['photo'] = $imageName;
        }


         if ($request->hasFile('description_photo')) {
            $file_path = 'public/assets/services/description_photo/' . $request->oldphoto;
            if (Storage::exists($file_path)) {
                Storage::delete($file_path);
            }
            $imageName1 = time() . '-description_photo.' . $request->description_photo->extension();
            $request->description_photo->storeAs('public/assets/services/description_photo', $imageName1);
            $input['description_photo'] = $imageName1;
        }


        
         if ($request->hasFile('banner_photo')) {
            $file_path = 'public/assets/services/banner_photo/' . $request->oldphoto;
            if (Storage::exists($file_path)) {
                Storage::delete($file_path);
            }
            $imageName2 = time() . '-banner_photo.' . $request->banner_photo->extension();
            $request->banner_photo->storeAs('public/assets/services/banner_photo', $imageName2);
            $input['banner_photo'] = $imageName2;
        }

        $data->update($input);

        return response()->json([
            'success' => true,
            'message' => 'Data updated successfully!'
        ]);
    } catch (\Exception $e) {
        return response()->json([
            'success' => false,
            'message' => $e->getMessage()
        ], 500);
    }
}

    function deletesettings($id)
    {
        try{			
            Services::where('id', $id)->delete(); 
            $success_message = "success";
            return response()->json(['success' => true, 'message' => 'Data delete successfully!']);
        }
        catch (Exception $e) {
            return response()->json(['error' => true, 'message' => 'An error occurred.']);
        }    
    }
}