<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\MessageBag;
use Validator;
use App\Models\ServicesFeatures;
use App\Models\ViewServicesFeatures;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Str;
use App\Http\Controllers\Includefunctions;
use DataTables;
use File;
use Illuminate\Support\Facades\Storage;

class ServicesFeaturesController extends Controller
{
    use Includefunctions;

    public function addphotos()
    {
        return view('backend.services.features.add');
    }
    public function insertphotos(Request $request)
    {

    
        // Validate request data
        $request->validate([
            'photo' => 'nullable|image|mimes:jpeg,png,jpg,gif,webp',
            'description' => 'required',
            'caption' => 'required',
        ]);
    
           $services_id=$request->services_id;
           $imageName = null;
        if ($request->hasFile('photo')) {
          
            $imageName = time() . '-photo.' . $request->photo->extension();
            $request->photo->storeAs('public/assets/services/features', $imageName);
        }

            $now = now(); 

    
            // Insert data into the database
            ServicesFeatures::create([
                'caption' => $request->caption,
                'services_id' =>$services_id,
                'description' => $request->description,
                'photo' => $imageName, 
                'updated_at' => $now,
                'created_at' => $now,
            ]);
    
            return response()->json(['success' => true, 'message' => 'Features inserted successfully.'], 200);
        
    }
    
    
public function viewphotos($id)
{
    $services = ViewServicesFeatures::where('services_id', $id)->first();
    $services_id = $services->services_id ?? $id;

    return view('backend.services.features.view', compact('id', 'services', 'services_id'));
}

    
public function ajaxviewphotos(Request $request)
{
    if ($request->ajax()) {
        $servicesId = $request->services_id; // Match this with JS

        $photos = ServicesFeatures::where('services_id', $servicesId)
            ->select('id', 'caption', 'photo')
            ->get();

        return DataTables::of($photos)
            ->addIndexColumn() // DT_RowIndex
            ->addColumn('photo', function ($photo) {
                $imageUrl = $photo->photo ? asset('storage/assets/services/features/' . $photo->photo) : '';
                return $imageUrl ? '<img src="' . $imageUrl . '" width="70" class="img-thumbnail" />' : '';
            })
            ->addColumn('action', function ($photo) {
                $editUrl = route('admin.services.features.edit', $photo->id);
                $deleteUrl = "javascript:deletefeatures('" . $photo->id . "');";
                return '<a href="' . $editUrl . '" class="edit btn btn-primary btn-sm" title="Edit">Edit</a> ' .
                       '<a href="' . $deleteUrl . '" class="delete btn btn-danger btn-sm" title="Delete">Delete</a>';
            })
            ->rawColumns(['photo', 'action'])
            ->make(true);
    }

    return view('backend.services.features.view'); 
}



    public function editphotos($id)
    {
        $services = ViewServicesFeatures::where('services_id', $id)->first();

        $features = ServicesFeatures::findOrFail($id);

        return view('backend.services.features.edit', compact('features','services',));
    }

   
public function updatephotos(Request $request)
{
    $id = $request->id;
    $features = ServicesFeatures::findOrFail($id);

    $rules = [
        'photo' => 'nullable|image|mimes:jpeg,png,jpg,gif,webp',
        'description' => 'required',
        'caption' => 'required',
    ];

    $validator = Validator::make($request->all(), $rules);

    if ($validator->fails()) {
        return response()->json(['success' => false, 'message' => $validator->errors()->first()], 400);
    }

    $features->caption = $request->caption;
    $features->description = $request->description;

    // Handle photo 1 update
    if ($request->hasFile('photo')) {
        $photo = $request->file('photo');
        if ($photo->isValid()) {
            $imageName = time() . '-photo.' . $photo->extension();
            $photo->storeAs('public/assets/services/features', $imageName);

            if ($features->photo) {
                Storage::delete('public/assets/services/features/' . $features->photo);
            }

            $features->photo = $imageName;
        } else {
            return response()->json(['success' => false, 'message' => 'Invalid photo file uploaded'], 400);
        }
    }

    $features->save();

    return response()->json(['success' => true, 'message' => 'Photos updated successfully'], 200);
}

   public function deletephotos($id)
{
    // Find the record
    $features = ServicesFeatures::find($id);

    if ($features) {
        // Delete photo if it exists
        if ($features->photo && Storage::exists('public/assets/services/features/' . $features->photo)) {
            Storage::delete('public/assets/services/features/' . $features->photo);
        }


        // Delete the database record
        $features->delete();

        return response()->json(['success' => true, 'message' => 'Photos deleted successfully.']);
    }

    // If record not found
    return response()->json(['success' => false, 'message' => 'Photo not found.'], 404);
}


}
