<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\MessageBag;
use Validator;
use App\Models\Testimonial;
use App\Models\TestimonialCaption;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Str;
use App\Http\Controllers\Includefunctions;
use DataTables;
use File;

use Illuminate\Support\Facades\Storage;

class TestimonialController extends Controller
{
    use Includefunctions;

    function addsettings()
    {
        return view('backend.testimonial.add');
    }

    public function insertsettings(Request $request)
    {
        try {
            // Validation rules
            $rules = [
                'description' => 'required',
                'name' => 'required',
            ];

            if (!$request->hasFile('photo')) {
                unset($rules['photo']);
            }

            $validator = Validator::make($request->all(), $rules);
            if ($validator->fails()) {
                return back()->withErrors($validator->errors())->withInput();
            }

            // Store the photo
            $imageName = null;
            if ($request->hasFile('photo')) {
                $imageName = time() . '-photo.' . $request->photo->extension();
                $request->photo->storeAs('public/assets/testimonial/photo', $imageName);
            }

            $seoUrl = $this->generateSeoUrl($request->seo_url);
            $now = now();

            Testimonial::create([
                'name' => $request->name,
                'location' => $request->location,
                'description' => $request->description,
                'photo_text' => $request->photo_text,
                'photo' => $imageName,
                'created_at' => $now,
                
            ]);

            return response()->json(['success' => true, 'message' => 'Data inserted successfully!']);
        } catch (\Exception $e) {
            return response()->json(['error' => true, 'message' => 'An error occurred.']);
        }
    }

    function viewsettings()
    {
        return view('backend.testimonial.view');
    }

    function ajaxview(Request $request)
    {
        if ($request->ajax()) {
            $post = Testimonial::latest()->get();
            return Datatables::of($post)
                ->addIndexColumn()
                ->escapeColumns([])
                ->addColumn('action', function ($row) {
                    $action = '<div class="dropdown">
                        <button class="actionbutton btn btn-outline-secondary dropdown-toggle black-dropdown" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            Action
                        </button>
                        <div class="dropdown-menu blue-text" aria-labelledby="dropdownMenuButton">
                            <a class="dropdown-item" href="' . route('admin.testimonial.edit', $row->id) . '">
                                <i class="fa fa-edit"></i> Edit
                            </a>
                            <a class="dropdown-item deletebtn" href="javascript:deletesettings;" data-id="' . $row->id . '">
                                <i class="fa fa-trash"></i> Delete
                            </a>
                        </div>
                    </div>';
                    return $action;
                })
                ->rawColumns(['action'])
                ->make(true);
        }

        return view('backend.testimonial.view');
    }

    function editsettings($id)
    {
        $testimonial = Testimonial::findOrFail($id);
        return view('backend.testimonial.edit', compact('testimonial', 'id'));
    }

    function updatesettings(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'name' => 'required',
                'description' => 'required',
            ]);

            if ($validator->fails()) {
                return back()->withErrors($validator->errors())->withInput();
            }

            $id = $request->id;
            $now = now();
            $data = Testimonial::findOrFail($id);

            $input = [
                'name' => $request->name,
                'location' => $request->location,
                'description' => $request->description,
                'photo_text' => $request->photo_text,
                'updated_at' => $now,
            ];

            if ($request->hasFile('photo')) {
                $file_path = 'public/assets/testimonial/photo/' . $request->oldphoto;
                if (Storage::exists($file_path)) {
                    Storage::delete($file_path);
                }
                $imageName = time() . '-photo.' . $request->photo->extension();
                $request->photo->storeAs('public/assets/testimonial/photo', $imageName);
                $input['photo'] = $imageName;
            }

            $data->update($input);

            return response()->json(['success' => true, 'message' => 'Data updated successfully!']);
        } catch (\Exception $e) {
            return response()->json(['error' => true, 'message' => $e->getMessage()], 500);
        }
    }

    function deletesettings($id)
    {
        try {
            Testimonial::where('id', $id)->delete();
            return response()->json(['success' => true, 'message' => 'Data delete successfully!']);
        } catch (\Exception $e) {
            return response()->json(['error' => true, 'message' => 'An error occurred.']);
        }
    }


    
public function testimonial_captioneditsettings($id)
{
    $testimonial_caption = TestimonialCaption::findOrFail($id);
    return view('backend.testimonial_caption.edit', compact('testimonial_caption'));
}

public function testimonial_captionupdatesettings(Request $request)
{
    $id = $request->id;
    $testimonial_caption = TestimonialCaption::findOrFail($id);

    $rules = [
        'caption' => 'required',
        'description' => 'required',
    ];

    $validator = Validator::make($request->all(), $rules);

    if ($validator->fails()) {
        return response()->json(['success' => false, 'message' => $validator->errors()->first()], 400);
    }

    $testimonial_caption->caption = $request->caption;
    $testimonial_caption->description = $request->description;
   
    $testimonial_caption->save();

    return response()->json(['success' => true, 'message' => 'Testimonial updated successfully'], 200);
}

}
