<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\MessageBag;
use Validator;
use App\Models\User;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Str;
use App\Http\Controllers\Includefunctions;
use DataTables;
use File;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Hash;

class UsersController extends Controller
{
    //
    use Includefunctions; 
    
    public function addsettings()
    {
        return view('backend.users.add');
    }
    public function editsettings($id)
    {
        $users = User::find($id);
        return view('backend.users.edit', compact('users'));
    }
// insert the User
        public function insertsettings(Request $request)
        {
        try {
            // Validate the input, ensuring PDF is optional but must be a valid file if uploaded
            $validator = Validator::make($request->all(), [
            'name' => 'required',
            'email' => 'required',
            'password' => 'required',
            ]);

            if ($validator->fails()) {
                return response()->json(['error' => true, 'message' => $validator->errors()->first()], 422);
            }

                       
            $now = date('Y-m-d H:i:s');
            User::create([
               'name'  => $request->name,
               'email' => $request->email, 
               'password' => Hash::make($request->password), 
               'created_at' => $now
            ]); 

            // Return success response for AJAX call
            return response()->json(['success' => true, 'message' => 'User updated successfully!']);
        } catch (\Exception $e) {
            return response()->json(['error' => true, 'message' => 'Error: ' . $e->getMessage()], 500);
        }
    }
    // Update the User
    public function updatesettings(Request $request)
    {
        try {
            // Validate the input, ensuring PDF is optional but must be a valid file if uploaded
            $validator = Validator::make($request->all(), [
                'name' => 'required',
                'email' => 'required',
            ]);

            if ($validator->fails()) {
                return response()->json(['error' => true, 'message' => $validator->errors()->first()], 422);
            }

            $id = $request->id;
            $now = now();

            $data = User::findOrFail($id);
            $input = [
                'name'  => $request->name,
                'email' => $request->email, 
                'updated_at' => $now,
            ];
            $data->update($input);

            // Return success response for AJAX call
            return response()->json(['success' => true, 'message' => 'User updated successfully!']);
        } catch (\Exception $e) {
            return response()->json(['error' => true, 'message' => 'Error: ' . $e->getMessage()], 500);
        }
    }

     function viewsettings()
  
     {   
    
         return view('backend.users.view');
     }


     function ajaxview(Request $request)
     {
         if ($request->ajax()) {
             if ($request->ajax()) {
             $post = User::latest()->get();
             return Datatables::of($post)
                     ->addIndexColumn()
                     ->escapeColumns([]) 
                     ->addColumn('action', function($row){
    
                            $btn = '<a href="'.route('admin.users.edit',$row->id).'" data-toggle="tooltip"  data-id="'.$row->id.'" data-original-title="Edit" class="edit btn btn-primary btn-sm">Edit</a>';
                            $btn = $btn = $btn.' <a href="'.route('admin.users.resetpwd',$row->id).'" data-toggle="tooltip"  data-id="'.$row->id.'" data-original-title="Reset Password" class="edit btn btn-primary btn-sm">Reset Password</a>';
                            if($row->id!=1)
                            $btn = $btn.' <a href="javascript:deletesettings(\''.$row->id.'\');" data-toggle="tooltip"  data-id="'.$row->id.'" data-original-title="Delete" class="btn btn-danger btn-sm deletebtn">Delete</a>';
     
                            
                             return $btn;
                     })
                     ->rawColumns(['action'])
                     ->make(true);
         }
       
         return view('backend.users.view',compact('post'));
     }
     }

     public function resetpwdsettings($id)
     {
         $users = User::find($id);
         return view('backend.users.resetpwd', compact('users'));
     }

     // Update the User
    public function restpwd_update(Request $request)
    {
        try {
            // Validate the input, ensuring PDF is optional but must be a valid file if uploaded
            $validator = Validator::make($request->all(), [
                'password' => 'required',
            ]);

            if ($validator->fails()) {
                return response()->json(['error' => true, 'message' => $validator->errors()->first()], 422);
            }

            $id = $request->id;
            $now = now();

            $data = User::findOrFail($id);
            $input = [
                'password' => Hash::make($request->password),
                'updated_at' => $now,
            ];
            $data->update($input);

            // Return success response for AJAX call
            return response()->json(['success' => true, 'message' => 'Password updated successfully!']);
        } catch (\Exception $e) {
            return response()->json(['error' => true, 'message' => 'Error: ' . $e->getMessage()], 500);
        }
    }

}        



