<?php

namespace App\Http\Controllers\frontend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;
use PHPMailer\PHPMailer\PHPMailer;
use App\Models\Contact;
use PHPMailer\PHPMailer\Exception;
use App\Http\Traits\CommonPluginTraits;
use Validator;

class ContactController extends Controller
{
    use CommonPluginTraits;


      public function contactsubmit(Request $request)
      {
          $rules = [
              'name' => 'required',
              'subject' => 'required',
              'email' => 'required|email',
              'phone' => 'required',
              'message' => 'required',
               
          ];
      
          $validator = Validator::make($request->all(), $rules);
      
          if ($validator->fails()) {
              return back()->withErrors($validator->errors())->withInput();
          }

          Contact::create([
              'name' => $this->sanitizeString($request->name),
              'email' => $this->sanitizeString($request->email),
              'phone' => $this->sanitizeString($request->phone),
              'subject' => $this->sanitizeString($request->subject),
              'message' => $this->sanitizeString($request->message),
              'created_at' => now(),
          ]);

          $messageBody = '
          <!DOCTYPE html>
          <html lang="en">
          <head>
            <meta charset="UTF-8">
            <meta name="viewport" content="width=device-width, initial-scale=1.0">
            <title>Enquiry Submission</title>
            <style>
              body {
                font-family: Poppins, sans-serif;
                padding: 20px;
                background: #0000;
              }
          
              .container {
                  background-color: #022553;
                width: 80%;
                max-width: 600px;
                margin: 0 auto;
              }
          
              .inner_container {
               background-color: whitesmoke;
              padding: 50px;
                border: 1px solid #ddd;
              }
          
              header, footer {
                text-align: center;
              }
          
              .email_inner_section {
                padding: 20px 0 0px;
              }
          
              hr {
                height: 5px;
                background-color: brown;
                border: none;
              }
          
              h1 {
                color: brown;
              }
                h3{
                    text-align: center;
                    }
          
              .enquiry_submission table {
                text-align: left;
                margin-top: 50px;
                width: 100%;
                border-collapse: collapse;
              }
          
              .enquiry_submission table tbody tr th {
                width: 30%;
                vertical-align: top;
              }
          
              .enquiry_submission th, .enquiry_submission td {
                padding: 10px;
                margin: 0;
              }
          
              .enquiry_submission th {
                color: brown;
                font-weight: 900;
              }
          
              .enquiry_submission td {
                font-weight: 100;
              }
          
              .email_footer {
                font-size: 10px;
                color: #ffffff;
                padding: 20px 0;
              }
          
              .email_footer a {
                color: #ffffff;
                text-decoration: none;
              }
                .email_footer p{
                 color: #ffffff;
                }

                .logo{
                width:150px;
                }

    
          
              @media only screen and (max-width: 500px) {
                .enquiry_submission th, .enquiry_submission td {
                  display: block;
                  width: 100% !important;
                }
              }
            </style>
          </head>
          <body>
            <div class="container">
              <div class="inner_container">
                <header>
                 <img src="https://yestenew.com/public/assets/frontend/img/logo.jpg" class="logo" alt="YESTE Global Pty Ltd
 " />

                  <h1>YESTE Global Pty Ltd</h1>
                </header>
                <hr>
                <div class="email_content">
                  <div class="email_inner_section">
                    <section>
                      <h3 >Hi YESTE Global Pty Ltd, you have a new enquiry submission from ' . $this->sanitizeString($request->name) . '.</h3>
                    </section>
                    <section class="enquiry_submission">
                      <table>
                        <tbody>
                          <tr>
                            <th>Name</th>
                            <td>' . $this->sanitizeString($request->name) . '</td>
                          </tr>
                          <tr>
                            <th>Email Address</th>
                            <td>' . $this->sanitizeString($request->email) . '</td>
                          </tr>
                          <tr>
                            <th>Phone Number</th>
                            <td>' . $this->sanitizeString($request->phone) . '</td>
                          </tr>
                          <tr>
                            <th>Subject</th>
                            <td>' . $this->sanitizeString($request->subject) . '</td>
                          </tr>
                          <tr>
                            <th>Message</th>
                            <td>' . $this->sanitizeString($request->message) . '</td>
                          </tr>
                        </tbody>
                      </table>
                    </section>
                  </div>
                </div>
              </div>
              <footer>
                <section class="email_footer">
                  <img src="https://yestenew.com/public/assets/frontend/img/logo.jpg" width="100px" alt="YESTE Global Pty Ltd" />
                  <p>
                    <a href="https://yestenew.com/">YESTE Global Pty Ltd</a>
                  </p>
                  <p> Unit 1 171 Mort Street Lithgow NSW 2790, Sydney</p>
                  <p>Copyright &copy; <script>document.write(new Date().getFullYear())</script> YESTE Global Pty Ltd All Rights Reserved</p>
                </section>
              </footer>
            </div>
          </body>
          </html>';
           $successMessage = "<p style='font-family: Arial, sans-serif; line-height: 1.6; color: #333;'>
                            Thank you for contacting <strong>YESTE Global Pty Ltd/strong>.
                        </p>";
                  return  $messageBody;
          $mail = new PHPMailer(true);
      
          try {
              $mail->isSMTP();
              $mail->Host = env('MAIL_HOST');
              $mail->SMTPAuth = true;
              $mail->Username = env('MAIL_USERNAME');
              $mail->Password = env('MAIL_PASSWORD');
              $mail->SMTPSecure = env('MAIL_ENCRYPTION');
              $mail->Port = env('MAIL_PORT');
            $mail->SMTPOptions = [
                'ssl' => [
                    'verify_peer' => false,
                    'verify_peer_name' => false,
                    'allow_self_signed' => true,
                ],
            ];
              $mail->setFrom(env('MAIL_FROM_ADDRESS'), $this->sanitizeString($request->uname));
              $mail->addAddress('trainee@liveweare.com', 'YESTE Global Pty Ltd');
              $mail->Subject = "Request a call back from website";
              $mail->Body = $messageBody;
              $mail->isHTML(true);
      
              if ($mail->send()) {
                  return redirect()->route('frontend.thankyou')->with([
                      'caption' => 'Request a call back',
                      'status' => 'success',
                      'message' => $successMessage
                  ]);
              } else {
                  return redirect()->route('frontend.thankyou')->with([
                      'caption' => 'Request a call back',
                      'status' => 'error',
                      'message' => 'Message not sent: Something went wrong'
                  ]);
              }
          } catch (Exception $e) {
              throw new \Exception('Error sending email: ' . $e->getMessage());
          }
      }

     
      
}
