<?php

namespace App\Http\Controllers\frontend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Services;
use App\Models\Faq;
use App\Models\Blog;
use App\Models\SeoContents;
use App\Models\LeadershipTeam;
use App\Models\Testimonial;
use App\Models\Industry;
use App\Models\Expertise;
use App\Models\Excellence;
use App\Models\HomeAbout;
use App\Models\Aboutus;
use App\Models\AboutFeatures;
use App\Models\HomeBanner;
use App\Models\Job;
use App\Models\ServicesFeatures;
use App\Http\Traits\CommonPluginTraits;

class HomeController extends Controller
{
     use CommonPluginTraits;
    public function index()
    {  
       
        $testimonials = Testimonial::OrderBy('id','asc')->get();
        $home_about = HomeAbout::first();
        $home_banner = HomeBanner::first();
        $industry = Industry::OrderBy('id','asc')->get(); 
        $expertise = Expertise::OrderBy('id','asc')->limit(4)->get();
        $excellence = Excellence::OrderBy('id','asc')->limit(6)->get();
        $services = Services::orderBy('caption', 'desc')->limit(6)->get();
        
        $jobs = Job::OrderBy('id','asc')->get(); 
        $hotJobs = $jobs->where('job_type', 1);
        $topEmployers = $jobs->where('job_type', 2);
        
        return view('frontend.home',compact('testimonials','home_about','industry','home_banner','services','expertise','excellence','jobs','hotJobs','topEmployers'));
    }


     public function about()
    {

        $about = Aboutus::first(); 
        $features = AboutFeatures::where('about_id', $about->id)->get();
        $seo = SeoContents::where('page_name', 'about')->first();
        $about_id=$seo->id;
        $seo_title = $seo->seo_title;
        $seo_description = $seo->seo_description;
        $seo_keyword = $seo->seo_keyword;
        $additional_tags = $seo->additional_tags;
        return view('frontend.about',compact('seo_title','seo_description','seo_keyword','additional_tags','about', 'features'));
    }

     public function services()
    {  
        $services = Services::OrderBy('id','asc')->get();
        return view('frontend.services',compact('services'));
    }
     public function service(Request $request)
    {
        $seo_url = $this->sanitizestring($request->seo_url);
        $services = Services::where('seo_url', $seo_url)->first();
        $services_features = ServicesFeatures::where('services_id', $services->id)->get();
        $seo = SeoContents::where('page_name', 'services')->first();
        $seo_keyword = $services->seo_keyword;
        $seo_title = $services->seo_title;
        $seo_description = $services->seo_description;

        return view('frontend.service',compact('services','seo_keyword','seo_title','seo_description','services_features'));
    }


    public function faq()
    {  
        $faq = Faq::OrderBy('priority','asc')->get();
        return view('frontend.faq',compact('faq'));
    }
   
    public function  blog($seo_url)
    {
        $blog = Blog::where('seo_url', $seo_url)->firstOrFail();     
        $blogall = Blog::orderBy('caption', 'desc')->limit(10)->get();
       
        return view('frontend.blog',compact('blog','blogall'));
    }
    public function  blogs()
    {
      $blogs = Blog::OrderBy('caption', 'asc')->paginate(6);
      $seo_title = SeoContents::where('page_name', 'blog')->pluck('seo_title')->first();
      $seo_keyword = SeoContents::where('page_name', 'blog')->pluck('seo_keyword')->first();
      $seo_description = SeoContents::where('page_name', 'blog')->pluck('seo_description')->first();
        return view('frontend.blogs', compact('blogs','seo_title','seo_keyword','seo_description'));
    }

    public function  leadership_profiles()
    {
      $leadership_profiles = LeadershipTeam::OrderBy('id', 'asc')->paginate(6);
      $seo_title = SeoContents::where('page_name', 'leadership_profiles')->pluck('seo_title')->first();
      $seo_keyword = SeoContents::where('page_name', 'leadership_profiles')->pluck('seo_keyword')->first();
      $seo_description = SeoContents::where('page_name', 'leadership_profiles')->pluck('seo_description')->first();
        return view('frontend.leadership_profiles', compact('leadership_profiles','seo_title','seo_keyword','seo_description'));
    }

    public function contact()

    {  
        return view('frontend.contactus');
    }
       
    public function hire_now()
    {  
       
        return view('frontend.hire_now');
    }

        public function find_job()
    {  
        $token = ZohoService::getAccessToken();
    
        $response = Http::withHeaders([
            'Authorization' => 'Zoho-oauthtoken ' . $token,
        ])->get(env('ZOHO_RECRUIT_BASE') . '/jobs');
       
        return view('frontend.find_a_job');
    }
    public function testimonials()
    {  
     $testimonials = Testimonial::OrderBy('id','asc')->get();
        return view('frontend.testimonials',compact('testimonials'));
    }
    public function thankyou()
    {  
       
        return view('frontend.thankyou');
    }
    
}