<?php
namespace App\Http\Controllers\frontend;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Http;   // <-- ADD THIS
use App\Services\ZohoService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use App\Models\JobOpenings;
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

class JobController extends Controller
{
    
public function find_job(Request $request)
{
    $token = ZohoService::getAccessToken();
    $sortBy = $request->sortby;

    $page = (int) ($request->page ?? 1);
    if ($page < 1) $page = 1;

    $perPage = 10;

    // ---- Get ALL jobs to count total pages ----
    $response1 = Http::withHeaders([
        'Authorization' => 'Zoho-oauthtoken ' . $token,
    ])->get('https://recruit.zoho.in/recruit/v2/Job_Openings');

    $json1 = $response1->json();
   // return $json1;

    $jobs1 = collect($json1['data'] ?? []);
     // Keyword
    if ($request->filled('keyword')) {
        $keyword = strtolower($request->keyword);

        $jobs1 = $jobs1->filter(function ($job) use ($keyword) {
            return str_contains(strtolower($job['Job_Opening_Name'] ?? ''), $keyword)
                || str_contains(strtolower($job['Job_Description'] ?? ''), $keyword)
                || str_contains(strtolower($job['City'] ?? ''), $keyword);
        });
    }

    // Designation
    if ($request->filled('job_category')) {
        $jobs1 = $jobs1->whereIn('Designation', $request->job_category);
    }

    // Job Type
    if ($request->filled('jobtype')) {
        $jobs1 = $jobs1->whereIn('Job_Type', $request->jobtype);
    }

    // Experience
    if ($request->filled('workexperience')) {
        $jobs1 = $jobs1->where('Work_Experience', $request->workexperience);
    }

    // Salary
    if ($request->filled('salary')) {
        $jobs1 = $jobs1->where('Salary', $request->salary);
    }

    // Sponsorship
    if ($request->filled('sponsorship')) {
        $jobs1 = $jobs1->where('Sponsorship', $request->sponsorship);
    }
    $jobs1 = $jobs1->where('Fetch_Into_Website', true);
    $jobsCount = $jobs1->count();

    // Total pages
    $noofpages = (int) ceil($jobsCount / $perPage);


    // ---- Get paginated records ----
    $response = Http::withHeaders([
        'Authorization' => 'Zoho-oauthtoken ' . $token,
    ])->get('https://recruit.zoho.in/recruit/v2/Job_Openings', [
        'page'     => $page,
        'per_page' => $perPage,
    ]);

    if ($response->failed()) {
        return [
            'status' => $response->status(),
            'error'  => $response->json(),
            'body'   => $response->body(),
        ];
    }

    $json = $response->json();
    
    $jobs = collect($json['data'] ?? []);

    // Make sure info is ALWAYS an array
    $info = is_array($json['info'] ?? null) ? $json['info'] : [];


    // --------------------------
    // APPLY FILTERS IN COLLECTION
    // --------------------------

    // Keyword
    if ($request->filled('keyword')) {
        $keyword = strtolower($request->keyword);

        $jobs = $jobs->filter(function ($job) use ($keyword) {
            return str_contains(strtolower($job['Job_Opening_Name'] ?? ''), $keyword)
                || str_contains(strtolower($job['Job_Description'] ?? ''), $keyword)
                || str_contains(strtolower($job['City'] ?? ''), $keyword);
        });
    }

    // Designation
    if ($request->filled('job_category')) {
        $jobs = $jobs->whereIn('Designation', $request->job_category);
    }

    // Job Type
    if ($request->filled('jobtype')) {
        $jobs = $jobs->whereIn('Job_Type', $request->jobtype);
    }

    // Experience
    if ($request->filled('workexperience')) {
        $jobs = $jobs->where('Work_Experience', $request->workexperience);
    }

    // Salary
    if ($request->filled('salary')) {
        $jobs = $jobs->where('Salary', $request->salary);
    }

    // Sponsorship
    if ($request->filled('sponsorship')) {
        $jobs = $jobs->where('Sponsorship', $request->sponsorship);
    }

    if ($sortBy == 1) {
        // Newest first
        $jobs = $jobs->sortByDesc(function ($job) {
            return strtotime($job['Created_Time'] ?? '1970-01-01');
        })->values();
    }
    
    if ($sortBy == 2) {
        // Oldest first
        $jobs = $jobs->sortBy(function ($job) {
            return strtotime($job['Created_Time'] ?? '1970-01-01');
        })->values();
    }
    
    $jobs = $jobs1->where('Fetch_Into_Website', true);

    // --------------------------
   
   
    
    
    $response = Http::withHeaders([
    'Authorization' => 'Zoho-oauthtoken ' . $token,
])->get('https://recruit.zoho.in/recruit/v2/settings/fields?module=Job_Openings');

// Decode response
$json = $response->json();

//return $json;
// Extract fields array
$fields = $json['fields'] ?? [];

//return $fields;

$categories     = $this->getPicklist($fields, 'Designation');
$jobtypes       = $this->getPicklist($fields, 'Job_Type');
$salaries       = $this->getPicklist($fields, 'Salary');
$sponsorships   = $this->getPicklist($fields, 'Sponsorship');
$workexp        = $this->getPicklist($fields, 'Year_Of_Experience');




    return view('frontend.find_a_job', [
        'jobs'          => $jobs,
        'info'          => $info,        // ALWAYS ARRAY
        'page'          => $page,
        'perPage'       => $perPage,
        'categories'    => $categories,
        'jobtypes'      => $jobtypes,
        'workexperiences'=> $workexp,
        'salaries'      => $salaries,
        'sponsorships'  => $sponsorships,
        'noofpages'     => $noofpages,
        'jobsCount'     => $jobsCount,
    ]);
}

private function getPicklist($fields, $apiName)
{
    $field = collect($fields)->firstWhere('api_name', $apiName);

    if (!$field || !isset($field['pick_list_values'])) {
        return [];
    }

    return collect($field['pick_list_values'])
        ->reject(function ($item) {
            return isset($item['actual_value']) && $item['actual_value'] === '-None-';
        })
        ->values()
        ->all();
}


public function getDesignations()
{
    $token = ZohoService::getAccessToken();

    $response = Http::withHeaders([
        'Authorization' => 'Zoho-oauthtoken ' . $token,
    ])->get('https://recruit.zoho.in/recruit/v2/settings/modules/Candidates/fields');

    if ($response->failed()) {
        return [];
    }

    $json = $response->json();
    $designations = [];

    if (!empty($json['fields'])) {
        foreach ($json['fields'] as $field) {

            if ($field['api_name'] === "Designation" || $field['api_name'] === "Current_Job_Title") {

                // picklist values
                foreach ($field['pick_list_values'] as $value) {
                    $designations[] = $value['display_value'];
                }
            }
        }
    }

    return $designations;
}


public function zohocallback()
{
    
}


public function applynow(Request $request)
{
    $job_id = $request->id;
$token = ZohoService::getAccessToken();

$response = Http::withHeaders([
    'Authorization' => 'Zoho-oauthtoken ' . $token,
])->get('https://recruit.zoho.in/recruit/v2/settings/fields?module=Candidates');

// Decode response
$json = $response->json();

//return $json;
// Extract fields array
$fields = $json['fields'] ?? [];

//return $fields;

$Current_Experience = optional(collect($fields)->firstWhere('api_name', 'Current_Experience_1'))['pick_list_values'] ?? [];
$Year_Of_Experience = optional(collect($fields)->firstWhere('api_name', 'Year_Of_Experience'))['pick_list_values'] ?? [];

$AHPRA_Registration = optional(collect($fields)->firstWhere('api_name', 'Do_you_have_AHPRA_Registration1'))['pick_list_values'] ?? [];

$Current_Job_Title = optional(collect($fields)->firstWhere('api_name', 'Current_Job_Title'))['pick_list_values'] ?? [];

    
     return view('frontend.applynow', compact('job_id','Current_Experience','Year_Of_Experience','AHPRA_Registration'));
    
}

public function applynow_submit(Request $request)
{
    try {

        // Validate Request
        $request->validate([
            'first_name' => 'required',
            'last_name'  => 'required',
            'phone'      => 'required',
            'email'      => 'required|email',
            'year_of_experience' => 'required',
            'current_experience' => 'required',
            'aphra_status' => 'required',
            'resume'       => 'nullable|file|mimes:pdf,doc,docx,txt,rtf|max:20480',
            'job_id' => 'required'
        ]);

        // STEP 1: Get Zoho Access Token
        $token = ZohoService::getAccessToken();
        if (!$token) {
            return response()->json([
                            "success" => false,
                            "message" => "Unable to generate Zoho access token"
                        ], 500);
        }
        
        $jobId = $request->job_id;
        $responsejob = Http::withHeaders([
                        'Authorization' => 'Zoho-oauthtoken ' . $token,
                    ])->get('https://recruit.zoho.in/recruit/v2/Job_Openings/' . $jobId);
                    
        $jsonjob = $responsejob->json();
        
        // Safely fetch the job title
        $jobTitle = $jsonjob['data'][0]['Posting_Title'] ?? null;
        
        $Candidate_Source = ["Website"];
        $Candidate_Status = "New";
        // STEP 2: Create Candidate Record
      $candidateData = [
                        "First_Name"            => $request->first_name,
                        "Last_Name"             => $request->last_name,
                        "Email"                 => $request->email,
                        "Mobile"                => $request->phone,
                    
                        // TEXT field
                        "Year_Of_Experience"    => $request->year_of_experience,
                    
                        // PICKLIST FIELDS (must be arrays)
                        "Current_Experience_1"  => [$request->current_experience],
                        "Do_you_have_AHPRA_Registration1"    => $request->aphra_status,
                        "Current_Job_Title"    => $jobTitle,
                        'Candidate_Source'     => $Candidate_Source,
                        'Candidate_Status'     => $Candidate_Status
                    ];

        $response = Http::withHeaders([
            'Authorization' => 'Zoho-oauthtoken ' . $token,
            'Content-Type'  => 'application/json'
        ])->post('https://recruit.zoho.in/recruit/v2/Candidates', [
            "data" => [$candidateData]
        ]);

        if (!$response->successful()) {
            return response()->json([
                            "success" => false,
                            "message" => "Failed to create candidate in Zoho"
                        ], 500);
        }

        $candidateResponse = $response->json();
        
        $candidateId = $candidateResponse['data'][0]['details']['id'] ?? null;

        if (!$candidateId) {
            return response()->json([
                            "success" => false,
                            "message" => "Zoho did not return candidate ID"
                        ], 500);
        }

        // STEP 3: Upload Resume
    if ($request->hasFile('resume')) {
            try {
                $resume = $request->file('resume');

                $uploadResponse = Http::withHeaders([
                        'Authorization' => 'Zoho-oauthtoken ' . $token,
                    ])
                    ->attach(
                        'file',
                        fopen($resume->getRealPath(), 'r'),
                        $resume->getClientOriginalName()
                    )
                    ->post("https://recruit.zoho.in/recruit/v2/Candidates/$candidateId/Attachments?attachments_category=Resume");
                    
                    if (!$uploadResponse->successful()) {
                        return response()->json([
                            "success" => false,
                            "message" => "Resume upload failed"
                        ], 500);
                       
                    }


            } catch (\Exception $e) {
                
                return response()->json([
                        "success" => false,
                        "message" => "Unable to upload resume: " . $e->getMessage()
                    ], 500);
            }
        }


        // STEP 4: Link Candidate to Job Opening
        

$url = "https://recruit.zoho.in/recruit/v2/Candidates/actions/associate";

$payload = [
    "data" => [
        [
            "ids"     => [$candidateId],
            "jobids"  => [$jobId],
            "comments" => "Linked from website"
        ]
    ]
];

$linkResponse = Http::withHeaders([
    'Authorization' => 'Zoho-oauthtoken ' . $token,
    'Content-Type'  => 'application/json',
])->put($url, $payload);



if (!$linkResponse->successful()) {
    return response()->json([
            "success" => false,
            "message" => "Failed to link candidate to job opening"
        ], 500);
}


      
        return redirect()
            ->route('frontend.applynow.thankyou')
            ->with('success', 'Your application has been submitted successfully!');


    } catch (\Exception $e) {

        return response()->json([
            "success" => false,
            "message" => $e->getMessage()
        ], 500);
    }
}


public function applynow_thankyou(Request $request)
{
   
    return view('frontend.applynow_thankyou');
}
public function job_detail(Request $request)
{
    $token = ZohoService::getAccessToken();
    $id = $request->id;
    $response = Http::withHeaders([
        'Authorization' => 'Zoho-oauthtoken ' . $token,
    ])->get('https://recruit.zoho.in/recruit/v2/Job_Openings/' . $id);
    
    
        $jobDetails = $response->json();
        $jobdetail =[];
        if (isset($jobDetails['data'][0])) {
        $jobdetail = $jobDetails['data'][0];
        } 

    
     return view('frontend.job_detail',compact('jobdetail'));
    
}


public function hire_now(Request $request)
{
    $token   = ZohoService::getAccessToken();
    $page    = max((int)$request->page, 1);   // default page = 1
    $perPage = 10;

    /* -----------------------------------------
     | 1) CALL ZOHO API — PAGINATED DATA
     ----------------------------------------- */
    $response = Http::withHeaders([
        'Authorization' => 'Zoho-oauthtoken ' . $token,
    ])->get('https://recruit.zoho.in/recruit/v2/Candidates', [
        'page'     => $page,
        'per_page' => $perPage
    ]);

    $json       = $response->json();
    $candidates = collect($json['data'] ?? []);
    $info       = $json['info'] ?? [];
    
    

    /* -----------------------------------------
     | 2) CALL ZOHO API — FULL LIST (for counts)
     ----------------------------------------- */
    $responseAll = Http::withHeaders([
        'Authorization' => 'Zoho-oauthtoken ' . $token,
    ])->get('https://recruit.zoho.in/recruit/v2/Candidates'); // Zoho returns max 200 by default

    $jsonAll       = $responseAll->json();
    $allCandidates = collect($jsonAll['data'] ?? []);


    /* -----------------------------------------
     | 3) APPLY FILTERS TO FULL LIST
     ----------------------------------------- */

    if ($request->filled('keyword')) {
        $keyword = strtolower($request->keyword);
        $allCandidates = $allCandidates->filter(function ($c) use ($keyword) {
            return str_contains(strtolower($c['Current_Job_Title'] ?? ''), $keyword)
                || str_contains(strtolower($c['Current_Location'] ?? ''), $keyword);
        });
    }

    if ($request->filled('jobtitle')) {
        $allCandidates = $allCandidates->whereIn('Current_Job_Title', $request->jobtitle);
    }
    
    if ($request->filled('ahpra')) {
        $allCandidates = $allCandidates->whereIn('Do_you_have_AHPRA_Registration1', $request->ahpra);
    }

    if ($request->filled('experiences')) {
        $allCandidates = $allCandidates->where('Year_Of_Experience', $request->experiences);
    }
    
     $sortBy = $request->sortby;
    
     if ($sortBy == 1) {
        // Newest first
        $allCandidates = $allCandidates->sortByDesc(function ($cand) {
            return strtotime($cand['Created_Time'] ?? '1970-01-01');
        })->values();
    }
    
    if ($sortBy == 2) {
        // Oldest first
        $allCandidates = $allCandidates->sortBy(function ($cand) {
            return strtotime($cand['Created_Time'] ?? '1970-01-01');
        })->values();
    }
    
    
    $allCandidates = $allCandidates->where('Fetch_Into_Website', true);

    // Count AFTER filtering
    $totalCount = $allCandidates->count();

    // Total pages
    $noofpages = ceil($totalCount / $perPage);


     $candidates = $allCandidates
        ->slice(($page - 1) * $perPage, $perPage)
        ->values();

    /* -----------------------------------------
     | 5) DROPDOWN LISTS
     ----------------------------------------- */
   


                    
     $response = Http::withHeaders([
    'Authorization' => 'Zoho-oauthtoken ' . $token,
])->get('https://recruit.zoho.in/recruit/v2/settings/fields?module=Candidates');

// Decode response
$json = $response->json();

//return $json;
// Extract fields array
$fields = $json['fields'] ?? [];

//return $fields;


$experiences              = $this->getPicklist($fields, 'Year_Of_Experience');
$AHPRA_Registration       = $this->getPicklist($fields, 'Do_you_have_AHPRA_Registration1');
$jobtitles                = $this->getPicklist($fields, 'Current_Job_Title');


                    
$page1 = (int)$page;

    /* -----------------------------------------
     | 6) RETURN VIEW
     ----------------------------------------- */
    return view('frontend.hire_now', compact(
        'candidates',
        'totalCount',
        'noofpages',
        'page',
        'perPage',
        'info',
        'jobtitles',
        'experiences',
        'page1',
        'AHPRA_Registration'
    ));
}


public function hire_now_profile(Request $request)
{
    $candidateId = $request->candidate_id;
    $token = ZohoService::getAccessToken();
    
    $response = Http::withHeaders([
    'Authorization' => 'Zoho-oauthtoken ' . $token,
    ])->get("https://recruit.zoho.in/recruit/v2/Candidates/{$candidateId}");
    
    $data = $response->json();
    $candidates = $data['data'];
    //return $data;
    
    return view('frontend.hire_now_profile',compact('candidates'));
}

public function hire_now_applynow(Request $request)
{
    $candidate_id = $request->candidate_id;
    $token = ZohoService::getAccessToken();
    
    $response = Http::withHeaders([
                'Authorization' => 'Zoho-oauthtoken ' . $token,
            ])->get('https://recruit.zoho.in/recruit/v2/settings/fields?module=Job_Openings');

    // Decode response
    $json = $response->json();
    
    //return $json;
    // Extract fields array
    $fields = $json['fields'] ?? [];
    
    //return $fields;
    
    $categories     = $this->getPicklist($fields, 'Designation');
    $jobtypes       = $this->getPicklist($fields, 'Job_Type');

    return view('frontend.hire_now_applynow',compact('candidate_id','jobtypes','categories'));
}

public function hire_now_applynow_submit(Request $request)
{
    try {

        // -----------------------
        // 1. VALIDATION
        // -----------------------
        $request->validate([
            'company_name'       => 'required|string|max:255',
            'contact_person'     => 'required|string|max:255',
            'email'              => 'required|email|max:255',
            'phone'              => 'nullable|regex:/^[0-9]{7,15}$/',
            'company_location'   => 'required|string|max:255',
            'job_title'          => 'required|string|max:255',
            'job_category'       => 'required',
            'job_type'           => 'required',
            'salary_range'       => 'nullable|string|max:255',
            'work_location'      => 'required|string|max:255',
            'job_description'    => 'required|string',
            'special_requirements' => 'nullable|string',
            'company_profile_pdf' => 'nullable|mimes:pdf,doc,docx,jpg,jpeg,png|max:2048',
        ]);


        // -----------------------
        // 2. FILE UPLOAD
        // -----------------------
        $fileName = null;
        $filePath = null;

        if ($request->hasFile('company_profile_pdf')) {
            $file = $request->file('company_profile_pdf');

            $fileName = time() . '_' . $file->getClientOriginalName();

            // Save inside /storage/app/public/assets/company_profile_pdf/
            $filePath = $file->storeAs('assets/company_profile_pdf', $fileName, 'public');
        }

        $candidate_id =$request->candidate_id;
        $token = ZohoService::getAccessToken();
        $response = Http::withHeaders([
            'Authorization' => 'Zoho-oauthtoken ' . $token,
            ])->get("https://recruit.zoho.in/recruit/v2/Candidates/{$candidate_id}");
            
            $data = $response->json();
            $candidates = $data['data'];
            foreach($candidates as $data1)
            {
               $candidate_first_name = $data1['First_Name'];
            }

        // -----------------------
        // 3. SAVE THE DATA
        // -----------------------
        $job = JobOpenings::create([
            'candidate_id'        => $candidate_id,
            'candidate_first_name'=> $candidate_first_name,
            'company_name'        => $request->company_name,
            'contact_person'      => $request->contact_person,
            'email'               => $request->email,
            'phone'               => $request->phone,
            'company_location'    => $request->company_location,
            'job_title'           => $request->job_title,
            'job_category'        => $request->job_category,
            'job_type'            => $request->job_type,
            'salary_range'        => $request->salary_range,
            'work_location'       => $request->work_location,
            'job_description'     => $request->job_description,
            'special_requirements'=> $request->special_requirements,
            'company_profile_pdf' => $fileName,
        ]);


        // ===========================================
        // 4. SEND EMAIL USING PHPMailer
        // ===========================================
     /*  $mail = new PHPMailer(true);

        $mail->isSMTP();
        $mail->Host       = env('MAIL_HOST');
        $mail->SMTPAuth   = true;
        $mail->Username   = env('MAIL_USERNAME');
        $mail->Password   = env('MAIL_PASSWORD');
        $mail->SMTPSecure = env('MAIL_ENCRYPTION', 'tls');
        $mail->Port       = env('MAIL_PORT');
        
        $mail->setFrom(env('MAIL_FROM_ADDRESS'), env('MAIL_FROM_NAME'));
        $mail->addAddress(env('MAIL_TO_ADDRESS'));  // receiver email


        // Attach file if uploaded
        if ($filePath) {
            $mail->addAttachment(storage_path("app/public/" . $filePath));
        }

        // Email content
        $mail->isHTML(true);
        $mail->Subject = "New Job Opening Request – " . $request->company_name;

        $mail->Body = "
            <h2>New Job Request Submitted</h2>
            <p><strong>Company Name:</strong> {$request->company_name}</p>
            <p><strong>Contact Person:</strong> {$request->contact_person}</p>
            <p><strong>Email:</strong> {$request->email}</p>
            <p><strong>Phone:</strong> {$request->phone}</p>
            <p><strong>Company Location:</strong> {$request->company_location}</p>
            <hr>
            <p><strong>Job Title:</strong> {$request->job_title}</p>
            <p><strong>Job Category:</strong> {$request->job_category}</p>
            <p><strong>Job Type:</strong> {$request->job_type}</p>
            <p><strong>Salary Range:</strong> {$request->salary_range}</p>
            <p><strong>Work Location:</strong> {$request->work_location}</p>
            <p><strong>Job Description:</strong> {$request->job_description}</p>
            <p><strong>Special Requirements:</strong> {$request->special_requirements}</p>
        ";

        $mail->send(); */


        // -----------------------
        // 5. REDIRECT SUCCESS
        // -----------------------
        return redirect()
            ->route('frontend.hire_now_applynow.thankyou')
            ->with('success', 'Your application has been submitted successfully!');

    } catch (\Exception $e) {
        return redirect()
            ->route('frontend.hire_now_applynow.thankyou')
            ->with('error', 'Something went wrong. Please try again later.');
    }
}


public function hire_now_applynow_thankyou(Request $request)
{
   
    return view('frontend.hire_now_applynow_thankyou');
}

}