<?php

namespace App\Http\Middleware\backend;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use Illuminate\Support\Facades\Auth;

class AuthCheck
{
    public function handle(Request $request, Closure $next): Response
    {
        // Check if the user is authenticated
        if (!auth()->check()) {
            // Redirect or return an unauthorized response
            return redirect()->route('admin.login');
        }
        return $next($request);
    }
}
