<?php
namespace App\Http\Traits;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Crypt;
trait CommonPluginTraits {
    private $secrete_key;
    private $nonce;
    private $block_size;

    public function __construct()
    {
        $this->secrete_key = 'd3c37750af0bfcddfa1735578532251e01b8e33c95915b82e668e18493f92cb8';
        $this->nonce ='7060dcda59bef89aad06ca42714c6f80b7a7355b960d4b1f';
        $this->block_size = '64';
        // Other constructor logic
    }

    public function encryptData($dataToEncrypt)
    {
        try {
            if ($dataToEncrypt  != '') {
                $nonce_decoded = sodium_hex2bin($this->$nonce);
                $key_decoded = sodium_hex2bin($this->$secret_key);
                // encrypt message and combine with nonce
                $cipher = sodium_bin2hex(sodium_crypto_secretbox($dataToEncrypt, $nonce_decoded, $key_decoded));
                // cleanup
                sodium_memzero($dataToEncrypt);
                sodium_memzero($key_decoded);
                sodium_memzero($nonce_decoded);
                $encrypted=utf8_encode(rtrim($cipher));
                return sodium_bin2hex($cipher);
            }
            else
            return ''; 
        }
        catch (Exception $e) {
            return $e->getMessage();
        }
    }

    public function decryptData($encryptedData)
    {
        try {
            if (!empty($encryptedData)) {
				if(ctype_xdigit($encryptedData)){
					$decoded = sodium_hex2bin($encryptedData);
					if ($decoded === false) {
						return '';
					}
					$nonce_decoded = sodium_hex2bin($this->nonce);
					$key_decoded = sodium_hex2bin($this->secret_key);
					// decrypt it
					$message = sodium_crypto_secretbox_open($decoded, $nonce_decoded, $key_decoded);
					if ($message === false) {
						return '';
					}
					// cleanup
					sodium_memzero($decoded);
					sodium_memzero($key_decoded);
					sodium_memzero($nonce_decoded);
					return(utf8_decode(utf8_encode(rtrim($message))));
				} 
			} 
        }
        catch (Exception $e) {
            return $e->getMessage();
        }
    }


    function sanitizestring($string)
    {
        $cleanedString = Str::of($string)->stripTags();
        $cleanedString = preg_replace('/\b(?:https?|ftp):\/\/\S+\b/', '', $cleanedString);
        return $cleanedString;
    }
}