<?php
namespace App\Services;

use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Cache;
class ZohoService
{
public static function getAccessToken()
{
    try {

        // Try existing cached token
        if (Cache::has('zoho_access_token')) {
            return Cache::get('zoho_access_token');
        }

        $refreshToken = env('ZOHO_REFRESH_TOKEN');
        $clientId     = env('ZOHO_CLIENT_ID');
        $clientSecret = env('ZOHO_CLIENT_SECRET');

        // If any is missing → print error
        if (!$refreshToken || !$clientId || !$clientSecret) {
            return "ENV ERROR: Missing one of ZOHO_REFRESH_TOKEN / ZOHO_CLIENT_ID / ZOHO_CLIENT_SECRET";
        }

        // Request Zoho for new token
        $response = Http::asForm()->post('https://accounts.zoho.in/oauth/v2/token', [
            'refresh_token' => $refreshToken,
            'client_id'     => $clientId,
            'client_secret' => $clientSecret,
            'grant_type'    => 'refresh_token',
        ]);

        // If Zoho returns error → print it
        if ($response->failed()) {
            return "ZOHO TOKEN ERROR: " . $response->body();
        }

        $data = $response->json();

        if (!isset($data['access_token'])) {
            return "INVALID RESPONSE FROM ZOHO: " . json_encode($data);
        }

        $token = $data['access_token'];

        Cache::put('zoho_access_token', $token, now()->addMinutes(55));

        return $token;

    } catch (\Exception $e) {
        return "EXCEPTION: " . $e->getMessage();
    }
}


}
