@extends('backend.layouts.master')
@section('content')           
<div class="container-fluid">
   <div class="row">
      <div class="col-sm-12">
         @include('backend.about.menu')
      </div>
      <div class="col-sm-12 col-lg-12">
         <div class="iq-card">
            <div class="iq-card-header d-flex justify-content-between">
               <div class="iq-header-title">
                  <h4 class="card-title"> About Us</h4>
               </div>
            </div>
            <div class="iq-card-body">
               @if (count($errors) > 0)
               <div class="alert alert-danger">
                  <ul>
                     @foreach ($errors->all() as $error)
                     <li>{{ $error }}</li>
                     @endforeach
                  </ul>
               </div>
               @endif
               <form action="{{ route('admin.about.insert') }}" method="post" enctype="multipart/form-data" id="frm_about">
                  @csrf
                  <div class="container-fluid">
                    
                     <div class="form-group col-sm-12">
                        <label for="who_we_are">Who We Are</label>
                        <textarea type="text" class="form-control ckeditor" id="who_we_are" name="who_we_are">{{ old('who_we_are') }}</textarea>
                        <span class="error" id="error_who_we_are"></span>
                     </div>
                     <div class="form-group col-sm-12">
                        <label for="our_history">Our History</label>
                        <textarea type="text" class="form-control ckeditor" id="our_history" name="our_history">{{ old('our_history') }}</textarea>
                        <span class="error" id="error_our_history"></span>
                     </div>
                     
                     <div class="row">
                      <div class="form-group col-sm-6">
                        <label for="our_history_icon">Our History Icon:</label>
                        <input type="file" class="form-control" id="our_history_icon" name="our_history_icon" />
                        <span class="error" id="error_our_history_icon"></span>
                     </div>

                     <div class="form-group col-sm-6">
                        <label for="our_history_icon_text">Our History Icon Text:</label>
                        <input type="text" class="form-control" id="our_history_icon_text" name="our_history_icon_text" />
                        <span class="error" id="error_our_history_icon_text"></span>
                     </div>
                     </div>
                     <div class="form-group col-sm-12">
                        <label for="vision">Vision</label>
                        <textarea type="text" class="form-control ckeditor" id="vision" name="vision">{{ old('vision') }}</textarea>
                        <span class="error" id="error_vision"></span>
                     </div>

                     <div class="form-group col-sm-12">
                        <label for="mission">Mission</label>
                        <textarea type="text" class="form-control ckeditor" id="mission" name="mission">{{ old('mission') }}</textarea>
                        <span class="error" id="error_mission"></span>
                     </div>

                     <div class="row">
                        <div class="form-group col-sm-6">
                           <label for="photo">Photo 1(1600 X 836 pixels):</label>
                           <input type="file" class="form-control" id="photo" name="photo" />
                           <span class="error" id="error_photo"></span>
                        </div>

                        <div class="form-group col-sm-6">
                           <label for="photo_text">Photo Text</label>
                           <input type="text" class="form-control" id="photo_text" name="photo_text" value="{{ old('photo_text') }}" />
                           <span class="error" id="error_photo_text"></span>
                        </div>
                        
                     </div>

                     <div class="form-group col-sm-12">
                        <label for="global_presence">Global Presence</label>
                        <textarea type="text" class="form-control ckeditor" id="global_presence" name="global_presence">{{ old('global_presence') }}</textarea>
                        <span class="error" id="error_global_presence"></span>
                     </div>
                     <div class="row">
                     <div class="form-group col-sm-6">
                        <label for="global_presence_icon">Global Presence Icon:</label>
                        <input type="file" class="form-control" id="global_presence_icon" name="global_presence_icon" />
                        <span class="error" id="error_global_presence_icon"></span>
                     </div>

                     <div class="form-group col-sm-6">
                        <label for="global_presence_icon_text">Global Presence Icon Text:</label>
                        <input type="text" class="form-control" id="global_presence_icon_text" name="global_presence_icon_text" />
                        <span class="error" id="error_global_presence_icon_text"></span>
                     </div>
                     </div>

                     <div class="form-group col-sm-12">
                        <label for="what_we_do">What We Do</label>
                        <textarea type="text" class="form-control ckeditor" id="what_we_do" name="what_we_do">{{ old('what_we_do') }}</textarea>
                        <span class="error" id="error_what_we_do"></span>
                     </div>

                      <div class="form-group col-sm-12">
                        <label for="advantages">The YESTE Advantage</label>
                        <textarea type="text" class="form-control ckeditor" id="advantages" name="advantages">{{ old('advantages') }}</textarea>
                        <span class="error" id="error_advantages"></span>
                     </div>
                     <div class="form-group col-sm-6">
                        <button type="submit" class="btn btn-primary">Submit</button>
                     </div>
                  </div>
               </form>
            </div>
         </div>
      </div>
   </div>
</div>
<script type="text/javascript" language="javascript" class="init">
   //view loanandadvance ajax
   $.ajaxSetup({
               headers: {
                  'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
               }
         });
   
   
   $(document).ready(function() {
      $("#frm_about").submit(function(event) {
            event.preventDefault();
            var formData = new FormData($("#frm_about")[0]);
   
            var files = $('#photo')[0].files;
            formData.append('photo', files[0]);
   
            var files = $('#global_presence_icon')[0].files;
            formData.append('global_presence_icon', files[0]);
            var isValid = true;

            var files = $('#our_history_icon')[0].files;
            formData.append('our_history_icon', files[0]);
            var isValid = true;

            var who_we_areData = CKEDITOR.instances.who_we_are.getData();
            formData.append('who_we_are', who_we_areData);

            var our_historyData = CKEDITOR.instances.our_history.getData();
            formData.append('our_history', our_historyData);

            var missionData = CKEDITOR.instances.mission.getData();
            formData.append('mission', missionData);

            var visionData = CKEDITOR.instances.vision.getData();
            formData.append('vision', visionData);

            var global_presenceData = CKEDITOR.instances.global_presence.getData();
            formData.append('global_presence', global_presenceData);

            var what_we_doData = CKEDITOR.instances.what_we_do.getData();
            formData.append('what_we_do', what_we_doData);


            var advantagesData = CKEDITOR.instances.advantages.getData();
            formData.append('advantages', advantagesData);

            var what_we_doData = CKEDITOR.instances.what_we_do.getData();
            formData.append('what_we_do', what_we_doData);
   
   
            if ($("#who_we_are").val() == "") {
                  $("#error_who_we_are").html("Who We Are   is required.");
                  isValid = false;
            } 
            else
            $("#error_who_we_are").html("");   
   
            if ($("#our_history").val() == "") {
                  $("#error_our_history").html("Our History   is required.");
                  isValid = false;
            } 
            else
            $("#error_our_history").html("");     
            
            if ($("#photo").val() == "") {
                  $("#error_photo").html("Photo is required.");
                  isValid = false;
            } 
            else
            $("#error_photo").html("");
   
            

            

            
            if (isValid)
               {  
               Swal.fire({
               title: 'Do you want to save the record?',
               text: '',
               icon: 'warning',
               showCancelButton: true,
               confirmButtonColor: '#3085d6',
               cancelButtonColor: '#d33',
               confirmButtonText: 'Yes, Continue'
               }).then((result) => {
               if (result.isConfirmed) {            
                  var url=$('#frm_about').attr('action');
                  $.ajaxSetup({
                     headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                     }
                  });
               
                  $.ajax({
                     type: 'POST',
                     contentType: 'multipart/form-data',
                     cache: false,
                     contentType: false,
                     processData: false,
                     data: formData,
                     url: url,
                     success: function(response) {
                        if (response.success) {                                                 
                           Swal.fire({
                              icon: 'success',
                              title: ' About Us',
                              text: ' About Us added successfully!',
                           }).then(function() {
                                 window.location = "{{ route('admin.about.view') }}";
                              });                          
                           
                        }
                        else {
                              Swal.fire({
                                 icon: 'error',
                                 title: ' About Us',
                                 text: 'Error Occured. Retry again.',
                              });
                        }
                     },
                     error: function(error) {
                        Swal.fire({
                              icon: 'error',
                              title: ' About Us',
                              text: 'Error submitting the form!',
                        });
                     }                                       
                  });  
               }
                  
      });
      }
   });
   }); 
</script>
@endsection