@extends('backend.layouts.master')
@section('content')           
<div class="container-fluid">
   <div class="row">
      <div class="col-sm-12">
         @include('backend.excellence.menu')
      </div>
      <div class="col-sm-12 col-lg-12">
         <div class="iq-card">
            <div class="iq-card-header d-flex justify-content-between">
               <div class="iq-header-title">
                  <h4 class="card-title">Edit Excellence</h4>
               </div>
            </div>
            <div class="iq-card-body">
               @if (count($errors) > 0)
               <div class="alert alert-danger">
                  <ul>
                     @foreach ($errors->all() as $error)
                     <li>{{ $error }}</li>
                     @endforeach
                  </ul>
               </div>
               @endif
               @if(isset($excellence)) 
               
               <form action="{{ route('admin.excellence.update') }}" method="post" enctype="multipart/form-data" id="frm_excellence">
                  @csrf
                  <input type="hidden" class="form-control" id="id" name="id" value="{{ $excellence->id }}" />
                  <div class="container-fluid">
                     <div class="row">
                        <div class="form-group col-sm-6">
                           <label for="caption">Caption</label>
                           <input type="text" class="form-control" id="caption" name="caption" value="{{ $excellence->caption }}" />
                           <span class="error" id="error_caption"></span>
                        </div>
                          <div class="form-group col-sm-6">
                           <label for="value">Value</label>
                           <input type="text" class="form-control" id="value" name="value" value="{{ $excellence->value }}" />
                           <span class="error" id="error_value"></span>
                        </div>
                        </div>
                        <div class="row">
                           <div class="form-group col-sm-4">
                              <label for="photo">Photo (750 X 600 pixels):</label>
                              <input type="file"  id="photo" name="photo"  width="300" />
                              <input type="hidden"  id="oldphoto" name="oldphoto"  value="{{ $excellence->photo  }}" />
                              <span class="error" id="error_photo"></span>
                           </div>
                           <div class="form-group col-sm-4">
                              @if($excellence->photo!="")
                              <img src="{{asset('storage/assets/excellence/photo/')}}/{{ $excellence->photo }}" width="100" />
                              @endif
                           </div>
                           
                        <div class="form-group col-sm-4">
                           <label for="photo_text">Photo Text</label>
                           <input type="text" class="form-control" id="photo_text" name="photo_text" value="{{ $excellence->photo_text }}" />
                           <span class="error" id="error_photo_text"></span>
                        </div>
                        </div>
                        <div class="row">
                            <div class="form-group col-sm-4">
                              <label for="photo2">Photo 2 (750 X 600 pixels):</label>
                              <input type="file"  id="photo2" name="photo2"  width="300" />
                              <input type="hidden"  id="oldphoto" name="oldphoto"  value="{{ $excellence->photo2  }}" />
                              <span class="error" id="error_photo"></span>
                           </div>
                           <div class="form-group col-sm-4">
                              @if($excellence->photo2!="")
                              <img src="{{asset('storage/assets/excellence/photo2/')}}/{{ $excellence->photo2 }}" width="100" />
                              @endif
                           </div>
                        <div class="form-group col-sm-4">
                           <label for="photo_text2">Photo 2 Text</label>
                           <input type="text" class="form-control" id="photo_text2" name="photo_text2" value="{{ $excellence->photo_text2 }}" />
                           <span class="error" id="error_photo_text"></span>
                        </div>
                     </div> 

                  </div>
                  <div class="form-group col-sm-6">
                     <button type="submit" class="btn btn-primary">Update</button>
                  </div>
               </form>
                                     
               @endif  
            </div>
         </div>
      </div>
   </div>
</div>
<script type="text/javascript" language="javascript" class="init">
   $.ajaxSetup({
      headers: {
         'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
      }
   });
   
   $(document).ready(function() {
       $("#frm_excellence").submit(function(event) {
           event.preventDefault();
           
           var formData = new FormData($("#frm_excellence")[0]);
   
           var photoFile = $('#photo')[0].files[0];
           if (photoFile) {
               formData.append('photo', photoFile);
           }

            var files = $('#photo2')[0].files;
            formData.append('photo2', files[0]);

           var isValid = true;
   
            if ($("#caption").val() == "") {
                  $("#error_caption").html("Caption is required.");
                  isValid = false;
            } 
            else
            $("#error_caption").html("");

            if ($("#value").val() == "") {
                  $("#error_value").html("Value is required.");
                  isValid = false;
            } 
            else
            $("#error_value").html("");
           
           if (isValid) {  
               Swal.fire({
                   title: 'Do you want to update the record?',
                   text: '',
                   icon: 'warning',
                   showCancelButton: true,
                   confirmButtonColor: '#3085d6',
                   cancelButtonColor: '#d33',
                   confirmButtonText: 'Yes, Continue'
               }).then((result) => {
                   if (result.isConfirmed) {
                       var url = $('#frm_excellence').attr('action');
                       $.ajax({
                           type: 'POST',
                           processData: false,
                           contentType: false,
                           cache: false,
                           data: formData,
                           url: url,
                           success: function(response) {
                               if (response.success) {
                                   Swal.fire({
                                       icon: 'success',
                                       title: 'Excellence',
                                       text: 'Excellence updated successfully!',
                                   }).then(function() {
                                       window.location = "{{ route('admin.excellence.view') }}";
                                   });                          
                               } else {
                                   Swal.fire({
                                       icon: 'error',
                                       title: 'Excellence',
                                       text: 'Error Occurred. Retry again.',
                                   });
                               }
                           },
                           error: function(error) {
                               Swal.fire({
                                   icon: 'error',
                                   title: 'Excellence',
                                   text: 'Error submitting the form!',
                               });
                           }
                       });  
                   }
               });
           }
       });
   });
   
</script>
@endsection