@extends('backend.layouts.master')
@section('content')           
<div class="container-fluid">
   <div class="row">
      <div class="col-sm-12">
         @include('backend.expertise.menu')
      </div>
      <div class="col-sm-12 col-lg-12">
         <div class="iq-card">
            <div class="iq-card-header d-flex justify-content-between">
               <div class="iq-header-title">
                  <h4 class="card-title">Expertise</h4>
               </div>
            </div>
            <div class="iq-card-body">
               @if (count($errors) > 0)
               <div class="alert alert-danger">
                  <ul>
                     @foreach ($errors->all() as $error)
                     <li>{{ $error }}</li>
                     @endforeach
                  </ul>
               </div>
               @endif
               <form action="{{ route('admin.expertise.insert') }}" method="post" enctype="multipart/form-data" id="frm_client">
                  @csrf
                  <div class="container-fluid">
                     <div class="row">
                        <div class="form-group col-sm-12">
                           <label for="name">Name</label>
                           <input type="text" class="form-control" id="name" name="name" value="{{ old('name') }}" />
                           <span class="error" id="error_name"></span>
                        </div>

                        <div class="form-group col-sm-6">
                           <label for="photo">Photo (1600 X 836 pixels):</label>
                           <input type="file" class="form-control" id="photo" name="photo" />
                           <span class="error" id="error_photo"></span>
                        </div>

                        <div class="form-group col-sm-6">
                           <label for="photo_text">Photo Text</label>
                           <input type="text" class="form-control" id="photo_text" name="photo_text" value="{{ old('photo_text') }}" />
                           <span class="error" id="error_photo_text"></span>
                        </div>

                         <div class="form-group col-sm-6">
                           <label for="photo2">Photo 2 (1600 X 836 pixels):</label>
                           <input type="file" class="form-control" id="photo2" name="photo2" />
                           <span class="error" id="error_photo2"></span>
                        </div>

                        <div class="form-group col-sm-6">
                           <label for="photo_text2">Photo 2 Text</label>
                           <input type="text" class="form-control" id="photo_text2" name="photo_text2" value="{{ old('photo_text2') }}" />
                           <span class="error" id="error_photo_text2"></span>
                        </div>

                     </div>
                     
                     <div class="form-group col-sm-6">
                        <button type="submit" class="btn btn-primary">Submit</button>
                     </div>
                  </div>
               </form>
            </div>
         </div>
      </div>
   </div>
</div>
<script type="text/javascript" language="javascript" class="init">
   //view loanandadvance ajax
   $.ajaxSetup({
               headers: {
                  'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
               }
         });
   
   
   $(document).ready(function() {
      $("#frm_client").submit(function(event) {
            event.preventDefault();
            var formData = new FormData($("#frm_client")[0]);
   
            var files = $('#photo')[0].files;
            formData.append('photo', files[0]);

               
            var files = $('#photo2')[0].files;
            formData.append('photo2', files[0]);
            var isValid = true;

   
            if ($("#name").val() == "") {
                  $("#error_name").html("Name is required.");
                  isValid = false;
            } 
            else
            $("#error_name").html("");

             if ($("#photo").val() == "") {
                  $("#error_photo").html("Photo is required.");
                  isValid = false;
            } 
            else
            $("#error_photo").html("");
           

            
             if ($("#photo2").val() == "") {
                  $("#error_photo2").html("Photo2 is required.");
                  isValid = false;
            } 
            else
            $("#error_photo2").html("");
            
            if (isValid)
               {  
               Swal.fire({
               title: 'Do you want to save the record?',
               text: '',
               icon: 'warning',
               showCancelButton: true,
               confirmButtonColor: '#3085d6',
               cancelButtonColor: '#d33',
               confirmButtonText: 'Yes, Continue'
               }).then((result) => {
               if (result.isConfirmed) {            
                  var url=$('#frm_client').attr('action');
                  $.ajaxSetup({
                     headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                     }
                  });
               
                  $.ajax({
                     type: 'POST',
                     contentType: 'multipart/form-data',
                     cache: false,
                     contentType: false,
                     processData: false,
                     data: formData,
                     url: url,
                     success: function(response) {
                        if (response.success) {                                                 
                           Swal.fire({
                              icon: 'success',
                              title: 'Expertise',
                              text: 'Expertise added successfully!',
                           }).then(function() {
                                 window.location = "{{ route('admin.expertise.view') }}";
                              });                          
                           
                        }
                        else {
                              Swal.fire({
                                 icon: 'error',
                                 title: 'Expertise',
                                 text: 'Error Occured. Retry again.',
                              });
                        }
                     },
                     error: function(error) {
                        Swal.fire({
                              icon: 'error',
                              title: 'Expertise',
                              text: 'Error submitting the form!',
                        });
                     }                                       
                  });  
               }
                  
      });
      }
   });
   }); 
</script>
@endsection