@extends('backend.layouts.master')
@section('content')           
<div class="container-fluid">
   <div class="row">
      <div class="col-sm-12">
         @include('backend.expertise.menu')
      </div>
      <div class="col-sm-12 col-lg-12">
         <div class="iq-card">
            <div class="iq-card-header d-flex justify-content-between">
               <div class="iq-header-title">
                  <h4 class="card-title">Edit Expertise</h4>
               </div>
            </div>
            <div class="iq-card-body">
               @if (count($errors) > 0)
               <div class="alert alert-danger">
                  <ul>
                     @foreach ($errors->all() as $error)
                     <li>{{ $error }}</li>
                     @endforeach
                  </ul>
               </div>
               @endif
               @if(isset($expertise)) 
               
               <form action="{{ route('admin.expertise.update') }}" method="post" enctype="multipart/form-data" id="frm_client">
                  @csrf
                  <input type="hidden" class="form-control" id="id" name="id" value="{{ $expertise->id }}" />
                  <div class="container-fluid">
                     <div class="row">
                        <div class="form-group col-sm-12">
                           <label for="name">Name</label>
                           <input type="text" class="form-control" id="name" name="name" value="{{ $expertise->name }}" />
                           <span class="error" id="error_name"></span>
                        </div>
                        </div>
                        <div class="row">
                           <div class="form-group col-sm-4">
                              <label for="photo">Photo (750 X 600 pixels):</label>
                              <input type="file"  id="photo" name="photo"  width="300" />
                              <input type="hidden"  id="oldphoto" name="oldphoto"  value="{{ $expertise->photo  }}" />
                              <span class="error" id="error_photo"></span>
                           </div>
                           <div class="form-group col-sm-4">
                              @if($expertise->photo!="")
                              <img src="{{asset('storage/assets/expertise/photo/')}}/{{ $expertise->photo }}" width="100" />
                              @endif
                           </div>
                        <div class="form-group col-sm-4">
                           <label for="photo_text">Photo Text</label>
                           <input type="text" class="form-control" id="photo_text" name="photo_text" value="{{ $expertise->photo_text }}" />
                           <span class="error" id="error_photo_text"></span>
                        </div>
                        </div>
                        <div class="row">
                           <div class="form-group col-sm-4">
                                 <label for="photo2">Photo 2 (750 X 600 pixels):</label>
                                 <input type="file"  id="photo2" name="photo2"  width="300" />
                                 <input type="hidden"  id="oldphoto" name="oldphoto"  value="{{ $expertise->photo2  }}" />
                                 <span class="error" id="error_photo"></span>
                              </div>
                              <div class="form-group col-sm-4">
                                 @if($expertise->photo2!="")
                                 <img src="{{asset('storage/assets/expertise/photo2/')}}/{{ $expertise->photo2 }}" width="100" />
                                 @endif
                              </div>
                           <div class="form-group col-sm-4">
                              <label for="photo_text2">Photo 2 Text</label>
                              <input type="text" class="form-control" id="photo_text2" name="photo_text2" value="{{ $expertise->photo_text2 }}" />
                              <span class="error" id="error_photo_text"></span>
                           </div>
                     </div> 
                  </div>
                  <div class="form-group col-sm-6">
                     <button type="submit" class="btn btn-primary">Update</button>
                  </div>
               </form>
                                     
               @endif  
            </div>
         </div>
      </div>
   </div>
</div>
<script type="text/javascript" language="javascript" class="init">
   $.ajaxSetup({
      headers: {
         'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
      }
   });
   
   $(document).ready(function() {
       $("#frm_client").submit(function(event) {
           event.preventDefault();
           
           var formData = new FormData($("#frm_client")[0]);
   
           var photoFile = $('#photo')[0].files[0];
           if (photoFile) {
               formData.append('photo', photoFile);
           }

                          
            var files = $('#photo2')[0].files;
            formData.append('photo2', files[0]);

           var isValid = true;
   
           if ($("#name").val() == "") {
               $("#error_name").html("Name is required.");
               isValid = false;
           } else {
               $("#error_name").html("");
           }

           
           if (isValid) {  
               Swal.fire({
                   title: 'Do you want to update the record?',
                   text: '',
                   icon: 'warning',
                   showCancelButton: true,
                   confirmButtonColor: '#3085d6',
                   cancelButtonColor: '#d33',
                   confirmButtonText: 'Yes, Continue'
               }).then((result) => {
                   if (result.isConfirmed) {
                       var url = $('#frm_client').attr('action');
                       $.ajax({
                           type: 'POST',
                           processData: false,
                           contentType: false,
                           cache: false,
                           data: formData,
                           url: url,
                           success: function(response) {
                               if (response.success) {
                                   Swal.fire({
                                       icon: 'success',
                                       title: 'Expertise',
                                       text: 'Expertise updated successfully!',
                                   }).then(function() {
                                       window.location = "{{ route('admin.expertise.view') }}";
                                   });                          
                               } else {
                                   Swal.fire({
                                       icon: 'error',
                                       title: 'Expertise',
                                       text: 'Error Occurred. Retry again.',
                                   });
                               }
                           },
                           error: function(error) {
                               Swal.fire({
                                   icon: 'error',
                                   title: 'Expertise',
                                   text: 'Error submitting the form!',
                               });
                           }
                       });  
                   }
               });
           }
       });
   });
   
</script>
@endsection