@extends('backend.layouts.master')
@section('content')           
<div class="container-fluid">
   <div class="row">
      <div class="col-sm-12">
         @include('backend.faq.menu')
      </div>
      <div class="col-sm-12 col-lg-12">
         <div class="iq-card">
            <div class="iq-card-header d-flex justify-content-between">
               <div class="iq-header-title">
                  <h4 class="card-title">Edit FAQ</h4>
               </div>
            </div>
            <div class="iq-card-body">
               @if (count($errors) > 0)
               <div class="alert alert-danger">
                  <ul>
                     @foreach ($errors->all() as $error)
                     <li>{{ $error }}</li>
                     @endforeach
                  </ul>
               </div>
               @endif

               @if(isset($faq)) 
               @foreach($faq as $faq1)
               <form action="{{ route('admin.faq.update') }}" method="post" enctype="multipart/form-data" id="frm_faq">
                  @csrf
                  <input type="hidden" class="form-control" id="id" name="id" value="{{ $faq1->id }}" />
                  <div class="container-fluid">
                     <div class="row">
                        <div class="form-group col-sm-12">
                           <label for="question">Question</label>
                           <input type="text" class="form-control" id="question" name="question" value="{{ $faq1->question }}" />
                           <span class="error" id="error_question"></span>
                        </div> 
                     </div> 
                     <div class="form-group col-sm-12">
                        <label for="answer">Answer</label>
                        <textarea type="text" class="form-control ckeditor" id="answer" name="answer">{{ $faq1->answer }}</textarea>
                        <span class="error" id="error_answer"></span>
                     </div> 

                     <div class="row">
                        <div class="form-group col-sm-12">
                           <label for="priority">priority</label>
                           <input type="text" class="form-control" id="priority" name="priority" value="{{ $faq1->priority }}" />
                           <span class="error" id="error_priority"></span>
                        </div> 
                     </div> 

                     
                    
                  </div>
                  <div class="form-group col-sm-6">
                     <button type="submit" class="btn btn-primary">Update</button>
                  </div>  
               </form>    
               @endforeach                      
               @endif  
            </div>
         </div>
      </div>
   </div>
</div>

<script type="text/javascript" language="javascript" class="init">
$.ajaxSetup({
   headers: {
      'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
   }
});

$(document).ready(function() {
    $("#frm_faq").submit(function(event) {
        event.preventDefault();
        
        var formData = new FormData($("#frm_faq")[0]);

        var answerData = CKEDITOR.instances.answer.getData();
        formData.append('answer', answerData);
        
        var isValid = true;

        if ($("#question").val() == "") {
            $("#error_question").html("Question is required.");
            isValid = false;
        } 
        
        else 
        {
            $("#error_question").html("");
        }

        if ($("#answer").val() == "") {
            $("#error_answer").html("Answer is required.");
            isValid = false;
        } 
        
        else
         {
            $("#error_answer").html("");
         }

         if ($("#priority").val() == "") {
            $("#error_priority").html("Priority is required.");
            isValid = false;
        } 
        
        else
         {
            $("#error_priority").html("");
         }
       

        
        
        if (isValid) {  
            Swal.fire({
                title: 'Do you want to update the record?',
                text: '',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, Continue'
            }).then((result) => {
                if (result.isConfirmed) {
                    var url = $('#frm_faq').attr('action');
                    $.ajax({
                        type: 'POST',
                        processData: false,
                        contentType: false,
                        cache: false,
                        data: formData,
                        url: url,
                        success: function(response) {
                            if (response.success) {
                                Swal.fire({
                                    icon: 'success',
                                    title: 'FAQ',
                                    text: 'FAQ updated successfully!',
                                }).then(function() {
                                    window.location = "{{ route('admin.faq.view') }}";
                                });                          
                            } else {
                                Swal.fire({
                                    icon: 'error',
                                    title: 'FAQ',
                                    text: 'Error Occurred. Retry again.',
                                });
                            }
                        },
                        error: function(error) {
                            Swal.fire({
                                icon: 'error',
                                title: 'FAQ',
                                text: 'Error submitting the form!',
                            });
                        }
                    });  
                }
            });
        }
    });
});

</script>
@endsection
