@extends('backend.layouts.master')
@section('content')   
<div class="container-fluid">
               <div class="row"> 
               <div class="col-sm-12">
               @include('backend.faq.menu')
               </div>
                  <div class="col-sm-12">
                     <div class="iq-card">
                        <div class="iq-card-header d-flex justify-content-between">
                           <div class="iq-header-title">
                              <h4 class="card-title">FAQ</h4>
                           </div>
                        </div>
                        <div class="iq-card-body">
                           <div id="table" class="table-editable">
                            
                              <table class="table table-bordered table-responsive-md table-striped" id="example">
                                 <thead>
                                    <tr>
                                       <th>Sl No.</th>
                                       <th>Question</th>
                                       <th>Answer</th>
                                       <th>Prioirty</th>
                                       <th width="15%">Action</th>
                                    </tr>
                                 </thead>
                                 <tbody>                                  
                                 </tbody>
                              </table>
                           </div>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
<script type="text/javascript" language="javascript" class="init">	
$(document).ready(function() {
$.ajaxSetup({
      headers: {
         'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
      }
});
var table =$('#example').DataTable( {
      "processing": true,
      "serverSide": true,
      'serverMethod': 'POST',
      "ajax": "{{ route('admin.faq.ajaxview') }}",
      columns: [
            {data: 'DT_RowIndex'},
            {data: 'question'},
            {data: 'answer'},
            {data: 'priority'},
            
            {data: 'action'}
      ]
   } );

$(document).on("click", ".deletebtn", function(e) {
   e.preventDefault(); 
   var id = $(this).attr('data-id');

   var url = '{{ route("admin.faq.delete", ":id") }}';
   url = url.replace(':id', id);
   Swal.fire({
      title: 'Do you want to delete the record?',
      text: '',
      icon: 'warning',
      showCancelButton: true,
      confirmButtonColor: '#3085d6',
      cancelButtonColor: '#d33',
      confirmButtonText: 'Yes, Continue'
      }).then((result) => {
      if (result.isConfirmed) {  
         $.ajaxSetup({
            headers: {
               'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
      });
      
      $.ajax({
            type: "GET",
            url: url, 
            success: function(response) {
            refreshDataTable();
               if (response.success) {                                                    
                  Swal.fire({
                  icon: 'success',
                  title: 'FAQ',
                  text: 'FAQ deleted successfully!',
                  });                           
                  
               }
               else {
                  Swal.fire({
                        icon: 'error',
                        title: 'FAQ',
                        text: 'Error Occured. Retry again.',
                  });
               }
            },
            error: function(error) {
               Swal.fire({
                  icon: 'error',
                  title: 'FAQ',
                  text: 'Error submitting the form!',
               });
            }                                       
      }); 

      }
   });              
}); 

function refreshDataTable() {
// Reinitialize DataTable
table.ajax.reload();  
}
   
});
</script>
@endsection