@extends('backend.layouts.master')
@section('content')           
<div class="container-fluid">
   <div class="row">
      <div class="col-sm-12">
         @include('backend.home.banner.menu')
      </div>
      <div class="col-sm-12 col-lg-12">
         <div class="iq-card">
            <div class="iq-card-header d-flex justify-content-between">
               <div class="iq-header-title">
                  <h4 class="card-title">Home Banner</h4>
               </div>
            </div>
            <div class="iq-card-body">
               @if (count($errors) > 0)
               <div class="alert alert-danger">
                  <ul>
                     @foreach ($errors->all() as $error)
                     <li>{{ $error }}</li>
                     @endforeach
                  </ul>
               </div>
               @endif
               <form action="{{ route('admin.home.banner.insert') }}" method="post" enctype="multipart/form-data" id="frm_banner">
                  @csrf
                  <div class="container-fluid">
                     <div class="row">
                        <div class="form-group col-sm-6">
                           <label for="caption">Caption 1</label>
                           <input type="text" class="form-control" id="caption1" name="caption1" value="{{ old('caption1') }}" />
                           <span class="error" id="error_caption"></span>
                        </div>
                        <div class="form-group col-sm-6">
                           <label for="caption">Caption 2</label>
                           <input type="text" class="form-control" id="caption2" name="caption2" value="{{ old('caption2') }}" />
                           <span class="error" id="error_caption"></span>
                        </div>
                         <div class="form-group col-sm-6">
                           <label for="small_caption1">Small Caption 1</label>
                           <input type="text" class="form-control" id="small_caption1" name="small_caption1" value="{{ old('small_caption1') }}" />
                           <span class="error" id="error_small_caption1"></span>
                           </div>

                           <div class="form-group col-sm-6">
                           <label for="small_caption2">Small Caption 2</label>
                           <input type="text" class="form-control" id="small_caption2" name="small_caption2" value="{{ old('small_caption2') }}" />
                           <span class="error" id="error_small_caption2"></span>
                           </div>
                        <div class="form-group col-sm-6">
                           <label for="caption">Link 1</label>
                           <input type="text" class="form-control" id="link1" name="link1" value="{{ old('link1') }}" />
                           <span class="error" id="error_link"></span>
                        </div>
                        <div class="form-group col-sm-6">
                           <label for="caption">Link Caption 1</label>
                           <input type="text" class="form-control" id="linkcaption" name="linkcaption" value="{{ old('linkcaption') }}" />
                           <span class="error" id="error_linkcaption"></span>
                        </div>

                         <div class="form-group col-sm-6">
                           <label for="caption">Link 2</label>
                           <input type="text" class="form-control" id="link2" name="link2" value="{{ old('link2') }}" />
                           <span class="error" id="error_link2"></span>
                        </div>
                        <div class="form-group col-sm-6">
                           <label for="caption">Link Caption 2</label>
                           <input type="text" class="form-control" id="linkcaption2" name="linkcaption2" value="{{ old('linkcaption2') }}" />
                           <span class="error" id="error_linkcaption2"></span>
                        </div>
                        <div class="form-group col-sm-6">
                           <label for="photo">Photo (1920 X 1080 pixels):</label>
                           <input type="file" class="form-control" id="photo" name="photo" />
                           <span class="error" id="error_photo"></span>
                        </div>
                        <div class="form-group col-sm-6">
                           <label for="caption">Photo text</label>
                           <input type="text" class="form-control" id="photo_text" name="photo_text" value="{{ old('photo_text') }}" />
                           <span class="error" id="error_caption"></span>
                        </div>
                        <div class="form-group col-sm-6">
                           <button type="submit" class="btn btn-primary">Submit</button>
                        </div>
                     </div>
                  </div>
               </form>
            </div>
         </div>
      </div>
   </div>
</div>
<script type="text/javascript" language="javascript" class="init">
   //view loanandadvance ajax
   $.ajaxSetup({
               headers: {
                  'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
               }
         });
   
   
   $(document).ready(function() {
      $("#frm_banner").submit(function(event) {
            event.preventDefault();
            var formData = new FormData($("#frm_banner")[0]);
            var files = $('#photo')[0].files;
            formData.append('photo', files[0]);
            var isValid = true;
   
           
// Caption 1 & 2
if ($("#caption1").val().trim() == "") {
    $("#error_caption1").html("Caption 1 is required.");
    isValid = false;
} else { $("#error_caption1").html(""); }

if ($("#caption2").val().trim() == "") {
    $("#error_caption2").html("Caption 2 is required.");
    isValid = false;
} else { $("#error_caption2").html(""); }

// Small Caption 1 & 2
if ($("#small_caption1").val().trim() == "") {
    $("#error_small_caption1").html("Small Caption 1 is required.");
    isValid = false;
} else { $("#error_small_caption1").html(""); }

if ($("#small_caption2").val().trim() == "") {
    $("#error_small_caption2").html("Small Caption 2 is required.");
    isValid = false;
} else { $("#error_small_caption2").html(""); }

// Link 1 & Link Caption 1
if ($("#link1").val().trim() == "") {
    $("#error_link1").html("Link 1 is required.");
    isValid = false;
} else { $("#error_link1").html(""); }

if ($("#linkcaption").val().trim() == "") {
    $("#error_linkcaption").html("Link Caption 1 is required.");
    isValid = false;
} else { $("#error_linkcaption").html(""); }

// Link 2 & Link Caption 2
if ($("#link2").val().trim() == "") {
    $("#error_link2").html("Link 2 is required.");
    isValid = false;
} else { $("#error_link2").html(""); }

if ($("#linkcaption2").val().trim() == "") {
    $("#error_linkcaption2").html("Link Caption 2 is required.");
    isValid = false;
} else { $("#error_linkcaption2").html(""); }


   	
            
            if (isValid)
               {  
               Swal.fire({
               title: 'Do you want to save the record?',
               text: '',
               icon: 'warning',
               showCancelButton: true,
               confirmButtonColor: '#3085d6',
               cancelButtonColor: '#d33',
               confirmButtonText: 'Yes, Continue'
               }).then((result) => {
               if (result.isConfirmed) {            
                  var url=$('#frm_banner').attr('action');
                  $.ajaxSetup({
                     headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                     }
                  });
               
                  $.ajax({
                     type: 'POST',
                     contentType: 'multipart/form-data',
                     cache: false,
                     contentType: false,
                     processData: false,
                     data: formData,
                     url: url,
                     success: function(response) {
                        if (response.success) {                                                 
                           Swal.fire({
                              icon: 'success',
                              title: 'Home Banner',
                              text: 'Home Banner added successfully!',
                           }).then(function() {
                                 window.location = "{{ route('admin.home.banner.view') }}";
                              });                          
                           
                        }
                        else {
                              Swal.fire({
                                 icon: 'error',
                                 title: 'Home Banner',
                                 text: 'Error Occured. Retry again.',
                              });
                        }
                     },
                     error: function(error) {
                        Swal.fire({
                              icon: 'error',
                              title: 'Home Banner',
                              text: 'Error submitting the form!',
                        });
                     }                                       
                  });  
               }
                  
      });
      }
   });
   }); 
</script>
@endsection