@extends('backend.layouts.master')
@section('content')           
<div class="container-fluid">
   <div class="row">
      <div class="col-sm-12">
         @include('backend.home.home_about.menu')
      </div>
      <div class="col-sm-12 col-lg-12">
         <div class="iq-card">
            <div class="iq-card-header d-flex justify-content-between">
               <div class="iq-header-title">
                  <h4 class="card-title">Home About</h4>
               </div>
            </div>
            <div class="iq-card-body">
               @if (count($errors) > 0)
               <div class="alert alert-danger">
                  <ul>
                     @foreach ($errors->all() as $error)
                     <li>{{ $error }}</li>
                     @endforeach
                  </ul>
               </div>
               @endif
               <form action="{{ route('admin.home.home_about.insert') }}" method="post" enctype="multipart/form-data" id="frm_home_about">
                  @csrf
                  <div class="container-fluid">
                     <div class="row">
                     <div class="form-group col-sm-6">
                        <label for="caption">Caption</label>
                        <input type="text" class="form-control" id="caption" name="caption" value="{{ old('caption') }}" />
                        <span class="error" id="error_caption"></span>
                     </div>
                     <div class="form-group col-sm-6">
                        <label for="experience">Experience</label>
                        <input type="text" class="form-control" id="experience" name="experience" value="{{ old('experience') }}" />
                        <span class="error" id="error_experience"></span>
                     </div>
                      </div>
                     <div class="form-group col-sm-12">
                        <label for="small_description">Small Description</label>
                        <textarea type="text" class="form-control ckeditor" id="small_description" name="small_description">{{ old('small_description') }}</textarea>
                     </div>
                     <div class="form-group col-sm-12">
                        <label for="caption">Description</label>
                        <textarea type="text" class="form-control ckeditor" id="description" name="description">{{ old('description') }}</textarea>
                     </div>
                     <div class="row">
                        <div class="form-group col-sm-6">
                           <label for="photo">Photo 1(1600 X 836 pixels):</label>
                           <input type="file" class="form-control" id="photo" name="photo" />
                           <span class="error" id="error_photo"></span>
                        </div>
                        <div class="form-group col-sm-6">
                           <label for="photo_text">Photo Text</label>
                           <input type="text" class="form-control" id="photo_text" name="photo_text" value="{{ old('photo_text') }}" />
                        </div>
                     </div>
                                          <div class="row">
                        <div class="form-group col-sm-6">
                           <label for="photo2">Photo 2(1600 X 836 pixels):</label>
                           <input type="file" class="form-control" id="photo2" name="photo2" />
                           <span class="error" id="error_photo2"></span>
                        </div>
                        <div class="form-group col-sm-6">
                           <label for="photo_text2">Photo Text</label>
                           <input type="text" class="form-control" id="photo_text2" name="photo_text2" value="{{ old('photo_text2') }}" />
                        </div>
                     </div>
                     <div class="row">
                        <div class="form-group col-sm-6">
                           <label for="photo3">Photo 3(1600 X 836 pixels):</label>
                           <input type="file" class="form-control" id="photo3" name="photo3" />
                           <span class="error" id="error_photo3"></span>
                        </div>
                        <div class="form-group col-sm-6">
                           <label for="photo_text3">Photo Text</label>
                           <input type="text" class="form-control" id="photo_text3" name="photo_text3" value="{{ old('photo_text3') }}" />
                        </div>
                     </div>
                     <div class="row">
                     <div class="form-group col-sm-6">
                        <label for="link_caption">Link Caption</label>
                        <input type="text" class="form-control" id="link_caption" name="link_caption" value="" />
                        <span class="error" id="error_link_caption"></span>
                     </div>
                     <div class="form-group col-sm-6">
                        <label for="link">Link</label>
                        <input type="text" class="form-control" id="link" name="link" value="" />
                        <span class="error" id="error_link"></span>
                     </div>
                      </div>
                     <div class="form-group col-sm-6">
                        <button type="submit" class="btn btn-primary">Submit</button>
                     </div>
                  </div>
               </form>
            </div>
         </div>
      </div>
   </div>
</div>
<script type="text/javascript" language="javascript" class="init">
   //view loanandadvance ajax
   $.ajaxSetup({
               headers: {
                  'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
               }
         });
   
   
   $(document).ready(function() {
      $("#frm_home_about").submit(function(event) {
            event.preventDefault();
            var formData = new FormData($("#frm_home_about")[0]);
   
            var files = $('#photo')[0].files;
            formData.append('photo', files[0]);

             var files = $('#photo2')[0].files;
            formData.append('photo2', files[0]);

            var files = $('#photo3')[0].files;
            formData.append('photo3', files[0]);
   
           
            var isValid = true;
   
            var small_descriptionData = CKEDITOR.instances.small_description.getData();
            formData.append('small_description', small_descriptionData);
                     
            var descriptionData = CKEDITOR.instances.description.getData();
            formData.append('description', descriptionData);
   
            if ($("#caption").val() == "") {
                  $("#error_caption").html("Caption   is required.");
                  isValid = false;
            } 
            else
            $("#error_caption").html("");

            if ($("#experience").val() == "") {
                  $("#error_experience").html("Experience   is required.");
                  isValid = false;
            } 
            else
            $("#error_experience").html("");

            
   
            if ($("#description").val() == "") {
                  $("#error_description").html("Description   is required.");
                  isValid = false;
            } 
            else
            $("#error_description").html("");     
            
            if ($("#photo").val() == "") {
                  $("#error_photo").html("Photo is required.");
                  isValid = false;
            } 
            else
            $("#error_photo").html("");
   
            
          
   
            if ($("#description").val() == "") {
                  $("#error_description").html("Description   is required.");
                  isValid = false;
            } 
            else
            $("#error_description").html("");     
            
           
            
            if (isValid)
               {  
               Swal.fire({
               title: 'Do you want to save the record?',
               text: '',
               icon: 'warning',
               showCancelButton: true,
               confirmButtonColor: '#3085d6',
               cancelButtonColor: '#d33',
               confirmButtonText: 'Yes, Continue'
               }).then((result) => {
               if (result.isConfirmed) {            
                  var url=$('#frm_home_about').attr('action');
                  $.ajaxSetup({
                     headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                     }
                  });
               
                  $.ajax({
                     type: 'POST',
                     contentType: 'multipart/form-data',
                     cache: false,
                     contentType: false,
                     processData: false,
                     data: formData,
                     url: url,
                     success: function(response) {
                        if (response.success) {                                                 
                           Swal.fire({
                              icon: 'success',
                              title: 'Home About',
                              text: 'Home About added successfully!',
                           }).then(function() {
                                 window.location = "{{ route('admin.home.home_about.view') }}";
                              });                          
                           
                        }
                        else {
                              Swal.fire({
                                 icon: 'error',
                                 title: 'Home About',
                                 text: 'Error Occured. Retry again.',
                              });
                        }
                     },
                     error: function(error) {
                        Swal.fire({
                              icon: 'error',
                              title: 'Home About',
                              text: 'Error submitting the form!',
                        });
                     }                                       
                  });  
               }
                  
      });
      }
   });
   }); 
</script>
@endsection