@extends('backend.layouts.master')
@section('content')           
<div class="container-fluid">
   <div class="row">
      <div class="col-sm-12">
         @include('backend.job.menu')
      </div>
      <div class="col-sm-12 col-lg-12">
         <div class="iq-card">
            <div class="iq-card-header d-flex justify-content-between">
               <div class="iq-header-title">
                  <h4 class="card-title">Hot Jobs/Top Employers</h4>
               </div>
            </div>
            <div class="iq-card-body">
               @if (count($errors) > 0)
               <div class="alert alert-danger">
                  <ul>
                     @foreach ($errors->all() as $error)
                     <li>{{ $error }}</li>
                     @endforeach
                  </ul>
               </div>
               @endif
               <form action="{{ route('admin.job.insert') }}" method="post" enctype="multipart/form-data" id="frm_job">
                  @csrf
                  <div class="container-fluid">
                     <div class="row">
                         <div class="form-group col-sm-6">
                           <label for="job_type">Hot Job/Top Employers</label>
                           <select name="job_type" id="job_type" class="form-control">
                              <option value="">Select Job Type</option>
                              <option value="1" {{ old('job_type') == '1' ? 'selected' : '' }}>Hot Job</option>
                              <option value="2" {{ old('job_type') == '2' ? 'selected' : '' }}>Top Employers</option>
                           </select>
                              <span class="error" id="error_job_type"></span>
                           </div>
                        <div class="form-group col-sm-6">
                           <label for="caption">Caption</label>
                           <input type="text" class="form-control" id="caption" name="caption" value="{{ old('caption') }}" />
                           <span class="error" id="error_caption"></span>
                        </div>
                        </div>
                        <div class="row">
                        <div class="form-group col-sm-6">
                           <label for="location">Location</label>
                           <input type="text" class="form-control" id="location" name="location" value="{{ old('location') }}" />
                           <span class="error" id="error_location"></span>
                        </div>
                        <div class="form-group col-sm-6">
                           <label for="link">Link</label>
                           <input type="text" class="form-control" id="link" name="link" value="{{ old('link') }}" />
                           <span class="error" id="error_link"></span>
                        </div>
                        </div>
                        <div class="row">
                        <div class="form-group col-sm-6">
                           <label for="photo">Photo (1600 X 836 pixels):</label>
                           <input type="file" class="form-control" id="photo" name="photo" />
                           <span class="error" id="error_photo"></span>
                        </div>
                        <div class="form-group col-sm-6">
                           <label for="photo_text">Photo Text</label>
                           <input type="text" class="form-control" id="photo_text" name="photo_text" value="{{ old('photo_text') }}" />
                           <span class="error" id="error_photo_text"></span>
                        </div>
                     </div>


                     </div>
                     
                     <div class="form-group col-sm-6">
                        <button type="submit" class="btn btn-primary">Submit</button>
                     </div>
                  </div>
               </form>
            </div>
         </div>
      </div>
   </div>
</div>
<script type="text/javascript" language="javascript" class="init">
   //view loanandadvance ajax
   $.ajaxSetup({
               headers: {
                  'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
               }
         });
   
   
   $(document).ready(function() {
      $("#frm_job").submit(function(event) {
            event.preventDefault();
            var formData = new FormData($("#frm_job")[0]);
   
            var files = $('#photo')[0].files;
            formData.append('photo', files[0]);


            var isValid = true;

   
            if ($("#caption").val() == "") {
                  $("#error_caption").html("Caption is required.");
                  isValid = false;
            } 
            else
            $("#error_caption").html("");

            if ($("#job_type").val() == "") {
                  $("#error_job_type").html("Hot Job/Top Employers is required.");
                  isValid = false;
            } 
            else
            $("#error_caption").html("");

            if ($("#photo").val() == "") {
                  $("#error_photo").html("Photo is required.");
                  isValid = false;
            } 
            else
            $("#error_photo").html("");
           
            
            if (isValid)
               {  
               Swal.fire({
               title: 'Do you want to save the record?',
               text: '',
               icon: 'warning',
               showCancelButton: true,
               confirmButtonColor: '#3085d6',
               cancelButtonColor: '#d33',
               confirmButtonText: 'Yes, Continue'
               }).then((result) => {
               if (result.isConfirmed) {            
                  var url=$('#frm_job').attr('action');
                  $.ajaxSetup({
                     headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                     }
                  });
               
                  $.ajax({
                     type: 'POST',
                     contentType: 'multipart/form-data',
                     cache: false,
                     contentType: false,
                     processData: false,
                     data: formData,
                     url: url,
                     success: function(response) {
                        if (response.success) {                                                 
                           Swal.fire({
                              icon: 'success',
                              title: 'Job',
                              text: 'Job added successfully!',
                           }).then(function() {
                                 window.location = "{{ route('admin.job.view') }}";
                              });                          
                           
                        }
                        else {
                              Swal.fire({
                                 icon: 'error',
                                 title: 'Job',
                                 text: 'Error Occured. Retry again.',
                              });
                        }
                     },
                     error: function(error) {
                        Swal.fire({
                              icon: 'error',
                              title: 'Job',
                              text: 'Error submitting the form!',
                        });
                     }                                       
                  });  
               }
                  
      });
      }
   });
   }); 
</script>
@endsection