@extends('backend.layouts.master')
@section('content')   
<div class="container-fluid">
   <div class="row">
      <div class="col-sm-12">
         @include('backend.job.menu')
      </div>
      <div class="col-sm-12">
         <div class="iq-card">
            <div class="iq-card-header d-flex justify-content-between">
               <div class="iq-header-title">
                  <h4 class="card-title">Hot Jobs/Top Employers</h4>
               </div>
            </div>
            <div class="iq-card-body">
               <div id="table" class="table-editable">
                  <table class="table table-bordered table-responsive-md table-striped" id="example">
                     <thead>
                        <tr>
                           <th>Sl No.</th>
                           <th>JobType</th>
                           <th>Caption</th>
                           <th>Location</th>
                           <th>Link</th>
                           <th>Photo</th>
                           <th>Action</th>
                        </tr>
                     </thead>
                     <tbody>                                  
                     </tbody>
                  </table>
               </div>
            </div>
         </div>
      </div>
   </div>
</div>
<script type="text/javascript" language="javascript" class="init">	
   $(document).ready(function() {
   $.ajaxSetup({
         headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
         }
   });
   var table =$('#example').DataTable( {
         "processing": true,
         "serverSide": true,
         'serverMethod': 'POST',
         "ajax": "{{ route('admin.job.ajaxview') }}",
         columns: [
               { data: 'DT_RowIndex', name: 'DT_RowIndex' },
               { data: 'job_type', name: 'job_type' },
               { data: 'caption', name: 'caption' },
               { data: 'location', name: 'location' },
               { data: 'link', name: 'link' },
               {
                     data: 'photo',
                     name: 'photo',
                     render: function(data, type, full, meta){
                        return "<img src='{{ asset('storage/assets/job/photo') }}/" + data + "' width='70' class='img-thumbnail' />";
                     },
                     orderable: false
               },
               { data: 'action', name: 'action', orderable: false, searchable: false }
            ]
      });
   
   $(document).on("click", ".deletebtn", function(e) {
      e.preventDefault(); 
      var id = $(this).attr('data-id');
   
      var url = '{{ route("admin.job.delete", ":id") }}';
      url = url.replace(':id', id);
      Swal.fire({
         title: 'Do you want to delete the record?',
         text: '',
         icon: 'warning',
         showCancelButton: true,
         confirmButtonColor: '#3085d6',
         cancelButtonColor: '#d33',
         confirmButtonText: 'Yes, Continue'
         }).then((result) => {
         if (result.isConfirmed) {  
            $.ajaxSetup({
               headers: {
                  'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
               }
         });
         
         $.ajax({
               type: "GET",
               url: url, 
               success: function(response) {
               refreshDataTable();
                  if (response.success) {                                                    
                     Swal.fire({
                     icon: 'success',
                     title: 'JOb',
                     text: 'JOb deleted successfully!',
                     });                           
                     
                  }
                  else {
                     Swal.fire({
                           icon: 'error',
                           title: 'JOb',
                           text: 'Error Occured. Retry again.',
                     });
                  }
               },
               error: function(error) {
                  Swal.fire({
                     icon: 'error',
                     title: 'JOb',
                     text: 'Error submitting the form!',
                  });
               }                                       
         }); 
   
         }
      });              
   }); 
   
   function refreshDataTable() {
   // Reinitialize DataTable
   table.ajax.reload();  
   }
      
   });
</script>
@endsection