@extends('backend.layouts.popupmaster')
@section('content')

<style>
    .container-fluid {
        font-family: 'Calibri', sans-serif;
        color: #2c3e50;
    }

    h4.text-center {
        margin-bottom: 20px;
        font-weight: 600;
        font-size: 22px;
        color: #000000ff;
    }

    .tableall {
        width: 100%;
        border-collapse: collapse;
        margin-bottom: 20px;
    }

    .tableall td, .tableall th {
        border: 1px solid #ddd;
        padding: 8px;
        font-size: 14px;
    }

    .tablehead {
        background-color: #f2f2f2;
        font-weight: 600;
        font-size: 15px;
        text-align: left;
        padding: 10px;
        color: #000;
    }

    .tableheadall {
        background-color: #e6f2ff;
        font-weight: 600;
        font-size: 14px;
        padding: 6px;
        width: 200px;
    }

    .tableleft {
        background-color: #f9f9f9;
        font-weight: 500;
        width: 200px;
        vertical-align: top;
    }

    .tableright {
        background-color: #ffffff;
        vertical-align: top;
        white-space: pre-line;
    }
</style>

<div class="container-fluid">

    <h4 class="text-center">Job Opening Details</h4>

    <!-- JOB INFORMATION -->
    <table class="tableall">
        <tbody>
            <tr>
                <td class="tablehead" colspan="2">Candidate Information</td>
            </tr>
            @if(!empty($job->candidate_id))
            <tr>
                <td class="tableleft">Candidate ID(Soho ID)</td>
                <td class="tableright">{{ $job->candidate_id }}</td>
            </tr>
            @endif

            @if(!empty($job->candidate_first_name))
            <tr>
                <td class="tableleft">Candidate Name</td>
                <td class="tableright">{{ $job->candidate_first_name }}</td>
            </tr>
            @endif

            @if(!empty($job->company_name))
            <tr>
                <td class="tableleft">Company Name</td>
                <td class="tableright">{{ $job->company_name }}</td>
            </tr>
            @endif

            @if(!empty($job->contact_person))
            <tr>
                <td class="tableleft">Contact Person</td>
                <td class="tableright">{{ $job->contact_person }}</td>
            </tr>
            @endif

            @if(!empty($job->email))
            <tr>
                <td class="tableleft">Email</td>
                <td class="tableright">{{ $job->email }}</td>
            </tr>
            @endif

            @if(!empty($job->phone))
            <tr>
                <td class="tableleft">Phone</td>
                <td class="tableright">{{ $job->phone }}</td>
            </tr>
            @endif
            <tr>
                <td class="tablehead" colspan="2">Company Information</td>
            </tr>
            @if(!empty($job->company_location))
            <tr>
                <td class="tableleft">Company Location</td>
                <td class="tableright">{{ $job->company_location }}</td>
            </tr>
            @endif

            @if(!empty($job->job_title))
            <tr>
                <td class="tableleft">Job Title</td>
                <td class="tableright">{{ $job->job_title }}</td>
            </tr>
            @endif

            @if(!empty($job->job_category))
            <tr>
                <td class="tableleft">Job Category</td>
                <td class="tableright">{{ $job->job_category }}</td>
            </tr>
            @endif

            @if(!empty($job->job_type))
            <tr>
                <td class="tableleft">Job Type</td>
                <td class="tableright">{{ $job->job_type }}</td>
            </tr>
            @endif

            @if(!empty($job->salary_range))
            <tr>
                <td class="tableleft">Salary Range</td>
                <td class="tableright">{{ $job->salary_range }}</td>
            </tr>
            @endif

            @if(!empty($job->work_location))
            <tr>
                <td class="tableleft">Work Location</td>
                <td class="tableright">{{ $job->work_location }}</td>
            </tr>
            @endif

            @if(!empty($job->job_description))
            <tr>
                <td class="tableleft" style="vertical-align: top;">Description</td>
                <td class="tableright">{!! nl2br($job->job_description) !!}</td>
            </tr>
            @endif

            @if(!empty($job->special_requirements))
            <tr>
                <td class="tableleft" style="vertical-align: top;">Special Requirements</td>
                <td class="tableright">{!! nl2br($job->special_requirements) !!}</td>
            </tr>
            @endif

            @if(!empty($job->company_profile_pdf))
            <tr>
                <td class="tableleft">Company Profile</td>
                <td class="tableright">
                    <a href="{{ asset('storage/assets/company_profile_pdf/' . $job->company_profile_pdf) }}" target="_blank">View PDF</a>
                </td>
            </tr>
            @endif

        </tbody>
    </table>

</div>

@endsection
