@extends('backend.layouts.master')
@section('content')

<div class="container-fluid">
    <div class="row mb-3">
        <div class="col-sm-12 text-right">
            <a class="btn btn-primary" href="{{ route('admin.job_openings') }}">
                <i class="ri-add-fill"></i> View All
            </a>
        </div>
    </div>



    <div class="row">
        <div class="col-sm-12">
            <div class="iq-card">
                <div class="iq-card-header">
                    <h4 class="card-title">Job Openings</h4>
                </div>
                <div class="row col-sm-12">
                    <div class="col-md-3">
                        <label class="form-label fw-semibold">Date From</label>
                        <input type="text" class="form-control datespicker" id="date_from" value="{{ $date_from }}">
                    </div>
                    <div class="col-md-3">
                        <label class="form-label fw-semibold">Date To</label>
                        <input type="text" class="form-control datespicker" id="date_to" value="{{ $date_to }}">
                    </div>
                    <div class="col-md-3">
                        <label class="form-label fw-semibold">Keyword</label>
                        <input type="text" class="form-control" id="keyword" placeholder="Search..." value="{{ $keyword }}">
                    </div>
                    <div class="col-md-3 mt-3">
                        <button class="btn btn-primary mt-2" id="filterBtn">Search</button>
                        <button class="btn btn-secondary mt-2" id="resetBtn">Reset</button>
                    </div>
                </div>
                <div class="iq-card-body">
                    <table class="table table-bordered table-striped" id="viewtable">
                        <thead>
                            <tr>
                                <th>SL No</th>
                                <th>Candidate Name</th>
                                <th>Company Name</th>
                                <th>Contact Person</th>
                                <th>Email</th>
                                <th>Phone</th>
                                <th>Location</th>
                                <th width="120">Action</th>
                            </tr>
                        </thead>
                        <tbody></tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
$(document).ready(function () {

    $.ajaxSetup({
        headers: { "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content") }
    });

    var table = $('#viewtable').DataTable({
        processing: true,
        serverSide: true,
        serverMethod: "POST",
        ajax: {
            url: "{{ route('admin.job_openings.ajaxview') }}",
            type: "POST",
            data: function (d) {
                d.keyword = $('#keyword').val();
                d.date_from = $('#date_from').val();
                d.date_to = $('#date_to').val();
            }
        },
        columns: [
            { data: 'DT_RowIndex', orderable: false, searchable: false },
            { data: 'candidate_first_name' },
            { data: 'company_name' },
            { data: 'contact_person' },
            { data: 'email' },
            { data: 'phone' },
            { data: 'company_location' },
            { data: 'action' },
        ]
    });

    $('#filterBtn').click(function() {
        table.ajax.reload();
    });

    $('#resetBtn').click(function() {
        $('#keyword').val('');
        $('#date_from').val('');
        $('#date_to').val('');
        table.ajax.reload();
    });
    $(' #keyword, #date_from, #date_to')
      .on('change keyup', function () {
        table.ajax.reload();
    });

    $(document).on("click", ".job_openings_details_btn", function (e) {
        e.preventDefault();
        var url = $(this).data('url');
        var width = 1000, height = 750;
        var left = (window.screen.width - width)/2;
        var top = (window.screen.height - height)/2;
        window.open(url, "_blank", "width="+width+",height="+height+",top="+top+",left="+left+",resizable=yes,scrollbars=yes");
    });

    $(document).on("click", ".deletejob_openings", function () {
        var id = $(this).data("id");
        var url = "{{ route('admin.job_openings.delete', ':id') }}".replace(':id', id);

        Swal.fire({
            title: "Are you sure?",
            text: "This action cannot be undone.",
            icon: "warning",
            showCancelButton: true,
            confirmButtonText: "Yes, delete it!",
        }).then((result) => {
            if (result.isConfirmed) {
                $.get(url, function (res) {
                    table.ajax.reload();
                    Swal.fire(
                        res.success ? "Deleted!" : "Failed",
                        res.message,
                        res.success ? "success" : "error"
                    );
                });
            }
        });
    });

});
</script>
<script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
<script>
    flatpickr(".datespicker", {
        dateFormat: "d-m-Y",
        allowInput: true,
        wrap: false
    });
</script>
@endsection
