<!doctype html>
<html lang="en">
   <head>
      <!-- Required meta tags -->
      <meta charset="utf-8">
      <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
      <title>Admin Panel</title>
      <!-- Favicon -->
      <link rel="icon" href="{{ asset('resources/assets/images/favicon-2.png') }}">
      <!-- Bootstrap CSS -->
      <link rel="stylesheet" href="{{asset('assets/backend/css/bootstrap.min.css')}}">
      <!-- Typography CSS -->
      <link rel="stylesheet" href="{{asset('assets/backend/css/typography.css')}}">
      <!-- Style CSS -->
      <link rel="stylesheet" href="{{asset('assets/backend/css/style.css')}}?v={{ time() }}">
      <!-- Responsive CSS -->
      <link rel="stylesheet" href="{{asset('assets/backend/css/responsive.css')}}">
      <!-- Full calendar -->
      <link href="{{asset('assets/backend/fullcalendar/core/main.css')}}" rel='stylesheet' />
      <link href="{{asset('assets/backend/fullcalendar/daygrid/main.css')}}" rel='stylesheet' />
      <link href="{{asset('assets/backend/fullcalendar/timegrid/main.css')}}" rel='stylesheet' />
      <link href="{{asset('assets/backend/fullcalendar/list/main.css')}}" rel='stylesheet' />
      <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
      
      <meta name="csrf-token" content="{{ csrf_token() }}">
      <link rel="stylesheet" type="text/css" href="{{asset('assets/backend/media/css/jquery.dataTables.css')}}">
      <script type="text/javascript" language="javascript" src="https://code.jquery.com/jquery-3.5.1.js"></script>
      <script type="text/javascript" language="javascript" src="{{asset('assets/backend/media/js/jquery.dataTables.js')}}"></script>	
      <link href="https://cdn.jsdelivr.net/npm/remixicon@2.5.0/fonts/remixicon.css" rel="stylesheet">
      <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
      <link href="{{ asset('resources/fullcalendar/core/main.css') }}" rel='stylesheet' />
      <link href="{{ asset('resources/fullcalendar/daygrid/main.css') }}" rel='stylesheet' />
      <link href="{{ asset('resources/fullcalendar/timegrid/main.css') }}" rel='stylesheet' />
      <link href="{{ asset('resources/fullcalendar/list/main.css') }}" rel='stylesheet' />
      <!-- SweetAlert2 CSS -->
      <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">
      <!-- SweetAlert2 JS -->
      <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>   
      <script src="{{ asset('assets/backend/ckeditor/ckeditor.js')}}"></script>
      <script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/buttons/2.1.0/js/dataTables.buttons.min.js"></script>
      <script type="text/javascript" charset="utf8" src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
      <script type="text/javascript" charset="utf8" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
      <script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/buttons/2.1.0/js/buttons.html5.min.js"></script>
   </head>
   <body>
      <!-- Wrapper Start -->
      <div class="wrapper">
         <!-- Sidebar  -->
         <div class="iq-sidebar">
            <div class="iq-sidebar-logo d-flex justify-content-between">
               <a href="{{ route('admin.login') }}">
               <span>Admin</span>
               </a>
               <div class="iq-menu-bt-sidebar">
                  <div class="iq-menu-bt align-self-center">
                     <div class="wrapper-menu">
                        <div class="main-circle"><i class="ri-more-fill"></i></div>
                        <div class="hover-circle"><i class="ri-more-2-fill"></i></div>
                     </div>
                  </div>
               </div>
            </div>
            <div id="sidebar-scrollbar">
               <nav class="iq-sidebar-menu">
                  <ul id="iq-sidebar-toggle" class="iq-menu">
                     <li class="active">
                        <a href="{{ route('admin.dashboard') }}" class="iq-waves-effect"><i class="ri-home" style="color:#000000;"></i><span>Dashboard</span></a>
                     </li>
                      <li>
                        <a href="#charts2" class="iq-waves-effect collapsed" data-toggle="collapse" aria-expanded="false"><i class="ri-home-4-line"></i><span>Home</span><i class="ri-arrow-right-s-line iq-arrow-right"></i></a>
                        <ul id="charts2" class="iq-submenu collapse" data-parent="#iq-sidebar-toggle">
                           <li>
                              <a href="{{ route('admin.home.banner.view') }}" class="iq-waves-effect collapsed"><i class="ri-user-3-fill"></i><span>Home Banner</span></a>
                           </li>
                           <li>
                              <a href="{{ route('admin.home.home_about.view') }}" class="iq-waves-effect collapsed"><i class="ri-user-3-fill"></i><span>Home About</span></a>
                           </li>
                         
                        </ul>
                     </li>
                      <li>
                              <a href="{{ route('admin.about.view') }}" class="iq-waves-effect collapsed"><i class="ri-user-3-fill"></i><span> About Us</span></a>
                           </li>
                     <li>
                        <a href="{{ route('admin.blogs.view') }}" class="iq-waves-effect collapsed"><i class="ri-user-3-fill"></i><span>Blog</span></a>
                     </li>
                       <li>
                        <a href="{{ route('admin.faq.view') }}" class="iq-waves-effect collapsed"><i class="ri-user-3-fill"></i><span>FAQ</span></a>
                     </li>
                     <li>
                        <a href="{{ route('admin.excellence.view') }}" class="iq-waves-effect collapsed"><i class="ri-user-3-fill"></i><span>Excellence</span></a>
                     </li>
                     <li>
                        <a href="{{ route('admin.expertise.view') }}" class="iq-waves-effect collapsed"><i class="ri-user-3-fill"></i><span>Expertise</span></a>
                     </li>
                           <li>
                        <a href="{{ route('admin.job.view') }}" class="iq-waves-effect collapsed"><i class="ri-at-fill"></i><span>Hot Jobs/Top Employers</span></a>
                     </li>
                     <li>
                        <a href="{{ route('admin.industry.view') }}" class="iq-waves-effect collapsed"><i class="ri-user-3-fill"></i><span>Industry</span></a>
                     </li>
                     <li>
                        <a href="{{ route('admin.services.view') }}" class="iq-waves-effect collapsed"><i class="ri-at-fill"></i><span>Services</span></a>
                     </li>
                      <li>
                        <a href="{{ route('admin.job_openings') }}" class="iq-waves-effect collapsed"><i class="ri-at-fill"></i><span>Job Openings</span></a>
                     </li>
                   
                     <li>
                        <a href="{{ route('admin.leadership_team.view') }}" class="iq-waves-effect collapsed"><i class="ri-user-3-fill"></i><span>Leadership Team</span></a>
                     </li>
                     <li>
                        <a href="{{ route('admin.testimonial.view') }}" class="iq-waves-effect collapsed"><i class="ri-user-3-fill"></i><span>Testimonials</span></a>
                     </li>
                   
                     <li>
                    
                     <li>
                        <a href="#charts" class="iq-waves-effect collapsed" data-toggle="collapse" aria-expanded="false"><i class="ri-settings-2-line"></i><span>Settings</span><i class="ri-arrow-right-s-line iq-arrow-right"></i></a>
                        <ul id="charts" class="iq-submenu collapse" data-parent="#iq-sidebar-toggle">
                           <li>
                              <a href="{{ route('admin.changepassword') }}#chang-pwd" class="iq-waves-effect collapsed"><i class="ri-user-3-fill"></i><span>Change Password</span></a>
                           </li>
                           <li>
                              <a href="{{ route('admin.users.view') }}" class="iq-waves-effect collapsed"><i class="ri-folders-fill"></i><span>Users</span></a>
                           </li>
                           @php /*
                           <li>
                              <a href="{{ route('cache.clear') }}" class="iq-waves-effect collapsed"><i class="ri-folders-fill"></i><span>Clear Cache</span></a>
                           </li>
                           <li>
                              <a href="{{ route('storage.link') }}" class="iq-waves-effect collapsed"><i class="ri-folders-fill"></i><span>Storage Link</span></a>
                           </li>
                           */ @endphp
                        </ul>
                     </li>
                     <li>
                        <a href="{{ route('admin.logout') }}" class="iq-waves-effect collapsed"><i class="ri-folders-fill"></i><span>Sign out</span></a>
                     </li>
                  </ul>
               </nav>
               <div class="p-3"></div>
            </div>
         </div>
         <!-- Page Content  -->
         <div id="content-page" class="content-page">
            <!-- TOP Nav Bar -->
            <div class="iq-top-navbar">
               <div class="iq-navbar-custom">
                  <div class="iq-sidebar-logo">
                     <div class="top-logo">
                        <a href="index.html" class="logo">
                        <img src="{{asset('assets/backend/images/logo.png')}}" class="img-fluid" alt="">
                        <span>Rak Lab</span>
                        </a>
                     </div>
                  </div>
                  <nav class="navbar navbar-expand-lg navbar-light p-0">
                     <div class="collapse navbar-collapse" id="navbarSupportedContent">
                        <div class="iq-search-bar">
                           @yield('toptitle')
                        </div>
                     </div>
                     <ul class="navbar-list">
                        <li>
                           <a href="#" class="search-toggle iq-waves-effect d-flex align-items-center">
                              <img src="{{ auth()->user()->profilephoto ? asset('assets/resources/backend/users/'.auth()->user()->profilephoto) : ((auth()->user()->sex == 1) ? asset('assets/backend/images/user/01.jpg') : asset('assets/backend/images/user/1.jpg'))}}" class="img-fluid rounded mr-3" alt="user">
                              <div class="caption">
                                 <h6 class="mb-0 line-height">@if(auth()->check()) {{ auth()->user()->name }} @endif</h6>
                                 <span class="font-size-12">Available</span>
                              </div>
                           </a>
                           <div class="iq-sub-dropdown iq-user-dropdown">
                              <div class="iq-card shadow-none m-0">
                                 <div class="iq-card-body p-0 ">
                                    <div class="bg-primary p-3">
                                       <h5 class="mb-0 text-white line-height">Hello @if(auth()->check()) {{ auth()->user()->name }} @endif</h5>
                                       <span class="text-white font-size-12">Available</span>
                                    </div>
                                    <a href="{{ route('admin.profileedit') }}" class="iq-sub-card iq-bg-primary-hover">
                                       <div class="media align-items-center">
                                          <div class="rounded iq-card-icon iq-bg-primary">
                                             <i class="ri-profile-line"></i>
                                          </div>
                                          <div class="media-body ml-3">
                                             <h6 class="mb-0 ">Edit Profile</h6>
                                             <p class="mb-0 font-size-12">Modify your personal details.</p>
                                          </div>
                                       </div>
                                    </a>
                                    <div class="d-inline-block w-100 text-center p-3">
                                       <a class="bg-primary iq-sign-btn" href="{{ route('admin.logout') }}" role="button">Sign out<i class="ri-login-box-line ml-2"></i></a>
                                    </div>
                                 </div>
                              </div>
                           </div>
                        </li>
                     </ul>
                  </nav>
               </div>
            </div>
            <!-- TOP Nav Bar END -->
            @yield('content')
            <!-- Footer -->
            <footer class="bg-white iq-footer">
               <div class="container-fluid">
                  <div class="row">
                     <div class="col-lg-6">
                        <ul class="list-inline mb-0">
                           <li class="list-inline-item"><a href="privacy-policy.html">Privacy Policy</a></li>
                           <li class="list-inline-item"><a href="terms-of-service.html">Terms of Use</a></li>
                        </ul>
                     </div>
                     <div class="col-lg-6 text-right">
                        Copyright <?php date('Y'); ?> All Rights Reserved.
                     </div>
                  </div>
               </div>
            </footer>
            <!-- Footer END -->
         </div>
      </div>
      <!-- Wrapper END -->
      <!-- Optional JavaScript -->
      <!-- jQuery first, then Popper.js, then Bootstrap JS -->
      <script src="{{asset('assets/backend/js/popper.min.js')}}"></script>
      <script src="{{asset('assets/backend/js/bootstrap.min.js')}}"></script>
      <!-- Appear JavaScript -->
      <script src="{{asset('assets/backend/js/jquery.appear.js')}}"></script>
      <!-- Countdown JavaScript -->
      <script src="{{asset('assets/backend/js/countdown.min.js')}}"></script>
      <!-- Counterup JavaScript -->
      <script src="{{asset('assets/backend/js/waypoints.min.js')}}"></script>
      <script src="{{asset('assets/backend/js/jquery.counterup.min.js')}}"></script>
      <!-- Wow JavaScript -->
      <script src="{{asset('assets/backend/js/wow.min.js')}}"></script>
      <!-- Apexcharts JavaScript -->
      <script src="{{asset('assets/backend/js/apexcharts.js')}}"></script>
      <!-- Slick JavaScript -->
      <script src="{{asset('assets/backend/js/slick.min.js')}}"></script>
      <!-- Select2 JavaScript -->
      <script src="{{asset('assets/backend/js/select2.min.js')}}"></script>
      <!-- Owl Carousel JavaScript -->
      <script src="{{asset('assets/backend/js/owl.carousel.min.js')}}"></script>
      <!-- Magnific Popup JavaScript -->
      <script src="{{asset('assets/backend/js/jquery.magnific-popup.min.js')}}"></script>
      <!-- Smooth Scrollbar JavaScript -->
      <script src="{{asset('assets/backend/js/smooth-scrollbar.js')}}"></script>
      <!-- lottie JavaScript -->
      <script src="{{asset('assets/backend/js/lottie.js')}}"></script>
      <!-- am core JavaScript -->
      <script src="{{asset('assets/backend/js/core.js')}}"></script>
      <!-- am charts JavaScript -->
      <script src="{{asset('assets/backend/js/charts.js')}}"></script>
      <!-- am map JavaScript -->
      <script src="{{asset('assets/backend/js/maps.js')}}"></script>
      <!-- am Worldlow JavaScript -->
      <script src="{{asset('assets/backend/js/worldLow.js')}}"></script>
      <!-- am animated JavaScript -->
      <script src="{{asset('assets/backend/js/animated.js')}}"></script>
      <!-- am kelly JavaScript -->
      <script src="{{asset('assets/backend/js/kelly.js')}}"></script>
      <!-- Chart Custom JavaScript -->
      <script src="{{asset('assets/backend/js/chart-custom.js')}}"></script>
      <!-- Custom JavaScript -->
      <script src="{{asset('assets/backend/js/custom.js')}}"></script>
      <script src="{{ asset('vendor/laravel-filemanager/js/stand-alone-button.js') }}"></script>
      <script>
         $(document).ready(function () {
            // Specify your custom URL
            var customUrl = "{{ url('filemanager') }}";
            // Initialize FileManager with the custom URL
            $('#lfm').filemanager('image', { prefix: customUrl });
         });
      </script>
      <script src="https://code.jquery.com/ui/1.13.2/jquery-ui.js"></script>
      <script>
         $( function() {
            $( ".datepicker" ).datepicker({ changeMonth: true, changeYear: true, dateFormat: "dd-mm-yy" });
         
            $('.selectdrop').select2();
            
            $(".selectdrop_add").select2({
               dropdownParent: $("#AddSettingsModal")
            });
            $(".selectdrop_edit").select2({
               dropdownParent: $("#EditSettingsModal")
            });
         
         
            $('.selectOptions').select2();
         } );
      </script>
      <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css">
      <script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>
   </body>
</html>