@extends('backend.layouts.master')
@section('content')           
<div class="container-fluid">
   <div class="row">
      <div class="col-sm-12">
         @include('backend.leadership_team.menu')
      </div>
      <div class="col-sm-12 col-lg-12">
         <div class="iq-card">
            <div class="iq-card-header d-flex justify-content-between">
               <div class="iq-header-title">
                  <h4 class="card-title">Edit Leadership Team</h4>
               </div>
            </div>
            <div class="iq-card-body">
               @if (count($errors) > 0)
               <div class="alert alert-danger">
                  <ul>
                     @foreach ($errors->all() as $error)
                     <li>{{ $error }}</li>
                     @endforeach
                  </ul>
               </div>
               @endif
               @if(isset($leadership_team)) 
               @foreach($leadership_team as $leadership_team1)
               <form action="{{ route('admin.leadership_team.updateleadership') }}" method="post" enctype="multipart/form-data" id="frm_leadership_team">
                  @csrf
                  <input type="hidden" class="form-control" id="id" name="id" value="{{ $leadership_team1->id }}" />
                  <div class="container-fluid">
                     <div class="row">
                        <div class="form-group col-sm-12">
                           <label for="caption">Caption</label>
                           <input type="text" class="form-control" id="caption" name="caption" value="{{ $leadership_team1->caption }}" />
                           <span class="error" id="error_caption"></span>
                        </div>
                     </div>

                     <div class="form-group col-sm-12">
                        <label for="small_description">Small Description</label>
                        <textarea type="text" class="form-control ckeditor" id="small_description" name="small_description">{{ $leadership_team1->small_description }}</textarea>
                        <span class="error" id="error_small_description"></span>
                     </div>
                  

                     <div class="form-group col-sm-12">
                        <div class="row">
                           <div class="col-md-6">
                              <label for="photo">Photo (750 X 600 pixels):</label>
                              <input type="file"  id="photo" name="photo"  width="300" />
                              <input type="hidden"  id="oldphoto" name="oldphoto"  value="{{ $leadership_team1->photo  }}" />
                              <span class="error" id="error_photo"></span>
                           </div>
                           <div class="col-md-6">
                              @if($leadership_team1->photo!="")
                              <img src="{{asset('storage/assets/leadership_team/photo/')}}/{{ $leadership_team1->photo }}" width="100" />
                              @endif
                           </div>
                        </div>
                     </div>
                     <div class="form-group col-sm-6">
                        <label for="photo_text">Photo Text</label>
                        <input type="text" class="form-control" id="photo_text" name="photo_text" value="{{ $leadership_team1->photo_text }}" />
                        <span class="error" id="error_photo_text"></span>
                     </div>
                     
                  </div>
                  

                  <div class="form-group col-sm-6">
                     <button type="submit" class="btn btn-primary">Update</button>
                  </div>
               </form>
               @endforeach                      
               @endif  
            </div>
         </div>
      </div>
   </div>
</div>
<script type="text/javascript" language="javascript" class="init">
   $.ajaxSetup({
      headers: {
         'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
      }
   });
   
   $(document).ready(function() {
       $("#frm_leadership_team").submit(function(event) {
           event.preventDefault();
           
           var formData = new FormData($("#frm_leadership_team")[0]);
   
           var photoFile = $('#photo')[0].files[0];
           if (photoFile) {
               formData.append('photo', photoFile);
           }
           
            var small_descriptionData = CKEDITOR.instances.small_description.getData();
            formData.append('small_description', small_descriptionData);


           var isValid = true;
   
           if ($("#caption").val() == "") {
               $("#error_caption").html("Caption is required.");
               isValid = false;
           } else {
               $("#error_caption").html("");
           }
      

           
           if (isValid)
               {  
               Swal.fire({
               title: 'Do you want to save the record?',
               text: 'Team',
               icon: 'warning',
               showCancelButton: true,
               confirmButtonColor: '#3085d6',
               cancelButtonColor: '#d33',
               confirmButtonText: 'Yes, Continue'
               }).then((result) => {
               if (result.isConfirmed) {            
                  var url=$('#frm_leadership_team').attr('action');
                  $.ajaxSetup({
                     headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                     }
                  });
               
                  $.ajax({
                     type: 'POST',
                     contentType: 'multipart/form-data',
                     cache: false,
                     contentType: false,
                     processData: false,
                     data: formData,
                     url: url,
                     success: function(response) {
                        if (response.success) {                                                 
                           Swal.fire({
                              icon: 'success',
                              title: ' Team',
                              text: 'Team Updated successfully!',
                           }).then(function() {
                                 window.location = "{{ route('admin.leadership_team.view') }}";
                              });                          
                           
                        }
                        else {
                              Swal.fire({
                                 icon: 'error',
                                 title: ' Team',
                                 text: 'Error Occured. Retry again.',
                              });
                        }
                     },
                     error: function(error) {
                        Swal.fire({
                              icon: 'error',
                              title: ' About Us',
                              text: 'Error submitting the form!',
                        });
                     }                                       
                  });  
               }
               });
           }
       });
   });
   
</script>
@endsection