<!doctype html>
<html lang="en">
   <head>
      <!-- Required meta tags -->
      <meta charset="utf-8">
      <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
      <title>Admin Panel</title>
      <!-- Favicon -->
      <link rel="icon" href="{{ asset('resources/assets/images/favicon.png') }}">  
      <!-- Bootstrap CSS -->
      <link rel="stylesheet" href="{{asset('assets/backend/css/bootstrap.min.css')}}">
      <!-- Typography CSS -->
      <link rel="stylesheet" href="{{asset('assets/backend/css/typography.css')}}">
      <!-- Style CSS -->
      <link rel="stylesheet" href="{{asset('assets/backend/css/style.css')}}">
      <!-- Responsive CSS -->
      <link rel="stylesheet" href="{{asset('assets/backend/css/responsive.css')}}">
   </head>
   <body>
     
        <!-- Sign in Start -->
        <section class="sign-in-page">
            <div class="container  mt-5 p-0">
                <div class="row no-gutters">
                    <div class="col-md-3 text-center">
                        
                    </div>
                    <div class="col-md-6 position-relative">
                        <div class="sign-in-from">
                            <h2 class="mb-0">Sign in</h2>
                            <p>Enter your email address and password to access admin panel.</p>

                            @if ($errors->has('email'))                               
                                <div class="custom-control custom-checkbox custom-checkbox-color-check custom-control-inline">
                                <input type="checkbox" class="custom-control-input bg-danger" id="customCheck-3" checked="">
                                <label class="custom-control-label" for="customCheck-3">{{ $errors->first('email') }}</label>
                                </div> 
                            @endif
                            <form class="mt-4" method="post" action="{{ route('admin.login.submit') }}">
                                @csrf
                                <div class="form-group">
                                    <label for="exampleInputEmail1">Email address</label>
                                    <input type="email" class="form-control mb-0" id="email" name="email" placeholder="Enter email" value="{{ old('email') }}">
                                </div>
                                <div class="form-group">
                                    <label for="exampleInputPassword1">Password</label>
                                    <input type="password" class="form-control mb-0" id="password" name="password" placeholder="Password">
                                </div>
                                <div class="d-inline-block w-100">
                                    <div class="custom-control custom-checkbox d-inline-block mt-2 pt-1">
                                        <input type="checkbox" class="custom-control-input" id="customCheck1">
                                    </div>
                                    <button type="submit" class="btn btn-primary float-right">Sign in</button>
                                </div>
                                
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- Sign in END -->
      <!-- Optional JavaScript -->
      <!-- jQuery first, then Popper.js, then Bootstrap JS -->
      <script src="{{asset('assets/backend/js/jquery.min.js')}}"></script>
      <script src="{{asset('assets/backend/js/popper.min.js')}}"></script>
      <script src="{{asset('assets/backend/js/bootstrap.min.js')}}"></script>
      <!-- Appear JavaScript -->
      <script src="{{asset('assets/backend/js/jquery.appear.js')}}"></script>
      <!-- Countdown JavaScript -->
      <script src="{{asset('assets/backend/js/countdown.min.js')}}"></script>
      <!-- Counterup JavaScript -->
      <script src="{{asset('assets/backend/js/waypoints.min.js')}}"></script>
      <script src="{{asset('assets/backend/js/jquery.counterup.min.js')}}"></script>
      <!-- Wow JavaScript -->
      <script src="{{asset('assets/backend/js/wow.min.js')}}"></script>
      <!-- Apexcharts JavaScript -->
      <script src="{{asset('assets/backend/js/apexcharts.js')}}"></script>
      <!-- Slick JavaScript -->
      <script src="{{asset('assets/backend/js/slick.min.js')}}"></script>
      <!-- Select2 JavaScript -->
      <script src="{{asset('assets/backend/js/select2.min.js')}}"></script>
      <!-- Owl Carousel JavaScript -->
      <script src="{{asset('assets/backend/js/owl.carousel.min.js')}}"></script>
      <!-- Magnific Popup JavaScript -->
      <script src="{{asset('assets/backend/js/jquery.magnific-popup.min.js')}}"></script>
      <!-- Smooth Scrollbar JavaScript -->
      <script src="{{asset('assets/backend/js/smooth-scrollbar.js')}}"></script>
      <!-- Chart Custom JavaScript -->
      <script src="{{asset('assets/backend/js/chart-custom.js')}}"></script>
      <!-- Custom JavaScript -->
      <script src="{{asset('assets/backend/js/custom.js')}}"></script>
   </body>
</html>