@extends('backend.layouts.master')
@section('content')           
<div class="container-fluid">
   <div class="row">
      <div class="col-sm-12">
         @include('backend.services.menu')
      </div>
      <div class="col-sm-12 col-lg-12">
         <div class="iq-card">
            <div class="iq-card-header d-flex justify-content-between">
               <div class="iq-header-title">
                  <h4 class="card-title"> Services</h4>
               </div>
            </div>
            <div class="iq-card-body">
               @if (count($errors) > 0)
               <div class="alert alert-danger">
                  <ul>
                     @foreach ($errors->all() as $error)
                     <li>{{ $error }}</li>
                     @endforeach
                  </ul>
               </div>
               @endif
               <form action="{{ route('admin.services.insert') }}" method="post" enctype="multipart/form-data" id="frm_services">
                  @csrf
                  <div class="container-fluid">
                     <div class="row">
                        <div class="form-group col-sm-6">
                           <label for="caption">Caption</label>
                           <input type="text" class="form-control" id="caption" name="caption" value="{{ old('caption') }}" />
                           <span class="error" id="error_caption"></span>
                        </div>
                        <div class="form-group col-sm-6">
                           <label for="small_caption">Small Caption</label>
                           <input type="text" class="form-control" id="small_caption" name="small_caption" value="{{ old('small_caption') }}" />
                           <span class="error" id="error_small_caption"></span>
                        </div>

                        <div class="form-group col-sm-12">
                           <label for="small_description">Small Description</label>
                           <textarea type="text" class="form-control ckeditor" id="small_description" name="small_description">{{ old('small_description') }}</textarea>
                           <span class="error" id="error_small_description"></span>
                        </div>
                         <div class="form-group col-sm-6">
                           <label for="link">Link</label>
                           <input type="text" class="form-control" id="link" name="link" value="{{ old('link') }}" />
                           <span class="error" id="error_link"></span>
                        </div>
                        <div class="form-group col-sm-6">
                           <label for="link_caption">Link Caption</label>
                           <input type="text" class="form-control" id="link_caption" name="link_caption" value="{{ old('link_caption') }}" />
                           <span class="error" id="error_link_caption"></span>
                        </div>
                        <div class="form-group col-sm-6">
                           <label for="banner_photo">Banner Photo(1600 X 836 pixels):</label>
                           <input type="file" class="form-control" id="banner_photo" name="banner_photo" />
                           <span class="error" id="error_banner_photo"></span>
                        </div>

                        <div class="form-group col-sm-6">
                           <label for="banner_photo_text">Banner Photo Text</label>
                           <input type="text" class="form-control" id="banner_photo_text" name="banner_photo_text" value="{{ old('banner_photo_text') }}" />
                           <span class="error" id="error_banner_photo_text"></span>
                        </div>
                        <div class="form-group col-sm-6">
                           <label for="photo">Photo(1600 X 836 pixels):</label>
                           <input type="file" class="form-control" id="photo" name="photo" />
                           <span class="error" id="error_photo"></span>
                        </div>

                        <div class="form-group col-sm-6">
                           <label for="photo_text">Photo Text</label>
                           <input type="text" class="form-control" id="photo_text" name="photo_text" value="{{ old('photo_text') }}" />
                           <span class="error" id="error_photo_text"></span>
                        </div>
                        <div class="form-group col-sm-12">
                           <label for="caption">Description</label>
                           <textarea type="text" class="form-control ckeditor" id="description" name="description">{{ old('description') }}</textarea>
                           <span class="error" id="error_description"></span>
                        </div>

                        <div class="form-group col-sm-6">
                           <label for="description_photo"> Description Photo (1600 X 836 pixels):</label>
                           <input type="file" class="form-control" id="description_photo" name="description_photo" />
                           <span class="error" id="error_description_photo"></span>
                        </div>

                        <div class="form-group col-sm-6">
                           <label for="description_photo_text" > Description Photo Text</label>
                           <input type="text" class="form-control" id="description_photo_text" name="description_photo_text" value="{{ old('photo_text1') }}" />
                           <span class="error" id="error_description_photo_text"></span>
                        </div>
                         <div class="form-group col-sm-6">
                           <label for="description_link">Description Link</label>
                           <input type="text" class="form-control" id="description_link" name="description_link" value="{{ old('description_link') }}" />
                           <span class="error" id="error_description_link"></span>
                        </div>
                        <div class="form-group col-sm-6">
                           <label for="description_link_caption"> Description Link Caption</label>
                           <input type="text" class="form-control" id="description_link_caption" name="description_link_caption" value="{{ old('description_link_caption') }}" />
                           <span class="error" id="error_description_link_caption"></span>
                        </div>
                        <div class="form-group col-sm-12">
                           <label for="feature_caption">Feature Caption</label>
                           <input type="text" class="form-control" id="feature_caption" name="feature_caption" value="{{ old('feature_caption') }}" />
                           <span class="error" id="error_feature_caption"></span>
                        </div>

                        <div class="form-group col-sm-12">
                           <label for="feature_description">Feature Description</label>
                           <textarea type="text" class="form-control ckeditor" id="feature_description" name="feature_description">{{ old('feature_description') }}</textarea>
                           <span class="error" id="error_feature_description"></span>
                        </div>

                        <div class="form-group col-sm-6">
                           <label for="seo_url">SEO Url</label>
                           <input type="text" class="form-control" id="seo_url" name="seo_url" value="{{ old('seo_url') }}" />
                           <span class="error" id="error_seo_url"></span>
                        </div>

                        <div class="form-group col-sm-6">
                           <label for="seo_title"> SEO Title</label>
                           <textarea type="text" class="form-control" id="seo_title" name="seo_title" rows="3">{{ old('seo_title') }}</textarea>
                        </div>
                        
                        <div class="form-group col-sm-6">
                           <label for="seo_keyword"> SEO Keyword</label>
                           <textarea type="text" class="form-control" id="seo_keyword" name="seo_keyword" rows="3">{{ old('seo_keyword') }}</textarea>
                        </div>

                        <div class="form-group col-sm-6">
                           <label for="seo_description"> SEO Description</label>
                           <textarea type="text" class="form-control" id="seo_description" name="seo_description" rows="3">{{ old('seo_description') }}</textarea>
                        </div>
                     </div>

                     <div class="form-group col-sm-6">
                        <button type="submit" class="btn btn-primary">Submit</button>
                     </div>
                  </div>
               </form>
            </div>
         </div>
      </div>
   </div>
</div>
<script type="text/javascript" language="javascript" class="init">
   //view loanandadvance ajax
   $.ajaxSetup({
      headers: {
         'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
      }
   });
   
   $(document).ready(function() {
      $("#frm_services").submit(function(event) {
            event.preventDefault();
            var formData = new FormData($("#frm_services")[0]);
   
            var files = $('#photo')[0].files;
            formData.append('photo', files[0]);

            var files = $('#description_photo')[0].files;
            formData.append('description_photo', files[0]);

            var files = $('#banner_photo')[0].files;
            formData.append('banner_photo', files[0]);
   
            var isValid = true;

            var small_descriptionData = CKEDITOR.instances.small_description.getData();
            formData.append('small_description', small_descriptionData);

            var descriptionData = CKEDITOR.instances.description.getData();
            formData.append('description', descriptionData);

            var feature_descriptionData = CKEDITOR.instances.feature_description.getData();
            formData.append('feature_description', feature_descriptionData);
            

              if ($("#caption").val() == "") {
               $("#error_caption").html("Caption is required.");
               isValid = false;
           } else {
               $("#error_caption").html("");
           }


              if ($("#small_caption").val() == "") {
               $("#error_small_caption").html("Small Caption is required.");
               isValid = false;
           } else {
               $("#error_small_caption").html("");
           }
      
           if ($("#description").val() == "") {
               $("#error_description").html("Description is required.");
               isValid = false;
           } 
           else {
               $("#error_description").html("");
           }
   
            if ($("#feature_caption").val() == "") {
               $("#error_feature_caption").html("Feature Caption is required.");
               isValid = false;
            } 
            else
            $("#error_feature_caption").html("");   
        
            if ($("#feature_description").val() == "") {
               $("#error_feature_description").html("Feature Description is required.");
               isValid = false;
            } 
            else
            $("#error_feature_description").html("");   

            


            
            if ($("#photo").val() == "") {
               $("#error_photo").html("Photo is required.");
               isValid = false;
            } 
            else
            $("#error_photo").html("");


                       if ($("#description").val() == "") {
               $("#error_description").html("Description is required.");
               isValid = false;
           } 
           else {
               $("#error_description").html("");
           }


            if ($("#description_photo").val() == "") {
               $("#error_description_photo").html("Description Photo is required.");
               isValid = false;
            } 
            else
            $("#error_description_photo").html("");

            if($("#seo_url").val() == "") {
                  $("#error_seo_url").html("SEO Url is required.");
                  isValid = false;
            } 
            else
            $("#error_seo_url").html("");
   
            if (isValid)
               {  
               Swal.fire({
               title: 'Do you want to save the record?',
               text: '',
               icon: 'warning',
               showCancelButton: true,
               confirmButtonColor: '#3085d6',
               cancelButtonColor: '#d33',
               confirmButtonText: 'Yes, Continue'
               }).then((result) => {
               if (result.isConfirmed) {            
                  var url=$('#frm_services').attr('action');
                  $.ajaxSetup({
                     headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                     }
                  });
               
                  $.ajax({
                     type: 'POST',
                     contentType: 'multipart/form-data',
                     cache: false,
                     contentType: false,
                     processData: false,
                     data: formData,
                     url: url,
                     success: function(response) {
                        if (response.success) {                                                 
                           Swal.fire({
                              icon: 'success',
                              title: 'Services',
                              text: 'Services added successfully!',
                           }).then(function() {
                              window.location = "{{ route('admin.services.view') }}";
                           });                          
                           
                        }
                        else {
                           Swal.fire({
                              icon: 'error',
                              title: 'Services',
                              text: 'Error Occured. Retry again.',
                           });
                        }
                     },
                     error: function(error) {
                        Swal.fire({
                           icon: 'error',
                           title: 'Services',
                           text: 'Error submitting the form!',
                        });
                     }                                       
                  });  
               }           
            });
         }
      });
   }); 
</script>
<script>
$(document).on("keyup change", "#caption", function () {
    let caption = $(this).val();
    let seo = caption.toLowerCase()
                     .replace(/\s+/g, '-')
                     .replace(/[^a-z0-9-]/g, '')
                     .replace(/-+/g, '-')
                     .replace(/^-+|-+$/g, '');
    $("#seo_url").val(seo);
});
</script>
@endsection